/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.basic;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropNbEdges
extends Propagator<Variable> {
    protected GraphVar g;
    protected IntVar k;

    public PropNbEdges(GraphVar graph, IntVar k) {
        super(new Variable[]{graph, k}, (Priority)PropagatorPriority.LINEAR, false);
        this.g = graph;
        this.k = k;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int nbK = 0;
        int nbE = 0;
        ISet env = this.g.getPotentialNodes();
        ISetIterator iSetIterator = env.iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            nbE += this.g.getPotentialSuccessorsOf(i).size();
            nbK += this.g.getMandatorySuccessorsOf(i).size();
        }
        if (!this.g.isDirected()) {
            nbK /= 2;
            nbE /= 2;
        }
        this.filter(nbK, nbE);
    }

    private void filter(int nbK, int nbE) throws ContradictionException {
        this.k.updateLowerBound(nbK, (ICause)this);
        this.k.updateUpperBound(nbE, (ICause)this);
        if (nbK != nbE && this.k.isInstantiated()) {
            ISet nei;
            ISet env = this.g.getPotentialNodes();
            if (this.k.getValue() == nbE) {
                ISetIterator iSetIterator = env.iterator();
                while (iSetIterator.hasNext()) {
                    int i = (Integer)iSetIterator.next();
                    nei = this.g.getUB().getSuccessorsOf(i);
                    ISetIterator iSetIterator2 = nei.iterator();
                    while (iSetIterator2.hasNext()) {
                        int j = (Integer)iSetIterator2.next();
                        this.g.enforceEdge(i, j, this);
                    }
                }
            }
            if (this.k.getValue() == nbK) {
                ISetIterator iSetIterator = env.iterator();
                while (iSetIterator.hasNext()) {
                    int i = (Integer)iSetIterator.next();
                    nei = this.g.getUB().getSuccessorsOf(i);
                    ISet neiKer = this.g.getLB().getSuccessorsOf(i);
                    ISetIterator iSetIterator3 = nei.iterator();
                    while (iSetIterator3.hasNext()) {
                        int j = (Integer)iSetIterator3.next();
                        if (neiKer.contains(j)) continue;
                        this.g.removeEdge(i, j, this);
                    }
                }
            }
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return GraphEventType.REMOVE_EDGE.getMask() + GraphEventType.ADD_EDGE.getMask();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public ESat isEntailed() {
        int nbK = 0;
        int nbE = 0;
        ISet env = this.g.getPotentialNodes();
        ISetIterator iSetIterator = env.iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            nbE += this.g.getUB().getSuccessorsOf(i).size();
            nbK += this.g.getLB().getSuccessorsOf(i).size();
        }
        if (!this.g.isDirected()) {
            nbK /= 2;
            nbE /= 2;
        }
        if (nbK > this.k.getUB() || nbE < this.k.getLB()) {
            return ESat.FALSE;
        }
        if (this.k.isInstantiated() && this.g.isInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

