/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.dk.sqrt;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.GeneralMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.StateInfo;
import jdplus.toolkit.base.core.ssf.akf.AugmentedState;
import jdplus.toolkit.base.core.ssf.dk.BaseDiffuseSmoother;
import jdplus.toolkit.base.core.ssf.dk.DkToolkit;
import jdplus.toolkit.base.core.ssf.dk.sqrt.DefaultDiffuseSquareRootFilteringResults;
import jdplus.toolkit.base.core.ssf.univariate.ISmoothingResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.OrdinarySmoother;

public class DiffuseSquareRootSmoother
extends BaseDiffuseSmoother {
    private AugmentedState state;
    private DefaultDiffuseSquareRootFilteringResults frslts;

    public static Builder builder(ISsf ssf) {
        return new Builder(ssf);
    }

    private DiffuseSquareRootSmoother(ISsf ssf, boolean calcvar, boolean rescalevar) {
        super(ssf, calcvar, rescalevar);
    }

    public boolean process(ISsfData data, ISmoothingResults sresults) {
        DefaultDiffuseSquareRootFilteringResults fresults = DkToolkit.sqrtFilter(this.ssf, data, true);
        return this.process(data.length(), fresults, sresults);
    }

    public boolean process(int endpos, DefaultDiffuseSquareRootFilteringResults results, ISmoothingResults sresults) {
        this.frslts = results;
        this.srslts = sresults;
        this.initSmoother();
        this.ordinarySmoothing(this.ssf, endpos);
        int t = this.frslts.getEndDiffusePosition();
        while (--t >= 0) {
            this.loadInfo(t);
            this.iterate(t);
            if (this.srslts == null) continue;
            this.srslts.save(t, this.state, StateInfo.Smoothed);
            this.srslts.saveSmoothation(t, this.u, this.uVariance);
            this.srslts.saveR(t, this.Rf, this.N0);
        }
        if (this.rescalevar) {
            this.srslts.rescaleVariances(this.frslts.var());
        }
        return true;
    }

    private void initSmoother() {
        ISsfInitialization initialization = this.ssf.initialization();
        int dim = initialization.getStateDim();
        this.state = new AugmentedState(dim, initialization.getDiffuseDim());
        this.Rf = DataBlock.make(dim);
        this.C = DataBlock.make(dim);
        this.Ri = DataBlock.make(dim);
        this.Ci = DataBlock.make(dim);
        if (this.calcvar) {
            this.tmp0 = DataBlock.make(dim);
            this.tmp1 = DataBlock.make(dim);
            this.N0 = FastMatrix.square(dim);
            this.N1 = FastMatrix.square(dim);
            this.N2 = FastMatrix.square(dim);
            this.Z = DataBlock.make(dim);
            if (this.loading.isTimeInvariant()) {
                this.Z.set(0.0);
                this.loading.Z(0, this.Z);
            }
        }
    }

    private void loadInfo(int pos) {
        this.e = this.frslts.error(pos);
        this.f = this.frslts.errorVariance(pos);
        this.fi = this.frslts.diffuseNorm2(pos);
        this.missing = !Double.isFinite(this.e);
        this.state.a().copy(this.frslts.a(pos));
        if (!this.missing) {
            this.C.copy(this.frslts.M(pos));
            if (this.fi != 0.0) {
                this.Ci.copy(this.frslts.Mi(pos));
                this.Ci.mul(1.0 / this.fi);
                this.C.addAY(-this.f, this.Ci);
                this.C.mul(1.0 / this.fi);
            } else {
                this.C.mul(1.0 / this.f);
                this.Ci.set(0.0);
            }
        } else {
            this.e = 0.0;
        }
        if (this.calcvar) {
            if (!this.loading.isTimeInvariant()) {
                this.Z.set(0.0);
                this.loading.Z(pos, this.Z);
            }
            this.state.P().copy(this.frslts.P(pos));
            this.state.restoreB(this.frslts.B(pos));
        }
    }

    @Override
    protected void updateA(int pos) {
        DataBlock a = this.state.a();
        a.addProduct(this.Rf, this.frslts.P(pos).columnsIterator());
        FastMatrix B = this.frslts.B(pos);
        DataBlock tmp = DataBlock.make(B.getColumnsCount());
        tmp.product(this.Ri, B.columnsIterator());
        a.addProduct(tmp, B.rowsIterator());
    }

    @Override
    protected void updateP(int pos) {
        FastMatrix P = this.state.P();
        FastMatrix PN0P = SymmetricMatrix.XtSX(this.N0, P);
        FastMatrix BN2B = SymmetricMatrix.XtSX(this.N2, this.state.B());
        FastMatrix PN2P = SymmetricMatrix.XSXt(BN2B, this.state.B());
        FastMatrix N1B = GeneralMatrix.AB(this.N1, this.state.B());
        FastMatrix PN1B = GeneralMatrix.AB(P, N1B);
        FastMatrix PN1Pi = GeneralMatrix.ABt(PN1B, this.state.B());
        PN0P.add(PN2P);
        PN0P.add(PN1Pi);
        PN0P.addTranspose(PN1Pi);
        SymmetricMatrix.reenforceSymmetry(PN0P);
        P.sub(PN0P);
    }

    private void ordinarySmoothing(ISsf ssf, int endpos) {
        OrdinarySmoother smoother = OrdinarySmoother.builder(ssf).calcVariance(this.calcvar).build();
        smoother.process(this.frslts.getEndDiffusePosition(), endpos, this.frslts, this.srslts);
        this.Rf.copy(smoother.getFinalR());
        if (this.calcvar) {
            this.N0.copy(smoother.getFinalN());
        }
    }

    public DefaultDiffuseSquareRootFilteringResults getFilteringResults() {
        return this.frslts;
    }

    public static class Builder {
        private final ISsf ssf;
        private boolean rescaleVariance = false;
        private boolean calcVariance = true;

        public Builder(ISsf ssf) {
            this.ssf = ssf;
        }

        public Builder rescaleVariance(boolean rescale) {
            this.rescaleVariance = rescale;
            if (rescale) {
                this.calcVariance = true;
            }
            return this;
        }

        public Builder calcVariance(boolean calc) {
            this.calcVariance = calc;
            if (!calc) {
                this.rescaleVariance = false;
            }
            return this;
        }

        public DiffuseSquareRootSmoother build() {
            return new DiffuseSquareRootSmoother(this.ssf, this.calcVariance, this.rescaleVariance);
        }
    }
}

