/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x13.regarima;

import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.arima.SarmaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regarima.RegArimaUtility;
import jdplus.toolkit.base.core.regsarima.regular.IDifferencingModule;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.sarima.estimation.HannanRissanen;
import jdplus.toolkit.base.core.sarima.estimation.SarimaMapping;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;
import jdplus.x13.base.api.regarima.RegArimaException;
import jdplus.x13.base.core.x13.regarima.X13Utility;

public class DifferencingModule
implements IDifferencingModule {
    public static final int MAXD = 2;
    public static final int MAXBD = 1;
    private double[] x;
    private SarimaOrders spec;
    private SarimaModel lastModel;
    private double rmax;
    private double rsmax;
    private double c_;
    private int iter;
    private boolean useml;
    private boolean mlused;
    private double tmean;
    private boolean mu;
    private final int maxd;
    private final int maxbd;
    private final double ub1;
    private final double ub2;
    private final double cancel;
    private final double eps;
    private final boolean ml;

    public static Builder builder() {
        return new Builder();
    }

    private static double removeMean(DataBlock x) {
        double m = x.average();
        x.sub(m);
        return m;
    }

    public DifferencingModule(int maxd, int maxbd, double ub1, double ub2, double cancel, boolean ml, double eps) {
        this.maxd = maxd;
        this.maxbd = maxbd;
        this.ub1 = ub1;
        this.ub2 = ub2;
        this.cancel = cancel;
        this.eps = eps;
        this.ml = ml;
    }

    private void allcond() {
        if (this.spec.getD() + this.spec.getBd() != 0) {
            return;
        }
        double ar = this.lastModel.phi(1);
        if (!this.hasSeas()) {
            if (Math.abs(ar + 1.0) <= 0.15) {
                this.spec.setD(this.spec.getD() + 1);
            }
        } else {
            double sar = this.lastModel.bphi(1);
            if (Math.abs(ar + 1.0) <= 0.15 || Math.abs(sar + 1.0) <= 0.25) {
                this.rmax = -ar;
                this.rsmax = -sar;
                if (ar < sar) {
                    this.spec.setD(this.spec.getD() + 1);
                } else {
                    this.spec.setBd(this.spec.getBd() + 1);
                }
            }
        }
    }

    private boolean calc() {
        this.c_ = this.cancel;
        this.useml = false;
        this.mlused = false;
        this.rsmax = 0.0;
        this.rmax = 0.0;
        this.tmean = 0.0;
        this.mu = false;
        this.step0();
        this.iter = 0;
        while (this.nextstep() && this.iter < 5) {
            ++this.iter;
        }
        this.calcMean();
        return true;
    }

    public void clear() {
        this.lastModel = null;
        this.spec = null;
        this.x = null;
        this.useml = false;
        this.iter = 0;
        this.rmax = 0.0;
        this.rsmax = 0.0;
        this.c_ = 0.0;
    }

    private int cond1(int icon) {
        if (this.spec.getD() + this.spec.getBd() != 0) {
            return icon;
        }
        double ar = this.lastModel.phi(1);
        double ma = this.lastModel.theta(1);
        double sar = 0.0;
        double sma = 0.0;
        if (this.hasSeas()) {
            sar = this.lastModel.bphi(1);
            sma = this.lastModel.btheta(1);
        }
        if ((Math.abs(ar - ma) < this.c_ || this.hasSeas() && Math.abs(sar - sma) < this.c_) && (this.rmax >= 0.9 || this.rsmax >= 0.9)) {
            if (this.useml && icon == 1) {
                this.useml = false;
            } else {
                ++icon;
            }
            if (this.rmax > this.rsmax) {
                this.spec.setD(this.spec.getD() + 1);
            } else {
                this.spec.setBd(this.spec.getBd() + 1);
            }
        } else if ((Math.abs(ar + 1.0) <= 0.15 || this.hasSeas() && Math.abs(sar + 1.0) <= 0.16) && (this.rmax >= 0.9 || this.rsmax >= 0.88) || (Math.abs(ar + 1.0) <= 0.16 || this.hasSeas() && Math.abs(sar + 1.0) <= 0.17) && (this.rmax >= 0.91 || this.rsmax >= 0.89)) {
            if (this.useml && icon == 1) {
                this.useml = false;
            } else {
                ++icon;
            }
            if (this.rmax > this.rsmax) {
                this.spec.setD(this.spec.getD() + 1);
            } else {
                this.spec.setBd(this.spec.getBd() + 1);
            }
        }
        return icon;
    }

    private int finalcond(int icon) {
        if (icon == 2) {
            this.spec.setD(this.spec.getD() - 1);
            this.spec.setBd(this.spec.getBd() - 1);
            if (this.mlused) {
                if (this.lastModel.phi(1) < this.lastModel.bphi(1)) {
                    this.spec.setD(this.spec.getD() + 1);
                } else {
                    this.spec.setBd(this.spec.getBd() + 1);
                }
            } else if (this.rmax > this.rsmax) {
                if (this.rmax > 0.0) {
                    this.spec.setD(this.spec.getD() + 1);
                }
            } else if (this.rsmax > 0.0) {
                this.spec.setBd(this.spec.getBd() + 1);
            }
        }
        if (this.spec.getD() > this.maxd) {
            this.spec.setD(this.maxd);
            icon = 0;
        }
        if (this.spec.getBd() > this.maxbd) {
            this.spec.setBd(this.maxbd);
            icon = 0;
        }
        return icon;
    }

    public double getUB1() {
        return this.ub1;
    }

    public double getUB2() {
        return this.ub2;
    }

    private boolean hasSeas() {
        return this.maxbd > 0 && this.spec.getPeriod() > 1;
    }

    private void initstep(boolean bstart) {
        boolean usedefault;
        DataBlock data;
        BackFilter ur;
        if (this.spec.getD() == 0 && this.spec.getBd() == 0 && bstart) {
            if (this.spec.getPeriod() != 2) {
                this.spec.setP(2);
            } else {
                this.spec.setP(1);
            }
            this.spec.setQ(0);
            this.spec.setBq(0);
            if (this.hasSeas()) {
                this.spec.setBp(1);
            }
        } else {
            this.spec.setP(1);
            this.spec.setQ(1);
            if (this.spec.getPeriod() > 1) {
                this.spec.setBp(1);
                this.spec.setBq(1);
            }
        }
        if ((ur = RegArimaUtility.differencingFilter((int)this.spec.getPeriod(), (int)this.spec.getD(), (int)this.spec.getBd())).getDegree() > 0) {
            data = DataBlock.make((int)(this.x.length - ur.getDegree()));
            ur.apply(DataBlock.of((double[])this.x), data);
        } else {
            data = DataBlock.copyOf((double[])this.x);
        }
        DifferencingModule.removeMean(data);
        HannanRissanen hr = HannanRissanen.builder().build();
        boolean bl = usedefault = !hr.process((DoubleSeq)data, this.spec.doStationary());
        if (!usedefault) {
            this.lastModel = hr.getModel();
            if (bstart && !this.lastModel.isStable(true)) {
                if (this.spec.getP() > 1 || this.spec.getP() == 1 && Math.abs(this.lastModel.phi(1)) > 1.02 || this.spec.getBp() == 1 && Math.abs(this.lastModel.bphi(1)) > 1.02) {
                    usedefault = true;
                } else {
                    this.lastModel = SarimaMapping.stabilize((SarimaModel)this.lastModel);
                }
            }
        }
        if (usedefault) {
            this.lastModel = SarimaModel.builder((SarmaOrders)this.spec.doStationary()).setDefault().build();
        }
        if (usedefault || this.ml || this.useml) {
            this.lastModel = SarimaMapping.stabilize((SarimaModel)this.lastModel);
            IRegArimaComputer processor = RegArimaUtility.processor((boolean)true, (double)this.eps);
            SarimaModel arima = SarimaModel.builder((SarimaOrders)this.spec).parameters(this.lastModel.parameters()).build();
            RegArimaModel regarima = RegArimaModel.builder().y(DoubleSeq.of((double[])this.x)).arima((IArimaModel)arima).build();
            RegArimaEstimation rslt = processor.optimize(regarima, null);
            if (rslt == null) {
                throw new RegArimaException("Non convergence in IDDIF");
            }
            this.lastModel = (SarimaModel)rslt.getModel().arima();
            this.mlused = true;
        } else {
            this.mlused = false;
        }
        this.useml = false;
    }

    public boolean isUsingML() {
        return this.ml;
    }

    private int maincondition() {
        double ar = this.lastModel.phi(1);
        double ma = this.lastModel.theta(1);
        double sar = 0.0;
        double sma = 0.0;
        if (this.hasSeas()) {
            sar = this.lastModel.bphi(1);
            sma = this.lastModel.btheta(1);
        }
        this.c_ -= 0.002;
        double din = !this.mlused && this.ub2 >= 0.869 ? 0.136 : 1.005 - this.ub2;
        int icon = 0;
        if (Math.abs(ar + 1.0) <= din) {
            if (-ar > 1.02) {
                icon = 1;
                this.useml = true;
            } else if (Math.abs(ar - ma) > this.c_) {
                ++icon;
                this.spec.setD(this.spec.getD() + 1);
            }
        } else if (Math.abs(ar) > 1.12) {
            icon = 1;
            this.useml = true;
        }
        if (this.hasSeas()) {
            if (Math.abs(sar + 1.0) <= 0.19) {
                if (-sar > 1.02) {
                    this.useml = true;
                    icon = 1;
                } else if (this.spec.getBd() == 0 && Math.abs(sar - sma) > this.c_) {
                    ++icon;
                    this.spec.setBd(this.spec.getBd() + 1);
                    if (this.useml) {
                        --icon;
                        this.useml = false;
                    }
                }
            } else if (Math.abs(sar) > 1.12) {
                icon = 1;
                this.useml = true;
            }
        }
        return icon;
    }

    private boolean nextstep() {
        this.initstep(false);
        int icon = this.maincondition();
        if (this.iter == 0) {
            icon = this.cond1(icon);
        }
        this.allcond();
        return this.finalcond(icon) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingResult process(RegSarimaModelling modelling) {
        ModelDescription description = modelling.getDescription();
        RegArimaEstimation estimation = modelling.getEstimation();
        int period = description.getAnnualFrequency();
        DoubleSeq res = RegArimaUtility.linearizedData((RegArimaModel)estimation.getModel(), (ConcentratedLikelihoodWithMissing)estimation.getConcentratedLikelihood());
        ProcessingLog log = modelling.getLog();
        log.push("differencing selection");
        try {
            if (this.process(res, period)) {
                SarimaOrders curspec = description.specification();
                boolean nmean = this.isMeanCorrection();
                boolean changed = false;
                if (this.spec.getD() != curspec.getD() || this.spec.getBd() != curspec.getBd()) {
                    changed = true;
                    description.setSpecification(this.spec);
                    modelling.clearEstimation();
                }
                if (nmean != description.isMean()) {
                    changed = true;
                    description.setMean(nmean);
                    modelling.clearEstimation();
                }
                log.info("differencing selection", (Object)IDifferencingModule.Info.of((IDifferencingModule)this));
                ProcessingResult processingResult = changed ? ProcessingResult.Changed : ProcessingResult.Unchanged;
                return processingResult;
            }
            modelling.getLog().remark("differencing selection failed");
            ProcessingResult processingResult = this.airline(modelling);
            return processingResult;
        }
        finally {
            log.pop();
        }
    }

    public boolean process(DoubleSeq data, int period) {
        this.clear();
        this.x = data.toArray();
        this.spec = new SarimaOrders(period);
        return this.calc();
    }

    private int searchur(Complex[] r, double val, boolean regular) {
        if (r == null) {
            return 0;
        }
        int n = 0;
        double vmax = 0.0;
        for (int i = 0; i < r.length; ++i) {
            double cdim = Math.abs(r[i].getIm());
            double vcur = r[i].abs();
            if (vcur >= val && cdim <= 0.05 && r[i].getRe() > 0.0) {
                ++n;
                continue;
            }
            if (!(cdim <= 0.02) || !(r[i].getRe() > 0.0) || !(vcur > vmax)) continue;
            vmax = vcur;
        }
        if (regular) {
            this.rmax = vmax;
        } else {
            this.rsmax = vmax;
        }
        return n;
    }

    private void step0() {
        this.initstep(true);
        if (this.spec.getD() != 0 || this.spec.getBd() != 0) {
            this.rmax = this.lastModel.phi(1);
            if (this.hasSeas()) {
                this.rsmax = this.lastModel.bphi(1);
            }
        }
        Complex[] rar = this.lastModel.getRegularAR().mirror().roots();
        this.spec.setD(this.spec.getD() + this.searchur(rar, this.ub1, true));
        if (this.hasSeas()) {
            Complex[] rsar = this.lastModel.getSeasonalAR().mirror().roots();
            this.spec.setBd(this.spec.getBd() + this.searchur(rsar, this.ub1, false));
        }
    }

    public int getD() {
        return this.spec.getD();
    }

    public int getBd() {
        return this.spec.getBd();
    }

    public boolean isMeanCorrection() {
        return this.mu;
    }

    public double getTMean() {
        return this.tmean;
    }

    private void calcMean() {
        if (this.spec.getDifferenceOrder() == 0) {
            this.stMean();
        } else {
            this.nstMean();
        }
    }

    private void stMean() {
        int n = this.x.length;
        double wm = 0.0;
        double ssq = 0.0;
        for (int i = 0; i < n; ++i) {
            wm += this.x[i];
            ssq += this.x[i] * this.x[i];
        }
        double wd = Math.sqrt(ssq);
        this.tmean = wm / wd;
        double vct = n > 200 ? 2.55 : (n > 80 ? 2.0 : 1.96);
        this.mu = Math.abs(this.tmean) > vct;
    }

    private void nstMean() {
        SarimaOrders cspec = this.spec.clone();
        RegArimaModel model = RegArimaModel.builder().y(DoubleSeq.of((double[])this.x)).meanCorrection(true).arima((IArimaModel)SarimaModel.builder((SarimaOrders)cspec).setDefault().build()).build();
        RegArimaEstimation est = X13Utility.processor(true, this.eps).process(model, null);
        if (est == null) {
            return;
        }
        this.tmean = est.getConcentratedLikelihood().tstat(0, 0, false);
        int n = this.x.length;
        double vct = n <= 80 ? 1.96 : (n <= 155 ? 1.98 : (n <= 230 ? 2.1 : (n <= 350 ? 2.3 : 2.5)));
        this.mu = Math.abs(this.tmean) > vct;
    }

    private ProcessingResult airline(RegSarimaModelling context) {
        boolean seasonal;
        ModelDescription desc = context.getDescription();
        boolean bl = seasonal = desc.getAnnualFrequency() > 1;
        if (!desc.specification().isAirline(seasonal)) {
            desc.setAirline(seasonal);
            desc.setMean(false);
            context.clearEstimation();
            return ProcessingResult.Changed;
        }
        return ProcessingResult.Unprocessed;
    }

    public static class Builder {
        private int maxd = 2;
        private int maxbd = 1;
        private double eps = 1.0E-5;
        private double ub1 = 0.97;
        private double ub2 = 0.88;
        private double cancel = 0.1;
        private boolean ml = false;

        private Builder() {
        }

        public Builder maxD(int maxd) {
            this.maxd = maxd;
            return this;
        }

        public Builder maxBD(int maxbd) {
            this.maxbd = maxbd;
            return this;
        }

        public Builder precision(double eps) {
            this.eps = eps;
            return this;
        }

        public Builder ub1(double ub1) {
            this.ub1 = ub1;
            return this;
        }

        public Builder ub2(double ub2) {
            this.ub2 = ub2;
            return this;
        }

        public Builder cancel(double cancel) {
            this.cancel = cancel;
            return this;
        }

        public Builder maximumLikelihood(boolean ml) {
            this.ml = ml;
            return this;
        }

        public DifferencingModule build() {
            return new DifferencingModule(this.maxd, this.maxbd, this.ub1, this.ub2, this.cancel, this.ml, this.eps);
        }
    }
}

