/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.CompoundParameter;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.model.TransformedMultivariateParameter;
import dr.math.matrixAlgebra.WrappedMatrix;
import dr.util.Transform;

public abstract class AbstractTransformedCompoundMatrix
extends MatrixParameter {
    final Parameter diagonalParameter;
    final Parameter offDiagonalParameter;
    protected boolean isStrictlyUpperTriangular = true;
    final CompoundParameter untransformedCompoundParameter;
    protected final int dim;

    AbstractTransformedCompoundMatrix(Parameter parameter, Parameter parameter2) {
        super("matrixParameter");
        this.diagonalParameter = parameter;
        this.dim = this.diagonalParameter.getDimension();
        this.offDiagonalParameter = parameter2;
        this.addParameter(this.diagonalParameter);
        this.addParameter(this.offDiagonalParameter);
        this.untransformedCompoundParameter = new CompoundParameter(this.getParameterName());
        this.setUntransformedCompoundParameter();
    }

    AbstractTransformedCompoundMatrix(Parameter parameter, Parameter parameter2, Transform.MultivariableTransform multivariableTransform, Boolean bl) {
        super("matrixParameter");
        this.diagonalParameter = parameter;
        this.dim = this.diagonalParameter.getDimension();
        this.offDiagonalParameter = multivariableTransform == null ? parameter2 : new TransformedMultivariateParameter(parameter2, multivariableTransform, (boolean)bl);
        this.addParameter(this.diagonalParameter);
        this.addParameter(this.offDiagonalParameter);
        this.untransformedCompoundParameter = new CompoundParameter(this.getParameterName());
        this.setUntransformedCompoundParameter();
    }

    private void setUntransformedCompoundParameter() {
        this.untransformedCompoundParameter.addParameter(this.getDiagonalParameter());
        this.untransformedCompoundParameter.addParameter(this.getUntransformedOffDiagonalParameter());
    }

    @Override
    public int getDimension() {
        return this.getColumnDimension() * this.getRowDimension();
    }

    @Override
    public double getParameterValue(int n) {
        int n2 = this.getColumnDimension();
        return this.getParameterValue(n / n2, n % n2);
    }

    @Override
    public double getParameterUntransformedValue(int n) {
        int n2 = this.getColumnDimension();
        return this.getParameterUntransformedValue(n / n2, n % n2);
    }

    private double getParameterUntransformedValue(int n, int n2) {
        if (n != n2) {
            return this.offDiagonalParameter.getParameterUntransformedValue(this.getUpperTriangularIndex(n, n2));
        }
        return this.diagonalParameter.getParameterUntransformedValue(n);
    }

    @Override
    public void setParameterUntransformedValue(int n, double d) {
        int n2 = this.getColumnDimension();
        this.setParameterUntransformedValue(n / n2, n % n2, d);
    }

    private void setParameterUntransformedValue(int n, int n2, double d) {
        if (n != n2) {
            this.offDiagonalParameter.setParameterUntransformedValue(this.getUpperTriangularIndex(n, n2), d);
        } else {
            this.diagonalParameter.setParameterUntransformedValue(n, d);
        }
    }

    @Override
    public int getColumnDimension() {
        return this.diagonalParameter.getDimension();
    }

    @Override
    public int getRowDimension() {
        return this.diagonalParameter.getDimension();
    }

    @Override
    public void setParameterValue(int n, double d) {
        throw new RuntimeException("Do not set entries of a TransformedCompoundMatrix directly");
    }

    @Override
    public void setParameterValue(int n, int n2, double d) {
        throw new RuntimeException("Do not set entries of a TransformedCompoundMatrix directly");
    }

    public double[] getDiagonal() {
        return this.diagonalParameter.getParameterValues();
    }

    public Parameter getDiagonalParameter() {
        return this.diagonalParameter;
    }

    public Parameter getOffDiagonalParameter() {
        return this.offDiagonalParameter;
    }

    public Parameter getUntransformedOffDiagonalParameter() {
        if (this.offDiagonalParameter instanceof TransformedMultivariateParameter) {
            return ((TransformedMultivariateParameter)this.offDiagonalParameter).getUntransformedParameter();
        }
        return this.offDiagonalParameter;
    }

    public CompoundParameter getUntransformedCompoundParameter() {
        return this.untransformedCompoundParameter;
    }

    abstract double[] updateGradientDiagonal(double[] var1);

    abstract double[] updateGradientOffDiagonal(double[] var1);

    @Override
    public double[] getAttributeValue() {
        double[] dArray = new double[this.dim * this.dim];
        int n = 0;
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                dArray[n] = this.getParameterValue(i, j);
                ++n;
            }
        }
        return dArray;
    }

    @Override
    public String getDimensionName(int n) {
        int n2 = this.getColumnDimension();
        String string = Integer.toString(n / n2);
        String string2 = Integer.toString(n % n2);
        return this.getId() + string + string2;
    }

    @Override
    public String getReport() {
        return new WrappedMatrix.ArrayOfArray(this.getParameterAsMatrix()).toString();
    }

    int getUpperTriangularIndex(int n, int n2) {
        if (n < n2) {
            return this.upperTriangularTransformation(n, n2);
        }
        return this.upperTriangularTransformation(n2, n);
    }

    private int upperTriangularTransformation(int n, int n2) {
        if (this.isStrictlyUpperTriangular) {
            assert (n != n2);
            return this.strictlyUpperTriangularTransformation(n, n2);
        }
        return this.weaklyUpperTriangularTransformatino(n, n2);
    }

    private int strictlyUpperTriangularTransformation(int n, int n2) {
        return n * (2 * this.dim - n - 1) / 2 + (n2 - n - 1);
    }

    private int weaklyUpperTriangularTransformatino(int n, int n2) {
        return n * (2 * this.dim - n + 1) / 2 + (n2 - n);
    }

    public void setStrictlyUpperTriangular(boolean bl) {
        this.isStrictlyUpperTriangular = bl;
    }
}

