/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.inference.model.GradientProvider;
import dr.math.ComplexArray;
import dr.math.FastFourierTransform;
import dr.math.distributions.KernelDensityEstimatorDistribution;
import dr.stats.DiscreteStatistics;
import dr.util.HeapSort;
import java.util.Random;

public class NormalKDEDistribution
extends KernelDensityEstimatorDistribution
implements GradientProvider {
    public static final int MINIMUM_GRID_SIZE = 512;
    public static final boolean DEBUG = false;
    private ComplexArray kOrdinates;
    double[] xPoints;
    double[] densityPoints;
    private int[] indices;
    private int gridSize;
    private double cut;
    double from;
    double to;
    double lo;
    double up;
    boolean densityKnown = false;

    public NormalKDEDistribution(Double[] doubleArray) {
        this(doubleArray, null, null, null);
    }

    public NormalKDEDistribution(Double[] doubleArray, Double d, Double d2, Double d3) {
        this(doubleArray, d, d2, d3, 3.0, 512);
    }

    public NormalKDEDistribution(Double[] doubleArray, Double d, Double d2, Double d3, int n) {
        this(doubleArray, d, d2, d3, 3.0, n);
    }

    public NormalKDEDistribution(Double[] doubleArray, Double d, Double d2, Double d3, double d4, int n) {
        super(doubleArray, d, d2, d3);
        this.gridSize = Math.max(n, 512);
        if (this.gridSize > 512) {
            this.gridSize = (int)Math.pow(2.0, Math.ceil(Math.log(this.gridSize) / Math.log(2.0)));
        }
        this.cut = d4;
        this.setBounds();
        this.densityKnown = false;
    }

    void setBounds() {
        this.from = DiscreteStatistics.min(this.sample) - this.cut * this.bandWidth;
        this.to = DiscreteStatistics.max(this.sample) + this.cut * this.bandWidth;
        this.lo = this.from - 4.0 * this.bandWidth;
        this.up = this.to + 4.0 * this.bandWidth;
    }

    @Override
    public double getFromPoint() {
        return this.from;
    }

    @Override
    public double getToPoint() {
        return this.to;
    }

    double linearApproximate(double[] dArray, double[] dArray2, double d, double d2, double d3) {
        int n = 0;
        int n2 = dArray.length - 1;
        if (d < dArray[n]) {
            return d2;
        }
        if (d > dArray[n2]) {
            return d3;
        }
        while (n < n2 - 1) {
            int n3 = (n + n2) / 2;
            if (d < dArray[n3]) {
                n2 = n3;
                continue;
            }
            n = n3;
        }
        if (d == dArray[n2]) {
            return dArray2[n2];
        }
        if (d == dArray[n]) {
            return dArray2[n];
        }
        return dArray2[n] + (dArray2[n2] - dArray2[n]) * ((d - dArray[n]) / (dArray[n2] - dArray[n]));
    }

    private double gradientLogLinearApproximate(double[] dArray, double[] dArray2, double d) {
        int n = 0;
        int n2 = dArray.length - 1;
        if (d < dArray[n] || d > dArray[n2]) {
            return 0.0;
        }
        while (n < n2 - 1) {
            int n3 = (n + n2) / 2;
            if (d < dArray[n3]) {
                n2 = n3;
                continue;
            }
            n = n3;
        }
        double d2 = (dArray2[n2] - dArray2[n]) / (dArray[n2] - dArray[n]);
        double d3 = dArray2[n] + (dArray2[n2] - dArray2[n]) * ((d - dArray[n]) / (dArray[n2] - dArray[n]));
        return 1.0 / (d - dArray[n] + dArray2[n] / d2);
    }

    private double[] rescaleAndTrim(double[] dArray) {
        int n = dArray.length / 2;
        double d = 1.0 / (double)dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i] * d;
            if (!(dArray2[i] < 0.0)) continue;
            dArray2[i] = 0.0;
        }
        return dArray2;
    }

    private double[] massdist(double[] dArray, double d, double d2, int n) {
        int n2 = dArray.length;
        double[] dArray2 = new double[n * 2];
        int n3 = n - 2;
        double d3 = (d2 - d) / (double)(n - 1);
        for (int i = 0; i < n; ++i) {
            dArray2[i] = 0.0;
        }
        double d4 = 1.0 / (double)n2;
        for (int i = 0; i < n2; ++i) {
            double d5 = (dArray[i] - d) / d3;
            int n4 = (int)Math.floor(d5);
            double d6 = d5 - (double)n4;
            if (0 <= n4 && n4 <= n3) {
                int n5 = n4;
                dArray2[n5] = dArray2[n5] + (1.0 - d6) * d4;
                int n6 = n4 + 1;
                dArray2[n6] = dArray2[n6] + d6 * d4;
                continue;
            }
            if (n4 == -1) {
                dArray2[0] = dArray2[0] + d6 * d4;
                continue;
            }
            if (n4 != n3 + 1) continue;
            int n7 = n4;
            dArray2[n7] = dArray2[n7] + (1.0 - d6) * d4;
        }
        return dArray2;
    }

    private void fillKernelOrdinates(ComplexArray complexArray, double d) {
        int n = complexArray.length;
        double d2 = 1.0 / (Math.sqrt(Math.PI * 2) * d);
        double d3 = -0.5 / (d * d);
        for (int i = 0; i < n; ++i) {
            double d4 = complexArray.real[i];
            complexArray.real[i] = d2 * Math.exp(d4 * d4 * d3);
        }
    }

    protected void computeDensity() {
        this.makeOrdinates();
        this.makeXGrid();
        this.transformData();
        this.densityKnown = true;
    }

    void transformData() {
        ComplexArray complexArray = new ComplexArray(this.massdist(this.sample, this.lo, this.up, this.gridSize));
        FastFourierTransform.fft(complexArray, false);
        ComplexArray complexArray2 = complexArray.product(this.kOrdinates);
        FastFourierTransform.fft(complexArray2, true);
        this.densityPoints = this.rescaleAndTrim(complexArray2.real);
    }

    void makeOrdinates() {
        int n;
        int n2 = 2 * this.gridSize;
        if (this.kOrdinates == null) {
            this.kOrdinates = new ComplexArray(new double[n2]);
        }
        double d = 2.0 * (this.up - this.lo);
        double d2 = 0.0;
        double d3 = d / (double)(n2 - 1);
        for (n = 0; n <= this.gridSize; ++n) {
            this.kOrdinates.real[n] = d2;
            d2 += d3;
        }
        for (n = this.gridSize + 1; n < n2; ++n) {
            this.kOrdinates.real[n] = -this.kOrdinates.real[n2 - n];
        }
        this.fillKernelOrdinates(this.kOrdinates, this.bandWidth);
        FastFourierTransform.fft(this.kOrdinates, false);
        this.kOrdinates.conjugate();
    }

    void makeXGrid() {
        this.xPoints = new double[this.gridSize];
        double d = this.lo;
        double d2 = (this.up - this.lo) / (double)(this.gridSize - 1);
        for (int i = 0; i < this.gridSize; ++i) {
            this.xPoints[i] = d;
            d += d2;
        }
    }

    @Override
    protected double evaluateKernel(double d) {
        if (!this.densityKnown) {
            this.computeDensity();
        }
        return this.linearApproximate(this.xPoints, this.densityPoints, d, 0.0, 0.0);
    }

    @Override
    protected void processBounds(Double d, Double d2) {
        if (d != null && d != Double.NEGATIVE_INFINITY || d2 != null && d2 != Double.POSITIVE_INFINITY) {
            throw new RuntimeException("NormalKDEDistribution must be unbounded");
        }
    }

    @Override
    protected void setBandWidth(Double d) {
        this.bandWidth = d == null ? this.bandwidthNRD(this.sample) : d.doubleValue();
        this.densityKnown = false;
    }

    private double bandwidthNRD(double[] dArray) {
        if (this.indices == null) {
            this.indices = new int[dArray.length];
            HeapSort.sort(dArray, this.indices);
        }
        double d = (DiscreteStatistics.quantile(0.75, dArray, this.indices) - DiscreteStatistics.quantile(0.25, dArray, this.indices)) / 1.34;
        return 1.06 * Math.min(Math.sqrt(DiscreteStatistics.variance(dArray)), d) * Math.pow(dArray.length, -0.2);
    }

    void resetIndices(boolean bl) {
        if (!bl) {
            this.indices = null;
        }
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        double[] dArray = GradientProvider.toDoubleArray(object);
        double[] dArray2 = new double[dArray.length];
        if (!this.densityKnown) {
            this.computeDensity();
        }
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = this.gradientLogLinearApproximate(this.xPoints, this.densityPoints, dArray[i]);
        }
        return dArray2;
    }

    double getGradLogDensity(double d) {
        if (!this.densityKnown) {
            this.computeDensity();
        }
        return this.gradientLogLinearApproximate(this.xPoints, this.densityPoints, d);
    }

    public static void main(String[] stringArray) {
        long l = System.currentTimeMillis();
        Random random = new Random(1234L);
        Double[] doubleArray = new Double[10000000];
        for (int i = 0; i < doubleArray.length; ++i) {
            doubleArray[i] = random.nextDouble();
        }
        NormalKDEDistribution normalKDEDistribution = new NormalKDEDistribution(doubleArray);
        for (int i = 0; i < 100; ++i) {
            normalKDEDistribution.evaluateKernel(random.nextDouble());
        }
        long l2 = System.currentTimeMillis();
        System.out.println("Time: " + (l2 - l));
    }
}

