### R code from vignette source 'Ch11.rnw'

###################################################
### code chunk number 1: setup
###################################################
source("GenericSettings.R")


###################################################
### code chunk number 2: Ch11.rnw:21-23
###################################################
sum(dbinom(7:10, size=10, prob=0.5))
pbinom(6, size=10, prob=0.5, lower.tail=FALSE)


###################################################
### code chunk number 3: Ch11.rnw:26-28
###################################################
sum(dbinom(8:10, size=10, prob=0.5))
pbinom(7, size=10, prob=0.5, lower.tail=FALSE)


###################################################
### code chunk number 4: Ch11.rnw:33-38
###################################################
p=0.5
n=100
s=sqrt(p*(1-p)/n)
pnorm(0.6, mean=p, sd=s, lower.tail=FALSE)
qnorm(0.95, mean=p, sd=s, lower.tail=FALSE)


###################################################
### code chunk number 5: Ch11.rnw:43-47
###################################################
p=0.5
n=203
s=sqrt(p*(1-p)/n)
pnorm(87/203, mean=p, sd=s, lower.tail=FALSE)


###################################################
### code chunk number 6: Ch11.rnw:49-50
###################################################
binom.test(87,203, alternative="less")


###################################################
### code chunk number 7: Ch11.rnw:52-53
###################################################
prop.test(87,203, alternative="less")


###################################################
### code chunk number 8: Ch11.rnw:55-56
###################################################
prop.test(87,203, , alternative="less", correct=FALSE)


###################################################
### code chunk number 9: Ch11.rnw:62-63
###################################################
binom.test(68,400, p=0.2, alternative="less")


###################################################
### code chunk number 10: Ch11.rnw:65-66
###################################################
prop.test(68,400, p=0.2, alternative="less")


###################################################
### code chunk number 11: Ch11.rnw:68-69
###################################################
prop.test(68,400, p=0.2, alternative="less", correct=FALSE)


###################################################
### code chunk number 12: Ch11.rnw:74-75
###################################################
prop.test(c(65,51), c(111,92))


###################################################
### code chunk number 13: Ch11.rnw:82-84
###################################################
Ex11.11 = matrix(c(10,37,11,54), nrow=2)
Ex11.11


###################################################
### code chunk number 14: Ch11.rnw:87-88
###################################################
prop.test(c(10,11), c(47,65))


###################################################
### code chunk number 15: Ch11.rnw:91-92
###################################################
chisq.test(Ex11.11)


###################################################
### code chunk number 16: Ch11.rnw:94-95
###################################################
fisher.test(Ex11.11)


###################################################
### code chunk number 17: Ch11.rnw:99-100
###################################################
fisher.test(Ex11.11, alternative="greater")


###################################################
### code chunk number 18: Ch11.rnw:106-107
###################################################
data(GoGoGo, package="MindOnStats")


###################################################
### code chunk number 19: Ch11.rnw:110-112
###################################################
AmberLights = GoGoGo$Time[GoGoGo$Lights=="amber"]
t.test(AmberLights, mu=3.6, alternative="less")


###################################################
### code chunk number 20: Ch11.rnw:121-124
###################################################
Airport=c(283591,269620,312220,300679,217889,381030,232288,186285,230672,248172,221898,257073)
City=c(188010,197874,193954,210545,212116,277022,239715,197761,256650,182655,146602,149663)
t.test(Airport, City, paired=T)


###################################################
### code chunk number 21: Ch11.rnw:127-129
###################################################
Difference=Airport-City
t.test(Difference)


###################################################
### code chunk number 22: Ch11.rnw:137-138
###################################################
t.test(Time~Lights, data=GoGoGo)


###################################################
### code chunk number 23: Ch11.rnw:145-149
###################################################
data(Reflexes, package="MindOnStats")
attach(Reflexes)
wilcox.test(RightFluoro,RightClear, paired=TRUE, alternative="less")
detach(Reflexes)


###################################################
### code chunk number 24: Ch11.rnw:154-155
###################################################
wilcox.test(RightFluoro~Gender, data=Reflexes)


###################################################
### code chunk number 25: Ch11.rnw:164-166
###################################################
TestVal=28*0.25/0.35
pchisq(20 ,df=28)


###################################################
### code chunk number 26: Ch11.rnw:170-171
###################################################
pf(4/2.25, df1=9, df2=14, lower.tail=FALSE)


###################################################
### code chunk number 27: Ch11.rnw:193-194
###################################################
power.t.test(delta=0.5, sd=1, sig.level=0.05, power=0.8, type="one.sample", alternative="one.sided")


###################################################
### code chunk number 28: Ch11.rnw:199-200
###################################################
power.t.test(n=20, delta=0.8, sd=1, sig.level=0.05, type="one.sample", alternative="one.sided")


