/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers;

import java.util.ArrayList;
import java.util.List;
import moa.cluster.CFCluster;
import moa.cluster.Cluster;
import moa.cluster.Clustering;
import moa.cluster.SphereCluster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KMeans {
    /*
     * WARNING - void declaration
     */
    public static Clustering kMeans(Cluster[] centers, List<? extends Cluster> data) {
        int k = centers.length;
        int dimensions = centers[0].getCenter().length;
        ArrayList clustering = new ArrayList();
        for (int i = 0; i < k; ++i) {
            clustering.add(new ArrayList());
        }
        int repetitions = 100;
        while (repetitions-- >= 0) {
            void var7_7;
            for (Cluster cluster : data) {
                double minDistance = KMeans.distance(cluster.getCenter(), centers[0].getCenter());
                int closestCluster = 0;
                for (int i = 1; i < k; ++i) {
                    double distance = KMeans.distance(cluster.getCenter(), centers[i].getCenter());
                    if (!(distance < minDistance)) continue;
                    closestCluster = i;
                    minDistance = distance;
                }
                ((ArrayList)clustering.get(closestCluster)).add(cluster);
            }
            SphereCluster[] newCenters = new SphereCluster[centers.length];
            boolean bl = false;
            while (var7_7 < k) {
                newCenters[var7_7] = KMeans.calculateCenter((ArrayList)clustering.get((int)var7_7), dimensions);
                ((ArrayList)clustering.get((int)var7_7)).clear();
                ++var7_7;
            }
            centers = newCenters;
        }
        return new Clustering(centers);
    }

    private static double distance(double[] pointA, double[] pointB) {
        double distance = 0.0;
        for (int i = 0; i < pointA.length; ++i) {
            double d = pointA[i] - pointB[i];
            distance += d * d;
        }
        return Math.sqrt(distance);
    }

    private static SphereCluster calculateCenter(ArrayList<Cluster> cluster, int dimensions) {
        double[] res = new double[dimensions];
        for (int i = 0; i < res.length; ++i) {
            res[i] = 0.0;
        }
        if (cluster.size() == 0) {
            return new SphereCluster(res, 0.0);
        }
        for (Cluster point : cluster) {
            double[] center = point.getCenter();
            for (int i = 0; i < res.length; ++i) {
                int n = i;
                res[n] = res[n] + center[i];
            }
        }
        int i = 0;
        while (i < res.length) {
            int n = i++;
            res[n] = res[n] / (double)cluster.size();
        }
        double radius = 0.0;
        for (Cluster point : cluster) {
            double dist = KMeans.distance(res, point.getCenter());
            if (!(dist > radius)) continue;
            radius = dist;
        }
        return new SphereCluster(res, radius);
    }

    public static Clustering gaussianMeans(Clustering gtClustering, Clustering clustering) {
        ArrayList<CFCluster> microclusters = new ArrayList<CFCluster>();
        for (int i = 0; i < clustering.size(); ++i) {
            if (clustering.get(i) instanceof CFCluster) {
                microclusters.add((CFCluster)clustering.get(i));
                continue;
            }
            System.out.println("Unsupported Cluster Type:" + clustering.get(i).getClass() + ". Cluster needs to extend moa.cluster.CFCluster");
        }
        Cluster[] centers = new Cluster[gtClustering.size()];
        for (int i = 0; i < centers.length; ++i) {
            centers[i] = gtClustering.get(i);
        }
        int k = centers.length;
        if (microclusters.size() < k) {
            return new Clustering(new Cluster[0]);
        }
        Clustering kMeansResult = KMeans.kMeans(centers, microclusters);
        k = kMeansResult.size();
        CFCluster[] res = new CFCluster[k];
        for (CFCluster microcluster : microclusters) {
            double minDistance = Double.MAX_VALUE;
            int closestCluster = 0;
            for (int i = 0; i < k; ++i) {
                double distance = KMeans.distance(kMeansResult.get(i).getCenter(), microcluster.getCenter());
                if (!(distance < minDistance)) continue;
                closestCluster = i;
                minDistance = distance;
            }
            if (res[closestCluster] == null) {
                res[closestCluster] = (CFCluster)microcluster.copy();
                continue;
            }
            res[closestCluster].add(microcluster);
        }
        int count = 0;
        for (int i = 0; i < res.length; ++i) {
            if (res[i] == null) continue;
            ++count;
        }
        Cluster[] cleaned = new CFCluster[count];
        count = 0;
        for (int i = 0; i < res.length; ++i) {
            if (res[i] == null) continue;
            cleaned[count++] = res[i];
        }
        return new Clustering(cleaned);
    }
}

