/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.common.util.preprocessor.detector.scheduling;

import choco.Choco;
import choco.cp.common.util.preprocessor.detector.scheduling.AbstractTemporalDetector;
import choco.cp.common.util.preprocessor.detector.scheduling.DisjunctiveModel;
import choco.cp.model.CPModel;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.constraints.TemporalConstraint;
import choco.kernel.model.variables.integer.IntegerVariable;

public final class PrecFromReifiedModelDetector
extends AbstractTemporalDetector {
    public PrecFromReifiedModelDetector(CPModel model, DisjunctiveModel disjMod) {
        super(model, disjMod);
    }

    @Override
    protected ConstraintType getType() {
        return ConstraintType.PRECEDENCE_REIFIED;
    }

    @Override
    protected void apply(TemporalConstraint ct) {
        IntegerVariable dir = ct.getDirection();
        if (dir.isConstant()) {
            this.delete(ct);
            if (dir.getLowB() == 0) {
                this.add(Choco.endsAfterBegin(ct.getOrigin(), ct.getDestination(), -ct.forwardSetup() - 1));
            } else {
                this.add(Choco.precedence(ct.getOrigin(), ct.getDestination(), ct.forwardSetup()));
            }
        } else {
            this.reformulateImpliedReified(ct);
        }
    }
}

