/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver;

import choco.Choco;
import choco.cp.common.util.preprocessor.ExpressionTools;
import choco.cp.model.CPModel;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.integer.bool.BooleanFactory;
import choco.cp.solver.constraints.reified.ExpressionSConstraint;
import choco.cp.solver.constraints.reified.ReifiedFactory;
import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.model.constraints.AbstractConstraint;
import choco.kernel.model.constraints.ComponentConstraint;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ConstraintManager;
import choco.kernel.model.constraints.MetaConstraint;
import choco.kernel.model.variables.MultipleVariables;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.VariableManager;
import choco.kernel.model.variables.VariableType;
import choco.kernel.model.variables.integer.IntegerConstantVariable;
import choco.kernel.model.variables.integer.IntegerExpressionVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.real.RealConstantVariable;
import choco.kernel.model.variables.real.RealVariable;
import choco.kernel.model.variables.set.SetConstantVariable;
import choco.kernel.model.variables.set.SetVariable;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.constraints.reified.BoolNode;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.real.RealVar;
import choco.kernel.solver.variables.scheduling.TaskVar;
import choco.kernel.solver.variables.set.SetVar;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class CPModelToCPSolver {
    protected static final Logger LOGGER = ChocoLogging.getEngineLogger();
    protected final CPSolver cpsolver;
    private final THashSet<IntDomainVar> intNoDecisionVar = new THashSet();
    private final THashSet<SetVar> setNoDecisionVar = new THashSet();
    private final THashSet<RealVar> realNoDecisionVar = new THashSet();
    private final THashSet<TaskVar> taskNoDecisionVar = new THashSet();
    private final List<SConstraint> postponedConstraint = new ArrayList<SConstraint>(8);

    public CPModelToCPSolver(CPSolver cpsolver) {
        this.cpsolver = cpsolver;
    }

    public void clear() {
        this.intNoDecisionVar.clear();
        this.setNoDecisionVar.clear();
        this.realNoDecisionVar.clear();
        this.taskNoDecisionVar.clear();
        this.postponedConstraint.clear();
    }

    public void readVariables(CPModel model) {
        this.readIntegerVariables(model);
        this.readRealVariables(model);
        this.readSetVariables(model);
        this.readConstants(model);
        this.readMultipleVariables(model);
    }

    public void readIntegerVariables(CPModel model) {
        Iterator<IntegerVariable> it = model.getIntVarIterator();
        while (it.hasNext()) {
            IntegerVariable i = it.next();
            if (this.cpsolver.mapvariables.containsKey(i.getIndex())) continue;
            this.cpsolver.mapvariables.put(i.getIndex(), this.readModelVariable(i));
        }
    }

    public void readRealVariables(CPModel model) {
        Iterator<RealVariable> it = model.getRealVarIterator();
        while (it.hasNext()) {
            RealVariable r = it.next();
            if (this.cpsolver.mapvariables.containsKey(r.getIndex())) continue;
            this.cpsolver.mapvariables.put(r.getIndex(), this.readModelVariable(r));
        }
    }

    public void readSetVariables(CPModel model) {
        Iterator<SetVariable> it = model.getSetVarIterator();
        while (it.hasNext()) {
            SetVariable s = it.next();
            if (this.cpsolver.mapvariables.containsKey(s.getIndex())) continue;
            SetVar setVar = (SetVar)this.readModelVariable(s);
            this.cpsolver.mapvariables.put(s.getIndex(), setVar);
            this.cpsolver.mapvariables.put(s.getCard().getIndex(), setVar.getCard());
            this.checkOptions(s.getCard(), setVar.getCard());
        }
    }

    public void readConstants(CPModel model) {
        Iterator<Variable> it = model.getConstVarIterator();
        while (it.hasNext()) {
            Variable v = it.next();
            if (this.cpsolver.mapvariables.containsKey(v.getIndex())) continue;
            switch (v.getVariableType()) {
                case CONSTANT_INTEGER: {
                    IntegerConstantVariable ci = (IntegerConstantVariable)v;
                    if (this.cpsolver.mapvariables.containsKey(ci.getIndex())) break;
                    this.cpsolver.mapvariables.put(ci.getIndex(), this.readModelVariable(ci));
                    break;
                }
                case CONSTANT_DOUBLE: {
                    RealConstantVariable cr = (RealConstantVariable)v;
                    if (this.cpsolver.mapvariables.containsKey(cr.getIndex())) break;
                    this.cpsolver.mapvariables.put(cr.getIndex(), this.readModelVariable(cr));
                    break;
                }
                case CONSTANT_SET: {
                    SetConstantVariable cs = (SetConstantVariable)v;
                    if (this.cpsolver.mapvariables.containsKey(cs.getIndex())) break;
                    this.cpsolver.mapvariables.put(cs.getIndex(), this.readModelVariable(cs));
                }
            }
        }
    }

    public void readMultipleVariables(CPModel model) {
        Iterator<MultipleVariables> it = model.getMultipleVarIterator();
        while (it.hasNext()) {
            MultipleVariables mv = it.next();
            if (this.cpsolver.mapvariables.containsKey(mv.getIndex())) continue;
            this.cpsolver.mapvariables.put(mv.getIndex(), this.readModelVariable(mv));
        }
    }

    public Var readModelVariable(Variable v) {
        VariableManager<?> vm = v.getVariableManager();
        if (vm != null) {
            Var var = vm.makeVariable(this.cpsolver, v);
            this.checkOptions(v, var);
            return var;
        }
        return null;
    }

    private void checkOptions(Variable v, Var var) {
        if (v.getOptions().contains("cp:decision")) {
            LOGGER.warning("CPOptions.V_DECISION or \"cp:decision\" option are deprecated and have no longer effect on decision variables pool!");
        } else if (v.getOptions().contains("cp:no_decision")) {
            this.removeFromDecisionPool(var);
        }
        if (v.getOptions().contains("cp:objective")) {
            this.cpsolver.setObjective(var);
        }
        if (v.getOptions().contains("cp:makespan")) {
            this.cpsolver.setMakespan(var);
        }
    }

    private void removeFromDecisionPool(Var v) {
        if (v instanceof IntDomainVar) {
            this.intNoDecisionVar.add((IntDomainVar)v);
        } else if (v instanceof SetVar) {
            this.setNoDecisionVar.add((SetVar)v);
        } else if (v instanceof RealVar) {
            this.realNoDecisionVar.add((RealVar)v);
        } else if (v instanceof TaskVar) {
            this.taskNoDecisionVar.add((TaskVar)v);
        }
    }

    protected void readDecisionVariables() {
        this.cpsolver.intDecisionVars.addAll(this.cpsolver.intVars.toList());
        if (!this.intNoDecisionVar.isEmpty()) {
            this.cpsolver.intDecisionVars.removeAll(this.intNoDecisionVar);
            this.cpsolver.intDecisionVars.removeAll(this.cpsolver.getIntConstantSet());
        }
        this.cpsolver.setDecisionVars.addAll(this.cpsolver.setVars.toList());
        if (!this.setNoDecisionVar.isEmpty()) {
            this.cpsolver.setDecisionVars.removeAll(this.setNoDecisionVar);
        }
        this.cpsolver.floatDecisionVars.addAll(this.cpsolver.floatVars.toList());
        if (!this.realNoDecisionVar.isEmpty()) {
            this.cpsolver.floatDecisionVars.removeAll(this.realNoDecisionVar);
            this.cpsolver.floatDecisionVars.removeAll(this.cpsolver.getRealConstantSet());
        }
        this.cpsolver.taskDecisionVars.addAll(this.cpsolver.taskVars.toList());
        if (!this.taskNoDecisionVar.isEmpty()) {
            this.cpsolver.taskDecisionVars.removeAll(this.taskNoDecisionVar);
        }
    }

    public void readConstraints(CPModel model) {
        Boolean decomp = model.getDefaultExpressionDecomposition();
        Iterator<Constraint> it = model.getConstraintIterator();
        while (it.hasNext()) {
            Constraint ic = it.next();
            if (this.cpsolver.mapconstraints.containsKey(ic.getIndex())) continue;
            if (ic.getOptions().contains("cp:decomp")) {
                decomp = true;
            }
            SConstraint c = this.readModelConstraint(ic, decomp);
            if (ic.getOptions().contains("cp:postponed")) {
                this.postponedConstraint.add(c);
            } else {
                this.cpsolver.post(c);
            }
            this.cpsolver.mapconstraints.put(ic.getIndex(), c);
        }
        for (SConstraint ppc : this.postponedConstraint) {
            this.cpsolver.post(ppc);
        }
        if (this.cpsolver.isUniqueReading()) {
            this.cpsolver.postTaskConsistencyConstraints();
            this.cpsolver.postMakespanConstraint();
        }
    }

    public void readConstraint(Constraint ic, Boolean decomp, boolean dynamic) {
        if (!this.cpsolver.mapconstraints.containsKey(ic.getIndex())) {
            SConstraint c = this.readModelConstraint(ic, decomp);
            this.cpsolver.mapconstraints.put(ic.getIndex(), c);
            this.cpsolver.post(c, dynamic);
        }
    }

    public SConstraint makeSConstraint(Constraint ic, Boolean decomp) {
        return this.readModelConstraint(ic, decomp);
    }

    public SConstraint makeSConstraint(Constraint ic) {
        return this.readModelConstraint(ic, false);
    }

    public SConstraint[] makeSConstraintAndOpposite(Constraint ic, Boolean decomp) {
        SConstraint[] cs = new SConstraint[2];
        AbstractConstraint cc = (AbstractConstraint)ic;
        ConstraintManager cm = cc.getConstraintManager();
        try {
            cs = cm.makeConstraintAndOpposite(this.cpsolver, cc.getVariables(), cc.getParameters(), cc.getOptions());
        }
        catch (Exception e) {
            cs[0] = this.readModelConstraint(ic, decomp);
            try {
                cs[1] = cs[0].opposite(this.cpsolver);
            }
            catch (SolverException se) {
                Constraint oc = Choco.not(ic);
                oc.findManager(CPModel.properties);
                cs[1] = this.readModelConstraint(oc, decomp);
            }
        }
        return cs;
    }

    public SConstraint[] makeSConstraintAndOpposite(Constraint ic) {
        return this.makeSConstraintAndOpposite(ic, false);
    }

    SConstraint readModelConstraint(Constraint ic, Boolean decomp) {
        if (ic instanceof MetaConstraint) {
            return this.createMetaConstraint(ic, decomp);
        }
        if (ic instanceof ComponentConstraint) {
            if (ic.getConstraintType().canContainExpression && CPModelToCPSolver.containExpression(ic.getVariables())) {
                return this.createMetaConstraint(ic, decomp);
            }
            ComponentConstraint cc = (ComponentConstraint)ic;
            ConstraintManager cm = cc.getConstraintManager();
            return cm.makeConstraint(this.cpsolver, cc.getVariables(), cc.getParameters(), cc.getOptions());
        }
        return null;
    }

    private static boolean containExpression(Variable[] vars) {
        if (vars == null) {
            return false;
        }
        for (Variable v : vars) {
            VariableType type = v.getVariableType();
            if (type != VariableType.INTEGER_EXPRESSION) continue;
            return true;
        }
        return false;
    }

    private IntDomainVar[] integerVariableToIntDomainVar(Variable[] tab) {
        return this.integerVariableToIntDomainVar(tab, tab.length);
    }

    private IntDomainVar[] integerVariableToIntDomainVar(Variable[] tab, int n) {
        IntDomainVar[] newTab = new IntDomainVar[n];
        for (int i = 0; i < n; ++i) {
            newTab[i] = (IntDomainVar)this.cpsolver.mapvariables.get(tab[i].getIndex());
        }
        return newTab;
    }

    private IntDomainVar[][] integerVariableToIntDomainVar(Variable[][] tab, int n) {
        IntDomainVar[][] newTab = new IntDomainVar[n][];
        for (int i = 0; i < n; ++i) {
            newTab[i] = this.integerVariableToIntDomainVar(tab[i]);
        }
        return newTab;
    }

    protected IntDomainVar[][] integerVariableToIntDomainVar(Variable[][] tab) {
        return this.integerVariableToIntDomainVar(tab, tab.length);
    }

    protected SConstraint createMetaConstraint(Constraint ic, Boolean decomp) {
        try {
            ExpressionSConstraint c = new ExpressionSConstraint(this.buildBoolNode(ic));
            c.setDecomposeExp(decomp);
            c.setScope(this.cpsolver);
            if (ic.getOptions().contains("cp:ac")) {
                c.setLevelAc(0);
            } else if (ic.getOptions().contains("cp:fc")) {
                c.setLevelAc(1);
            }
            SConstraint intensional = ExpressionTools.getScalarConstraint(c, this.cpsolver);
            if (intensional != null) {
                return intensional;
            }
            return c;
        }
        catch (ClassCastException cce) {
            LOGGER.info("createGenericMetaConstraint");
            return this.createGenericMetaConstraint((MetaConstraint)ic, decomp);
        }
        catch (NullPointerException cce) {
            LOGGER.info("createGenericMetaConstraint");
            return this.createGenericMetaConstraint((MetaConstraint)ic, decomp);
        }
    }

    protected BoolNode buildBoolNode(Constraint ic) {
        Variable[] vars = null;
        if (ic.getNbVars() > 0) {
            vars = new IntegerExpressionVariable[ic.getNbVars()];
            for (int i = 0; i < ic.getVariables().length; ++i) {
                vars[i] = (IntegerExpressionVariable)ic.getVariables()[i];
            }
        }
        return (BoolNode)((Object)ic.getExpressionManager().makeNode(this.cpsolver, new Constraint[]{ic}, vars));
    }

    protected SConstraint createGenericMetaConstraint(MetaConstraint mc, Boolean decomp) {
        int l = mc.getConstraints().length;
        SConstraint[] subcs = new SConstraint[l];
        IntDomainVar[] breifs = new IntDomainVar[l];
        for (int i = 0; i < l; ++i) {
            SConstraint[] cs = this.makeSConstraintAndOpposite((Constraint)mc.getConstraint(i), decomp);
            breifs[i] = this.cpsolver.createBooleanVar(StringUtils.randomName());
            subcs[i] = ReifiedFactory.builder(breifs[i], cs[0], cs[1], this.cpsolver);
        }
        switch (mc.getConstraintType()) {
            case AND: {
                this.cpsolver.post(subcs);
                return BooleanFactory.and(breifs);
            }
            case OR: {
                this.cpsolver.post(subcs);
                return BooleanFactory.or(this.cpsolver.getEnvironment(), breifs);
            }
            case NOT: {
                this.cpsolver.post(subcs);
                return this.cpsolver.eq((IntExp)breifs[0], 0);
            }
            case IFONLYIF: {
                this.cpsolver.post(subcs);
                return this.cpsolver.eq((IntExp)breifs[0], (IntExp)breifs[1]);
            }
            case IFTHENELSE: {
                this.cpsolver.post(subcs);
                IntDomainVar[] notbreifs = new IntDomainVar[]{this.cpsolver.createBooleanVar(StringUtils.randomName())};
                this.cpsolver.post(this.cpsolver.neq((IntExp)breifs[0], (IntExp)notbreifs[0]));
                this.cpsolver.post(this.cpsolver.eq((IntExp)breifs[0], (IntExp)breifs[1]));
                this.cpsolver.post(this.cpsolver.eq((IntExp)notbreifs[0], (IntExp)breifs[2]));
                return BooleanFactory.or(this.cpsolver.getEnvironment(), breifs[0], notbreifs[0]);
            }
            case IMPLIES: {
                this.cpsolver.post(subcs);
                IntDomainVar[] notbreifs = new IntDomainVar[]{this.cpsolver.createBooleanVar(StringUtils.randomName())};
                this.cpsolver.post(this.cpsolver.neq((IntExp)breifs[0], (IntExp)notbreifs[0]));
                return BooleanFactory.or(this.cpsolver.getEnvironment(), notbreifs[0], breifs[1]);
            }
        }
        throw new UnsupportedOperationException();
    }
}

