/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost.geometricPrim;

import choco.cp.solver.constraints.global.geost.externalConstraints.ExternalConstraint;
import choco.cp.solver.constraints.global.geost.geometricPrim.Point;
import choco.cp.solver.constraints.global.geost.internalConstraints.InternalConstraint;
import choco.cp.solver.constraints.global.geost.internalConstraints.Outbox;
import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public final class Obj
implements Externalizable {
    private static final Logger LOGGER = ChocoLogging.getEngineLogger();
    private int oid;
    private IntDomainVar sid;
    private IntDomainVar[] coords;
    private IntDomainVar start;
    private IntDomainVar duration;
    private IntDomainVar end;
    private List<ExternalConstraint> relatedExternalConstraints;
    private List<InternalConstraint> relatedInternalConstraints;
    private int dim;
    private int radius;

    public Obj() {
    }

    public Obj(int dim, int objectId, IntDomainVar shapeId, IntDomainVar[] coordinates, IntDomainVar startTime, IntDomainVar durationTime, IntDomainVar endTime) {
        this.dim = dim;
        this.oid = objectId;
        this.sid = shapeId;
        this.coords = coordinates;
        this.start = startTime;
        this.duration = durationTime;
        this.end = endTime;
        this.relatedExternalConstraints = new ArrayList<ExternalConstraint>();
        this.relatedInternalConstraints = new ArrayList<InternalConstraint>();
        this.radius = -1;
    }

    public Obj(int dim, int objectId, IntDomainVar shapeId, IntDomainVar[] coordinates, IntDomainVar startTime, IntDomainVar durationTime, IntDomainVar endTime, int radius) {
        this.dim = dim;
        this.oid = objectId;
        this.sid = shapeId;
        this.coords = coordinates;
        this.start = startTime;
        this.duration = durationTime;
        this.end = endTime;
        this.relatedExternalConstraints = new ArrayList<ExternalConstraint>();
        this.relatedInternalConstraints = new ArrayList<InternalConstraint>();
        this.radius = radius;
    }

    public Obj(int dim) {
        this.dim = dim;
        this.coords = new IntDomainVar[this.dim];
        this.relatedExternalConstraints = new ArrayList<ExternalConstraint>();
        this.relatedInternalConstraints = new ArrayList<InternalConstraint>();
    }

    public int getObjectId() {
        return this.oid;
    }

    public void setObjectId(int objectId) {
        this.oid = objectId;
    }

    public IntDomainVar getShapeId() {
        return this.sid;
    }

    public void setShapeId(IntDomainVar shapeId) {
        this.sid = shapeId;
    }

    public IntDomainVar[] getCoordinates() {
        return this.coords;
    }

    public void setCoordinates(IntDomainVar[] coordinates) {
        this.coords = coordinates;
    }

    public void setCoord(int index, IntDomainVar value) {
        this.coords[index] = value;
    }

    public IntDomainVar getCoord(int index) {
        return this.coords[index];
    }

    public IntDomainVar getDuration() {
        return this.duration;
    }

    public void setDuration(IntDomainVar duration) {
        this.duration = duration;
    }

    public IntDomainVar getEnd() {
        return this.end;
    }

    public void setEnd(IntDomainVar end) {
        this.end = end;
    }

    public IntDomainVar getStart() {
        return this.start;
    }

    public void setStart(IntDomainVar start) {
        this.start = start;
    }

    public List<ExternalConstraint> getRelatedExternalConstraints() {
        return this.relatedExternalConstraints;
    }

    public List<InternalConstraint> getRelatedInternalConstraints() {
        return this.relatedInternalConstraints;
    }

    public void setRelatedExternalConstraints(List<ExternalConstraint> relatedExtConstraints) {
        this.relatedExternalConstraints = relatedExtConstraints;
    }

    public void setRelatedInternalConstraints(List<InternalConstraint> relatedIntConstraints) {
        this.relatedInternalConstraints = relatedIntConstraints;
    }

    public void addRelatedExternalConstraint(ExternalConstraint ectr) {
        this.relatedExternalConstraints.add(ectr);
    }

    public void addRelatedInternalConstraint(InternalConstraint ictr) {
        this.relatedInternalConstraints.add(ictr);
    }

    public int calculateDomainSize() {
        int result = 0;
        for (int i = 0; i < this.coords.length; ++i) {
            result = result + (this.getCoord(i).getSup() - this.getCoord(i).getInf()) + 1;
        }
        return result += this.sid.getDomainSize();
    }

    public boolean coordInstantiated() {
        for (int i = 0; i < this.coords.length; ++i) {
            if (this.getCoord(i).isInstantiated()) continue;
            return false;
        }
        return true;
    }

    public boolean sameDomain(Obj o) {
        IntDomainVar[] idv = this.getCoordinates();
        for (int i = 0; i < idv.length; ++i) {
            if (this.getCoord(i).getDomainSize() != o.getCoord(i).getDomainSize()) {
                return false;
            }
            if (this.getCoord(i).getInf() != o.getCoord(i).getInf()) {
                return false;
            }
            if (this.getCoord(i).getSup() == o.getCoord(i).getSup()) continue;
            return false;
        }
        return true;
    }

    public void print() {
        for (int i = 0; i < this.coords.length; ++i) {
            if (!this.getCoord(i).isInstantiated()) {
                LOGGER.info(this.getCoord(i).getInf() + " " + this.getCoord(i).getSup() + ",");
                continue;
            }
            LOGGER.info(this.getCoord(i).getInf() + " ");
        }
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < this.coords.length; ++i) {
            if (i + 1 != this.coords.length) {
                if (!this.getCoord(i).isInstantiated()) {
                    res.append("[").append(this.getCoord(i).getInf()).append(",").append(this.getCoord(i).getSup()).append("],");
                    continue;
                }
                res.append(this.getCoord(i).getInf()).append(",");
                continue;
            }
            if (!this.getCoord(i).isInstantiated()) {
                res.append("[").append(this.getCoord(i).getInf()).append(",").append(this.getCoord(i).getSup()).append("]");
                continue;
            }
            res.append(this.getCoord(i).getInf()).append("");
        }
        return res.toString();
    }

    public Outbox intersect(Outbox ob) {
        int[] ob_l = ob.getL();
        int[] ob_t = ob.getT();
        int nbDim = ob_l.length;
        int[] t = new int[ob_l.length];
        int[] l = new int[ob_l.length];
        IntDomainVar[] dom = this.getCoordinates();
        for (int i = 0; i < nbDim; ++i) {
            l[i] = ob_l[i];
            if (ob_t[i] > dom[i].getSup()) {
                return null;
            }
            if (ob_t[i] < dom[i].getInf()) {
                t[i] = dom[i].getInf();
            }
            if (ob_t[i] + ob_l[i] < dom[i].getInf()) {
                return null;
            }
            if (ob_t[i] + ob_l[i] <= dom[i].getSup()) continue;
            t[i] = dom[i].getSup() >= ob_l[i] ? dom[i].getSup() - ob_l[i] : 0;
        }
        return new Outbox(t, l);
    }

    public boolean isSphere() {
        return this.radius != -1;
    }

    public int getRadius() {
        return this.radius;
    }

    public void clearInternalConstraints() {
        this.relatedInternalConstraints.clear();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.oid);
        out.writeObject(this.sid.getInf());
        out.writeObject(this.sid.getSup());
        out.writeObject(this.coords.length);
        for (int i = 0; i < this.coords.length; ++i) {
            out.writeObject(this.coords[i].getInf());
            out.writeObject(this.coords[i].getSup());
        }
        out.writeObject(this.start.getInf());
        out.writeObject(this.start.getSup());
        out.writeObject(this.duration.getInf());
        out.writeObject(this.duration.getSup());
        out.writeObject(this.end.getInf());
        out.writeObject(this.end.getSup());
        out.writeObject(this.relatedExternalConstraints);
        out.writeObject(this.relatedInternalConstraints);
        out.writeObject(this.dim);
        out.writeObject(this.radius);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public boolean isInside(Point p) {
        for (int i = 0; i < this.coords.length; ++i) {
            if (this.coords[i].canBeInstantiatedTo(p.getCoord(i))) continue;
            return false;
        }
        return true;
    }
}

