/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost.util;

import choco.Choco;
import choco.cp.model.CPModel;
import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.model.Model;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.geost.GeostObject;
import choco.kernel.model.variables.geost.ShiftedBox;
import choco.kernel.model.variables.integer.IntegerVariable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;

public final class RandomProblemGenerator {
    protected static final Logger LOGGER = ChocoLogging.getEngineLogger();
    private List<GeostObject> objects = new ArrayList<GeostObject>();
    private List<ShiftedBox> sBoxes = new ArrayList<ShiftedBox>();
    private Model m = new CPModel();
    private int nbOfObjects;
    private int nbOfShapes;
    private int nbOfShiftedBoxes;
    private int maxLength;
    private int dim;

    public RandomProblemGenerator(int k, int nbOfObjects, int nbOfShapes, int nbOfShiftedBoxes, int maxLength) {
        this.nbOfObjects = nbOfObjects;
        this.nbOfShapes = nbOfShapes;
        this.nbOfShiftedBoxes = nbOfShiftedBoxes;
        this.maxLength = maxLength;
        this.dim = k;
    }

    public void generateProb() {
        this.generateRandomProblem(this.nbOfObjects, this.nbOfShapes, this.nbOfShiftedBoxes, this.maxLength);
    }

    private void generateRandomProblem(int nbOfObjects, int nbOfShapes, int nbOfShiftedBoxes, int maxLength) {
        int j;
        int i;
        if (nbOfShapes > nbOfShiftedBoxes) {
            LOGGER.info("The number of shifted boxes should be greater or equal to the number of shapes");
            return;
        }
        Random rnd = new Random();
        int[] maxDomain = new int[this.dim];
        ArrayList<Integer> shapeIDS = new ArrayList<Integer>();
        for (i = 0; i < nbOfShapes; ++i) {
            shapeIDS.add(i, i);
        }
        for (i = 0; i < nbOfObjects; ++i) {
            int index = rnd.nextInt(shapeIDS.size());
            int sid = (Integer)shapeIDS.get(index);
            shapeIDS.remove(index);
            IntegerVariable shapeId = Choco.makeIntVar("sid", sid, sid, new String[0]);
            Variable[] coords = new IntegerVariable[this.dim];
            for (int j2 = 0; j2 < this.dim; ++j2) {
                int max = rnd.nextInt(maxLength);
                while (max == 0) {
                    max = rnd.nextInt(maxLength);
                }
                int min = rnd.nextInt(max);
                coords[j2] = Choco.makeIntVar("x" + j2, min, max, new String[0]);
            }
            this.m.addVariables("cp:bound", coords);
            IntegerVariable start = Choco.makeIntVar("start", 1, 1, new String[0]);
            IntegerVariable duration = Choco.makeIntVar("duration", 1, 1, new String[0]);
            IntegerVariable end = Choco.makeIntVar("end", 1, 1, new String[0]);
            this.objects.add(new GeostObject(this.dim, i, shapeId, (IntegerVariable[])coords, start, duration, end));
        }
        for (i = 0; i < this.dim; ++i) {
            int max = 0;
            for (int j3 = 0; j3 < this.objects.size(); ++j3) {
                if (max >= this.objects.get(j3).getCoordinates()[i].getUppB()) continue;
                max = this.objects.get(j3).getCoordinates()[i].getUppB();
            }
            maxDomain[i] = max;
        }
        for (j = 0; j < nbOfShapes; ++j) {
            int[] t = new int[this.dim];
            int[] s = new int[this.dim];
            for (int k = 0; k < this.dim; ++k) {
                t[k] = 0;
                s[k] = rnd.nextInt(maxLength);
                while (s[k] == 0) {
                    s[k] = rnd.nextInt(maxLength);
                }
            }
            this.sBoxes.add(new ShiftedBox(j, t, s));
        }
        for (j = 0; j < nbOfShapes; ++j) {
            shapeIDS.add(j, j);
        }
        for (int remainingSBtoCreate = nbOfShiftedBoxes - nbOfShapes; remainingSBtoCreate > 0; --remainingSBtoCreate) {
            int index = rnd.nextInt(shapeIDS.size());
            int sid = (Integer)shapeIDS.get(index);
            for (int i2 = 0; i2 < this.sBoxes.size(); ++i2) {
                if (this.sBoxes.get(i2).getShapeId() != sid) continue;
                index = i2;
                break;
            }
            int[] t = new int[this.dim];
            int[] s = new int[this.dim];
            for (int k = 0; k < this.dim; ++k) {
                t[k] = rnd.nextInt(this.sBoxes.get(index).getSize(k));
                s[k] = rnd.nextInt(maxLength);
                while (s[k] == 0) {
                    s[k] = rnd.nextInt(maxLength);
                }
            }
            this.sBoxes.add(new ShiftedBox(this.sBoxes.get(index).getShapeId(), t, s));
        }
    }

    public List<GeostObject> getObjects() {
        return this.objects;
    }

    public List<ShiftedBox> getSBoxes() {
        return this.sBoxes;
    }

    public Model getModel() {
        return this.m;
    }
}

