/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class MinOfAList
extends AbstractLargeIntSConstraint {
    public static final int MIN_INDEX = 0;
    public static final int VARS_OFFSET = 1;
    protected final IStateInt indexOfMinimumVariable;

    public MinOfAList(IEnvironment environment, IntDomainVar[] vars) {
        super(ConstraintEvent.QUADRATIC, vars);
        this.indexOfMinimumVariable = environment.makeInt(-1);
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 11;
    }

    protected void onlyOneMaxCandidatePropagation() throws ContradictionException {
        int idx;
        int nbVars = ((IntDomainVar[])this.vars).length;
        IntDomainVar minVar = ((IntDomainVar[])this.vars)[0];
        if (this.indexOfMinimumVariable.get() == -1) {
            int minMin = Integer.MAX_VALUE;
            int minMinIdx = -1;
            int minMin2 = Integer.MAX_VALUE;
            int minMin2Idx = -1;
            for (int i = 1; i < nbVars; ++i) {
                int val = ((IntDomainVar[])this.vars)[i].getInf();
                if (val <= minMin) {
                    minMin2 = minMin;
                    minMin2Idx = minMinIdx;
                    minMin = val;
                    minMinIdx = i;
                    continue;
                }
                if (val >= minMin2) continue;
                minMin2 = val;
                minMin2Idx = i;
            }
            if (minMin2 > minVar.getSup()) {
                this.indexOfMinimumVariable.set(minMinIdx);
            }
        }
        if ((idx = this.indexOfMinimumVariable.get()) != -1) {
            minVar.updateSup(((IntDomainVar[])this.vars)[idx].getSup(), this, false);
            ((IntDomainVar[])this.vars)[idx].updateSup(minVar.getSup(), this, false);
        }
    }

    protected boolean testIfOneCandidateToTakeMaxValue() {
        int minValue = ((IntDomainVar[])this.vars)[0].getVal();
        int nbVars = ((IntDomainVar[])this.vars).length;
        boolean existsInstantiated = false;
        for (int i = 1; i < nbVars; ++i) {
            if (((IntDomainVar[])this.vars)[i].getInf() <= minValue) {
                return false;
            }
            if (((IntDomainVar[])this.vars)[i].getSup() != minValue) continue;
            existsInstantiated = true;
        }
        return existsInstantiated;
    }

    protected final int minInf() {
        int nbVars = ((IntDomainVar[])this.vars).length;
        int min = Integer.MAX_VALUE;
        for (int i = 1; i < nbVars; ++i) {
            int val = ((IntDomainVar[])this.vars)[i].getInf();
            if (val >= min) continue;
            min = val;
        }
        return min;
    }

    protected final int minSup() {
        int nbVars = ((IntDomainVar[])this.vars).length;
        int min = Integer.MAX_VALUE;
        for (int i = 1; i < nbVars; ++i) {
            int val = ((IntDomainVar[])this.vars)[i].getSup();
            if (val >= min) continue;
            min = val;
        }
        return min;
    }

    @Override
    public void propagate() throws ContradictionException {
        int nbVars = ((IntDomainVar[])this.vars).length;
        IntDomainVar minVar = ((IntDomainVar[])this.vars)[0];
        minVar.updateInf(this.minInf(), this, false);
        minVar.updateSup(this.minSup(), this, false);
        int minValue = minVar.getInf();
        for (int i = 1; i < nbVars; ++i) {
            ((IntDomainVar[])this.vars)[i].updateInf(minValue, this, false);
        }
        this.onlyOneMaxCandidatePropagation();
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (idx >= 1) {
            ((IntDomainVar[])this.vars)[0].updateInf(this.minInf(), this, false);
            this.onlyOneMaxCandidatePropagation();
        } else {
            int nbVars = ((IntDomainVar[])this.vars).length;
            int minVal = ((IntDomainVar[])this.vars)[0].getInf();
            for (int i = 1; i < nbVars; ++i) {
                ((IntDomainVar[])this.vars)[i].updateInf(minVal, this, false);
            }
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (idx >= 1) {
            ((IntDomainVar[])this.vars)[0].updateSup(this.minSup(), this, false);
        } else {
            this.onlyOneMaxCandidatePropagation();
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx >= 1) {
            IntDomainVar minVar = ((IntDomainVar[])this.vars)[0];
            minVar.updateInf(this.minInf(), this, false);
            minVar.updateSup(this.minSup(), this, false);
        } else {
            int nbVars = ((IntDomainVar[])this.vars).length;
            int minValue = ((IntDomainVar[])this.vars)[0].getInf();
            for (int i = 1; i < nbVars; ++i) {
                ((IntDomainVar[])this.vars)[i].updateInf(minValue, this, false);
            }
            this.onlyOneMaxCandidatePropagation();
        }
    }

    @Override
    public Boolean isEntailed() {
        int minInf = ((IntDomainVar[])this.vars)[0].getInf();
        int minSup = ((IntDomainVar[])this.vars)[0].getSup();
        int cptIn = 0;
        int cptBelow = 0;
        for (int i = 1; i < ((IntDomainVar[])this.vars).length; ++i) {
            IntDomainVar tmp = ((IntDomainVar[])this.vars)[i];
            int inf = tmp.getInf();
            int sup = tmp.getSup();
            if (inf == minInf && minSup == sup && sup == inf) {
                ++cptIn;
                continue;
            }
            if (sup < minInf) {
                return Boolean.FALSE;
            }
            if (inf <= minSup) continue;
            ++cptBelow;
        }
        if (cptBelow == ((IntDomainVar[])this.vars).length - 1) {
            return Boolean.FALSE;
        }
        if (cptIn > 0) {
            return Boolean.TRUE;
        }
        return null;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        int minValue = Integer.MAX_VALUE;
        for (int i = 1; i < ((IntDomainVar[])this.vars).length; ++i) {
            if (minValue <= tuple[i]) continue;
            minValue = tuple[i];
        }
        return tuple[0] == minValue;
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        sb.append(((IntDomainVar[])this.vars)[0].pretty()).append(" = min({");
        for (int i = 1; i < ((IntDomainVar[])this.vars).length; ++i) {
            if (i > 1) {
                sb.append(", ");
            }
            sb.append(((IntDomainVar[])this.vars)[i].pretty());
        }
        sb.append("})");
        return sb.toString();
    }
}

