/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.channeling;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractBinIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class BooleanChanneling
extends AbstractBinIntSConstraint {
    protected int cste;

    public BooleanChanneling(IntDomainVar yij, IntDomainVar xi, int j) {
        super(yij, xi);
        this.cste = j;
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (idx == 0) {
            if (this.v0.hasEnumeratedDomain()) {
                return 4;
            }
            return 3;
        }
        if (this.v1.hasEnumeratedDomain()) {
            return 4;
        }
        return 3;
    }

    public void filterFromBtoX() throws ContradictionException {
        if (this.v0.isInstantiated()) {
            if (this.v0.isInstantiatedTo(0)) {
                this.v1.removeVal(this.cste, this, false);
            } else {
                this.v1.instantiate(this.cste, this, false);
            }
        }
    }

    public void filterFromXtoB() throws ContradictionException {
        if (this.v1.canBeInstantiatedTo(this.cste)) {
            if (this.v1.isInstantiatedTo(this.cste)) {
                this.v0.instantiate(1, this, false);
            }
        } else {
            this.v0.instantiate(0, this, false);
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        this.filterFromXtoB();
        this.filterFromBtoX();
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (idx == 0) {
            this.filterFromBtoX();
        } else {
            this.filterFromXtoB();
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (idx == 0) {
            this.filterFromBtoX();
        } else {
            this.filterFromXtoB();
        }
    }

    @Override
    public void awakeOnRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
        if (idx == 0) {
            this.filterFromBtoX();
        } else {
            this.filterFromXtoB();
        }
    }

    @Override
    public Boolean isEntailed() {
        if (!this.v1.canBeInstantiatedTo(this.cste)) {
            return Boolean.TRUE;
        }
        return null;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        int val = tuple[1];
        return val == this.cste && tuple[0] == 1 || val != this.cste && tuple[0] == 0;
    }

    @Override
    public String pretty() {
        return "(" + this.v0.pretty() + " = 1)  <=> (" + this.v1.pretty() + " = " + this.cste + ")";
    }
}

