/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.goals.choice;

import choco.cp.solver.goals.GoalHelper;
import choco.cp.solver.goals.choice.Instantiate;
import choco.cp.solver.search.integer.varselector.MinDomain;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.branch.VarSelector;
import choco.kernel.solver.goals.Goal;
import choco.kernel.solver.goals.GoalType;
import choco.kernel.solver.search.ValIterator;
import choco.kernel.solver.search.ValSelector;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class Generate
implements Goal {
    protected VarSelector<IntDomainVar> varSelector;
    protected ValSelector<IntDomainVar> valSelector;
    protected ValIterator<IntDomainVar> valIterator;
    protected IntDomainVar[] vars;

    public Generate(IntDomainVar[] vars, VarSelector<IntDomainVar> varSelector, ValIterator<IntDomainVar> valIterator) {
        this(vars, varSelector);
        this.valIterator = valIterator;
    }

    public Generate(IntDomainVar[] vars, VarSelector<IntDomainVar> varSelector, ValSelector<IntDomainVar> valSelector) {
        this(vars, varSelector);
        this.valSelector = valSelector;
    }

    public Generate(IntDomainVar[] vars, VarSelector<IntDomainVar> varSelector) {
        this.varSelector = varSelector;
        this.vars = new IntDomainVar[vars.length];
        System.arraycopy(vars, 0, this.vars, 0, vars.length);
    }

    public Generate(IntDomainVar[] vars) {
        this(vars, new MinDomain(null, vars));
    }

    @Override
    public String pretty() {
        return "Generate";
    }

    @Override
    public Goal execute(Solver s) throws ContradictionException {
        IntDomainVar var = this.varSelector.selectVar();
        if (var == null) {
            return null;
        }
        if (this.valSelector != null) {
            return GoalHelper.and(new Instantiate(var, this.valSelector), this);
        }
        if (this.valIterator != null) {
            return GoalHelper.and(new Instantiate(var, this.valIterator), this);
        }
        return GoalHelper.and(new Instantiate(var), this);
    }

    @Override
    public GoalType getType() {
        return GoalType.GEN;
    }
}

