/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.real;

import choco.kernel.solver.Solver;
import choco.kernel.solver.search.real.AbstractRealVarSelector;
import choco.kernel.solver.variables.real.RealVar;

public class CyclicRealVarSelector
extends AbstractRealVarSelector {
    protected int current = -1;

    public CyclicRealVarSelector(Solver solver, RealVar[] vars) {
        super(solver, vars);
    }

    public CyclicRealVarSelector(Solver solver) {
        super(solver);
    }

    @Override
    public RealVar selectVar() {
        int nbvars = this.vars.length;
        if (nbvars == 0) {
            return null;
        }
        int start = this.current == -1 ? nbvars - 1 : this.current;
        int n = (this.current + 1) % nbvars;
        while (n != start && this.vars[n].isInstantiated()) {
            n = (n + 1) % nbvars;
        }
        if (this.vars[n].isInstantiated()) {
            return null;
        }
        this.current = n;
        return this.vars[n];
    }
}

