/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.delta;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.common.util.iterators.IntArrayIterator;
import choco.kernel.solver.variables.delta.IDeltaDomain;
import gnu.trove.TIntArrayList;

public class StackDeltaDomain
implements IDeltaDomain {
    private final TIntArrayList list = new TIntArrayList();
    boolean freeze = false;
    private int from = -1;
    private int to = 0;

    @Override
    public void freeze() {
        if (!this.freeze) {
            this.from = this.to;
            this.to = this.list.size();
            this.freeze = true;
        }
    }

    @Override
    public void remove(int value) {
        this.list.add(value);
    }

    @Override
    public void clear() {
        this.from = -1;
        this.to = 0;
        this.list.clear();
        this.freeze = false;
    }

    @Override
    public boolean isReleased() {
        return !this.freeze;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean release() {
        try {
            boolean bl = this.to == this.list.size();
            return bl;
        }
        finally {
            this.from = -1;
            this.freeze = false;
        }
    }

    @Override
    public DisposableIntIterator iterator() {
        return IntArrayIterator.getIterator(this.list.toNativeArray(), this.from, this.to);
    }

    @Override
    public String pretty() {
        return this.from + " -> " + this.to;
    }

    @Override
    public IDeltaDomain copy() {
        throw new UnsupportedOperationException();
    }
}

