/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.integer;

import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.integer.IntVar;
import java.util.Arrays;

public class IntTerm
implements IntExp {
    public static final IntTerm ZERO = new IntTerm(0);
    protected final int[] coefficients;
    protected final IntVar[] variables;
    protected final int nbVars;
    protected int constant;

    public IntTerm(int capacity) {
        this.coefficients = new int[capacity];
        this.variables = new IntVar[capacity];
        this.nbVars = capacity;
        this.constant = 0;
    }

    public IntTerm(IntTerm t1) {
        this(t1.getSize());
        System.arraycopy(t1.variables, 0, this.variables, 0, this.nbVars);
        System.arraycopy(t1.coefficients, 0, this.coefficients, 0, this.nbVars);
        this.constant = t1.constant;
    }

    public IntTerm(int[] lc, IntVar[] lv) {
        this(lc.length);
        if (lc.length != lv.length) {
            throw new SolverException("cant build scalar");
        }
        System.arraycopy(lv, 0, this.variables, 0, this.nbVars);
        System.arraycopy(lc, 0, this.coefficients, 0, this.nbVars);
    }

    public IntTerm(IntVar[] lv) {
        this(lv.length);
        System.arraycopy(lv, 0, this.variables, 0, this.nbVars);
        Arrays.fill(this.coefficients, 1);
    }

    protected IntTerm(IntTerm t1, int nbMore, boolean moreFirst) {
        this(t1.nbVars + nbMore);
        int n = t1.getSize();
        int offset = moreFirst ? nbMore : 0;
        System.arraycopy(t1.variables, 0, this.variables, offset, n);
        System.arraycopy(t1.coefficients, 0, this.coefficients, offset, n);
        this.constant = t1.constant;
    }

    public static IntTerm opposite(IntTerm t1) {
        int n = t1.getSize();
        IntTerm res = new IntTerm(n);
        System.arraycopy(t1.variables, 0, res.variables, 0, n);
        IntTerm.buildOpposite(t1, res, 0);
        res.constant = -t1.constant;
        return res;
    }

    public static IntTerm plus(IntTerm t1, int coeff, IntVar var, boolean varFirst) {
        IntTerm res = new IntTerm(t1, 1, varFirst);
        int idx = varFirst ? 0 : res.nbVars - 1;
        res.setCoefficient(idx, coeff);
        res.setVariable(idx, var);
        return res;
    }

    public static IntTerm minus(int coeff, IntVar var, IntTerm t1) {
        IntTerm res = new IntTerm(t1.getSize() + 1);
        res.setCoefficient(0, coeff);
        res.setVariable(0, var);
        System.arraycopy(t1.variables, 0, res.variables, 1, t1.getSize());
        IntTerm.buildOpposite(t1, res, 1);
        res.constant = -t1.getConstant();
        return res;
    }

    public static IntTerm plus(IntTerm t1, IntTerm t2) {
        int n1 = t1.getSize();
        int n2 = t2.getSize();
        IntTerm res = new IntTerm(t1, n2, false);
        System.arraycopy(t2.variables, 0, res.variables, n1, n2);
        System.arraycopy(t2.coefficients, 0, res.coefficients, n1, n2);
        res.constant += t2.constant;
        return res;
    }

    public static IntTerm minus(IntTerm t1, IntTerm t2) {
        int n1 = t1.getSize();
        int n2 = t2.getSize();
        IntTerm res = new IntTerm(t1, n2, false);
        System.arraycopy(t2.variables, 0, res.variables, n1, n2);
        IntTerm.buildOpposite(t2, res, n1);
        res.constant -= t2.constant;
        return res;
    }

    private static void buildOpposite(IntTerm src, IntTerm dest, int destPos) {
        int n = src.getSize();
        for (int i = 0; i < n; ++i) {
            dest.coefficients[destPos + i] = -src.coefficients[i];
        }
    }

    public final boolean isConstant() {
        return this.nbVars == 0;
    }

    public final boolean isUnary() {
        return this.nbVars == 1;
    }

    public final boolean isBinary() {
        return this.nbVars == 2;
    }

    public final boolean isBinaryMinus() {
        return this.coefficients[0] + this.coefficients[1] == 0;
    }

    public final boolean isBinaryPlus() {
        return this.coefficients[0] - this.coefficients[1] == 0;
    }

    public String pretty() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.coefficients.length; ++i) {
            int coefficient = this.coefficients[i];
            IntVar variable = this.variables[i];
            if (i > 0) {
                buf.append(" + ");
            }
            buf.append(coefficient + "*" + variable);
        }
        buf.append(" + " + this.constant);
        return buf.toString();
    }

    public final int[] getCoefficients() {
        return this.coefficients;
    }

    public final IntVar[] getVariables() {
        return this.variables;
    }

    public final int getCoefficient(int index) {
        return this.coefficients[index];
    }

    public final IntVar getVariable(int index) {
        return this.variables[index];
    }

    public final IntDomainVar getIntDVar(int index) {
        return (IntDomainVar)this.variables[index];
    }

    public final void setCoefficient(int index, int coef) {
        this.coefficients[index] = coef;
    }

    public final void setVariable(int index, IntVar var) {
        this.variables[index] = var;
    }

    public final int getSize() {
        return this.nbVars;
    }

    public final int getConstant() {
        return this.constant;
    }

    public final void setConstant(int constant) {
        this.constant = constant;
    }

    public final int[] getOppositeCoefficients() {
        int[] oc = new int[this.coefficients.length];
        for (int i = 0; i < this.coefficients.length; ++i) {
            oc[i] = -this.coefficients[i];
        }
        return oc;
    }
}

