/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.opres.pack;

import choco.kernel.common.opres.heuristics.AbstractHeuristic;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;

public abstract class AbstractHeuristic1BP
extends AbstractHeuristic
implements TIntProcedure {
    protected int capacity;
    protected TIntArrayList items;
    protected int[] bins = new int[10];
    protected int pos;
    protected int full;
    private static final int DEFAULT_CAPACITY = 10;

    private void ensureCapacity() {
        if (this.pos >= this.bins.length) {
            int newCap = this.bins.length << 1;
            int[] tmp = new int[newCap];
            System.arraycopy(this.bins, 0, tmp, 0, this.bins.length);
            this.bins = tmp;
        }
    }

    protected void createBin(int size) {
        this.ensureCapacity();
        this.bins[this.pos] = this.capacity - size;
        ++this.pos;
    }

    protected void removeBin(int offset) {
        if (this.pos > 1) {
            this.bins[offset] = this.bins[--this.pos];
        } else {
            --this.pos;
        }
        ++this.full;
    }

    protected void pack(int offset, int size) {
        int n = offset;
        this.bins[n] = this.bins[n] - size;
    }

    @Override
    public void reset() {
        super.reset();
        this.pos = 0;
        this.full = 0;
    }

    public final TIntArrayList getItems() {
        return this.items;
    }

    public final void setItems(TIntArrayList items) {
        this.items = items;
    }

    public final void setCapacity(int capacity) {
        assert (capacity > 0);
        this.capacity = capacity;
    }

    public final int getCapacity() {
        return this.capacity;
    }

    @Override
    public final int apply() {
        this.items.forEachDescending(this);
        return this.full + this.pos;
    }

    public final int executeQuick(TIntArrayList items) {
        this.reset();
        this.setItems(items);
        return this.apply();
    }

    public final int executeQuick(TIntArrayList items, int capacity) {
        this.reset();
        this.setItems(items);
        this.setCapacity(capacity);
        return this.apply();
    }
}

