/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.tools;

import choco.kernel.common.util.comparator.ConstantPermutation;
import choco.kernel.common.util.comparator.IPermutation;
import choco.kernel.common.util.comparator.Identity;
import choco.kernel.common.util.comparator.IntPermutation;
import choco.kernel.model.variables.integer.IntegerConstantVariable;
import choco.kernel.model.variables.integer.IntegerVariable;

public final class PermutationUtils {
    private PermutationUtils() {
    }

    public static IPermutation getIdentity() {
        return Identity.SINGLETON;
    }

    public static IPermutation replaceByIdentity(IPermutation permutation) {
        return permutation.isIdentity() ? Identity.SINGLETON : permutation;
    }

    public static IPermutation getSortingPermuation(int[] criteria) {
        return PermutationUtils.getSortingPermuation(criteria, false);
    }

    public static IPermutation getSortingPermuation(int[] criteria, boolean reverse) {
        return new IntPermutation(criteria, reverse);
    }

    public static IPermutation getSortingPermuation(IntegerConstantVariable[] criteria, boolean reverse) {
        return new ConstantPermutation(criteria, reverse);
    }

    public static IntegerConstantVariable[] applyPermutation(IPermutation permutation, IntegerConstantVariable[] source) {
        if (permutation.isIdentity()) {
            return source;
        }
        IntegerConstantVariable[] dest = new IntegerConstantVariable[source.length];
        permutation.applyPermutation(source, dest);
        return dest;
    }

    public static IntegerVariable[] applyPermutation(IPermutation permutation, IntegerVariable[] source) {
        if (permutation.isIdentity()) {
            return source;
        }
        IntegerVariable[] dest = new IntegerVariable[source.length];
        permutation.applyPermutation(source, dest);
        return dest;
    }
}

