/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.tools;

import choco.kernel.common.logging.ChocoLogging;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PropertyUtils {
    private static final Logger LOGGER = ChocoLogging.getMainLogger();
    public static final String TOOLS_PREFIX = "tools.";

    private PropertyUtils() {
    }

    public static void logOnAbsence(String key) {
        LOGGER.log(Level.CONFIG, "properties...[read-property-from-key:{0}][FAIL]", key);
    }

    public static void logOnFailure(String resource) {
        System.err.println("properties...[load-properties:" + resource + "][FAIL]");
    }

    public static void logOnSuccess(String resource) {
        LOGGER.log(Level.CONFIG, "properties...[load-properties:{0}]", resource);
    }

    public static void loadProperties(Properties properties, File ... files) {
        for (File file : files) {
            try {
                properties.load(new FileReader(file));
                PropertyUtils.logOnSuccess(file.getName());
            }
            catch (FileNotFoundException e) {
                PropertyUtils.logOnFailure(file.getName());
            }
            catch (IOException e) {
                PropertyUtils.logOnFailure(file.getName());
            }
        }
    }

    public static void loadProperties(Properties properties, String ... resources) {
        for (String resource : resources) {
            try {
                properties.load(new InputStreamReader(properties.getClass().getResourceAsStream(resource), "ISO-8859-1"));
                PropertyUtils.logOnSuccess(resource);
            }
            catch (IOException e) {
                PropertyUtils.logOnFailure(resource);
            }
        }
    }

    public static boolean readBoolean(Properties properties, String key, boolean defaultValue) {
        String b = properties.getProperty(key);
        if (b == null) {
            PropertyUtils.logOnAbsence(key);
            return defaultValue;
        }
        return Boolean.parseBoolean(b);
    }

    public static int readInteger(Properties properties, String key, int defaultValue) {
        String b = properties.getProperty(key);
        if (b == null) {
            PropertyUtils.logOnAbsence(key);
            return defaultValue;
        }
        return Integer.parseInt(b);
    }

    public static double readDouble(Properties properties, String key, double defaultValue) {
        String b = properties.getProperty(key);
        if (b == null) {
            PropertyUtils.logOnAbsence(key);
            return defaultValue;
        }
        return Double.parseDouble(b);
    }

    public static String readString(Properties properties, String key, String defaultValue) {
        String b = properties.getProperty(key);
        if (b == null) {
            PropertyUtils.logOnAbsence(key);
            return defaultValue;
        }
        return b;
    }

    public static <T extends Enum<T>> T readEnum(Properties properties, String key, T defaultValue) {
        String b = properties.getProperty(key);
        if (b == null) {
            PropertyUtils.logOnAbsence(key);
            return defaultValue;
        }
        return (T)Enum.valueOf(defaultValue.getClass(), b);
    }
}

