/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.integer.extension;

import choco.kernel.solver.constraints.integer.extension.BinRelation;
import choco.kernel.solver.constraints.integer.extension.ConsistencyRelation;
import choco.kernel.solver.constraints.integer.extension.ExtensionalBinRelation;
import java.util.BitSet;

public class CouplesTable
extends ConsistencyRelation
implements BinRelation,
ExtensionalBinRelation {
    protected BitSet table;
    protected int offset1;
    protected int offset2;
    protected int n2;

    public CouplesTable() {
    }

    public CouplesTable(boolean feas, int offset1, int offset2, int n1, int n2) {
        this.offset1 = offset1;
        this.offset2 = offset2;
        this.n2 = n2;
        this.table = new BitSet(n1 * n2);
        this.feasible = feas;
    }

    @Override
    public ConsistencyRelation getOpposite() {
        CouplesTable t = new CouplesTable();
        t.feasible = !this.feasible;
        t.table = this.table;
        t.offset1 = this.offset1;
        t.offset2 = this.offset2;
        t.n2 = this.n2;
        return t;
    }

    @Override
    public void setCouple(int x, int y) {
        this.table.set((x - this.offset1) * this.n2 + y - this.offset2);
    }

    public void setCoupleWithoutOffset(int x, int y) {
        this.table.set(x * this.n2 + y);
    }

    @Override
    public boolean isConsistent(int x, int y) {
        return this.table.get((x - this.offset1) * this.n2 + y - this.offset2) == this.feasible;
    }

    @Override
    public boolean checkCouple(int x, int y) {
        return this.table.get((x - this.offset1) * this.n2 + y - this.offset2);
    }
}

