/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.search;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solution;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.search.AbstractGlobalSearchStrategy;
import choco.kernel.solver.search.IObjectiveManager;
import choco.kernel.solver.variables.Var;

public abstract class AbstractOptimize
extends AbstractGlobalSearchStrategy {
    public final boolean doMaximize;
    public final Var objective;
    protected final IObjectiveManager objManager;

    protected AbstractOptimize(Solver solver, IObjectiveManager bounds, boolean maximize) {
        super(solver);
        this.objManager = bounds;
        this.objective = bounds.getObjective();
        this.doMaximize = maximize;
    }

    @Override
    public final IObjectiveManager getObjectiveManager() {
        return this.objManager;
    }

    @Override
    public void newFeasibleRootState() {
        super.newFeasibleRootState();
        this.objManager.initBounds();
    }

    @Override
    public void writeSolution(Solution sol) {
        super.writeSolution(sol);
        this.objManager.writeObjective(sol);
    }

    @Override
    public void recordSolution() {
        super.recordSolution();
        this.objManager.setBound();
        this.objManager.setTargetBound();
    }

    @Override
    public void postDynamicCut() throws ContradictionException {
        this.objManager.postTargetBound();
    }

    @Override
    protected void advancedInitialPropagation() throws ContradictionException {
        if (this.solver.getConfiguration().readBoolean("cp.init.propagation.dLB") || this.solver.getConfiguration().readBoolean("cp.search.bottom_up")) {
            this.shavingTools.destructiveLowerBound(this.objManager);
        }
        super.advancedInitialPropagation();
    }

    @Override
    public Boolean nextSolution() {
        if (this.objManager.isTargetInfeasible()) {
            return Boolean.FALSE;
        }
        return super.nextSolution();
    }

    protected final void bottomUpSearch() {
        int oldBaseWorld = this.baseWorld;
        this.baseWorld = this.solver.getWorldIndex();
        this.solver.worldPush();
        while (this.shavingTools.nextBottomUp(this.objManager) == Boolean.FALSE) {
            this.objManager.incrementFloorBound();
            if (this.objManager.isTargetInfeasible()) {
                return;
            }
            this.clearTrace();
            this.solver.worldPopUntil(this.baseWorld);
            this.solver.worldPush();
            this.nextMove = 0;
        }
        this.baseWorld = oldBaseWorld;
    }

    @Override
    public void incrementalRun() {
        this.initialPropagation();
        if (this.isFeasibleRootState()) {
            assert (this.solver.getWorldIndex() > this.baseWorld);
            if (this.solver.getConfiguration().readBoolean("cp.search.bottom_up")) {
                this.bottomUpSearch();
            } else {
                this.topDownSearch();
            }
        }
        this.endTreeSearch();
    }

    @Override
    public String partialRuntimeStatistics(boolean logOnSolution) {
        if (logOnSolution) {
            return "Objective: " + this.objManager.getObjectiveValue() + ", " + super.partialRuntimeStatistics(logOnSolution);
        }
        return "Upper-bound: " + this.objManager.getBestObjectiveValue() + ", " + super.partialRuntimeStatistics(logOnSolution);
    }

    @Override
    public String runtimeStatistics() {
        return "  " + (this.doMaximize ? "Maximize: " : "Minimize: ") + this.objective + '\n' + super.runtimeStatistics();
    }

    @Override
    public void restoreBestSolution() {
        super.restoreBestSolution();
        if (!this.objManager.getBestObjectiveValue().equals(this.objManager.getObjectiveValue())) {
            throw new SolverException("Illegal state: the best objective " + this.objManager.getBestObjectiveValue() + " is not equal to the best solution objective " + this.objManager.getObjectiveValue());
        }
    }
}

