/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.search;

import choco.kernel.solver.search.AbstractGlobalSearchStrategy;
import choco.kernel.solver.search.FifoSolutionPool;
import choco.kernel.solver.search.ISolutionPool;
import choco.kernel.solver.search.InfiniteSolutionPool;
import choco.kernel.solver.search.NoSolutionPool;
import choco.kernel.solver.search.OneSolutionPool;

public final class SolutionPoolFactory {
    private SolutionPoolFactory() {
    }

    public static ISolutionPool makeNoSolutionPool() {
        return NoSolutionPool.SINGLETON;
    }

    public static ISolutionPool makeOneSolutionPool(AbstractGlobalSearchStrategy strategy) {
        return new OneSolutionPool(strategy);
    }

    public static ISolutionPool makeFifoSolutionPool(AbstractGlobalSearchStrategy strategy, int capacity) {
        return new FifoSolutionPool(strategy, capacity);
    }

    public static ISolutionPool makeInfiniteSolutionPool(AbstractGlobalSearchStrategy strategy) {
        return new InfiniteSolutionPool(strategy);
    }

    public static ISolutionPool makeDefaultSolutionPool(AbstractGlobalSearchStrategy strategy, int capacity) {
        if (capacity == 1) {
            return SolutionPoolFactory.makeOneSolutionPool(strategy);
        }
        if (capacity == Integer.MAX_VALUE) {
            return SolutionPoolFactory.makeInfiniteSolutionPool(strategy);
        }
        if (capacity < 1) {
            return SolutionPoolFactory.makeNoSolutionPool();
        }
        return SolutionPoolFactory.makeFifoSolutionPool(strategy, capacity);
    }
}

