/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.AbstractList;
import java.util.ArrayList;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.alg.AbstractPathElement;

abstract class AbstractPathElementList<V, E, T extends AbstractPathElement<V, E>>
extends AbstractList<T>
implements Cloneable {
    protected Graph<V, E> graph;
    protected int maxSize;
    protected ArrayList<T> pathElements = new ArrayList();
    protected V vertex;

    protected AbstractPathElementList(Graph<V, E> graph, int n, T t) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxSize is negative or 0");
        }
        if (t == null) {
            throw new NullPointerException("pathElement is null");
        }
        this.graph = graph;
        this.maxSize = n;
        this.vertex = ((AbstractPathElement)t).getVertex();
        this.pathElements.add(t);
    }

    protected AbstractPathElementList(Graph<V, E> graph, int n, AbstractPathElementList<V, E, T> abstractPathElementList, E e) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxSize is negative or 0");
        }
        if (abstractPathElementList == null) {
            throw new NullPointerException("elementList is null");
        }
        if (e == null) {
            throw new NullPointerException("edge is null");
        }
        this.graph = graph;
        this.maxSize = n;
        this.vertex = Graphs.getOppositeVertex(graph, e, abstractPathElementList.getVertex());
    }

    protected AbstractPathElementList(AbstractPathElementList<V, E, T> abstractPathElementList) {
        this.graph = abstractPathElementList.graph;
        this.maxSize = abstractPathElementList.maxSize;
        this.pathElements.addAll(abstractPathElementList.pathElements);
        this.vertex = abstractPathElementList.vertex;
    }

    @Override
    public T get(int n) {
        return (T)((AbstractPathElement)this.pathElements.get(n));
    }

    public V getVertex() {
        return this.vertex;
    }

    @Override
    public int size() {
        return this.pathElements.size();
    }
}

