/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental;

import java.util.Arrays;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.experimental.RandomGraphHelper;
import org.jgrapht.generate.GraphGenerator;

public class UniformRandomGraphGenerator
implements GraphGenerator {
    private final int numEdges;
    private final int numVertices;

    public UniformRandomGraphGenerator(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("must be non-negative");
        }
        if (n2 < 0 || n2 > n * (n - 1) / 2) {
            throw new IllegalArgumentException("illegal number of edges");
        }
        this.numVertices = n;
        this.numEdges = n2;
    }

    public void generateGraph(Graph graph, VertexFactory vertexFactory, Map map) {
        Object[] objectArray = RandomGraphHelper.addVertices(graph, vertexFactory, this.numVertices);
        RandomGraphHelper.addEdges(graph, Arrays.asList(objectArray), Arrays.asList(objectArray), this.numEdges);
    }
}

