/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.interfaces;

import java.util.Map;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IStereoElement;

public interface ITetrahedralChirality
extends IStereoElement<IAtom, IAtom> {
    public IAtom[] getLigands();

    public IAtom getChiralAtom();

    public Stereo getStereo();

    public void setStereo(Stereo var1);

    @Override
    public ITetrahedralChirality map(Map<IAtom, IAtom> var1, Map<IBond, IBond> var2);

    public static enum Stereo {
        CLOCKWISE,
        ANTI_CLOCKWISE;


        public static int toConfig(Stereo stereo) {
            switch (stereo) {
                case ANTI_CLOCKWISE: {
                    return 1;
                }
                case CLOCKWISE: {
                    return 2;
                }
            }
            throw new IllegalArgumentException("Unknown enum value: " + (Object)((Object)stereo));
        }

        public static Stereo toStereo(int cfg) {
            switch (cfg) {
                case 1: {
                    return ANTI_CLOCKWISE;
                }
                case 2: {
                    return CLOCKWISE;
                }
            }
            throw new IllegalArgumentException("Cannot map to enum value: " + cfg);
        }

        public Stereo invert() {
            switch (this) {
                case CLOCKWISE: {
                    return ANTI_CLOCKWISE;
                }
                case ANTI_CLOCKWISE: {
                    return CLOCKWISE;
                }
            }
            return this;
        }
    }
}

