/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.tsp.cube;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdplus.toolkit.base.api.util.Validatable;
import jdplus.toolkit.base.api.util.Validations;
import jdplus.toolkit.base.tsp.cube.CubeConnection;
import jdplus.toolkit.base.tsp.cube.CubeId;
import jdplus.toolkit.base.tsp.cube.CubeSeries;
import jdplus.toolkit.base.tsp.cube.CubeSeriesWithData;
import jdplus.toolkit.base.tsp.cube.HasCubeId;
import jdplus.toolkit.base.tsp.cube.TableAsCubeUtil;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class CubeRepository
implements Validatable<CubeRepository> {
    @NonNull
    private final CubeId root;
    private final List<CubeSeriesWithData> items;
    @NonNull
    private final String name;

    @NonNull
    public CubeRepository validate() throws IllegalArgumentException {
        Validations.notBlank((CharSequence)this.name, (String)"name");
        CubeRepository.allMatch(this.items, o -> this.root.isAncestorOf(o.getId()), "items");
        return this;
    }

    @NonNull
    public CubeConnection asConnection() {
        return new CubeRepositoryConnection();
    }

    private static <T, C extends Collection<T>> C allMatch(C actual, @NonNull Predicate<T> expected, @NonNull String message) throws IllegalArgumentException {
        if (expected == null) {
            throw new NullPointerException("expected is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return (C)((Collection)Validations.on(actual, collection -> collection.stream().allMatch(expected), o -> message));
    }

    public static CubeId checkNode(CubeId id) {
        if (id.isSeries() || id.isVoid()) {
            throw new IllegalArgumentException(id.toString());
        }
        return id;
    }

    public static CubeId checkLeaf(CubeId id) {
        if (!id.isSeries() && !id.isVoid()) {
            throw new IllegalArgumentException(id.toString());
        }
        return id;
    }

    @Generated
    CubeRepository(@NonNull CubeId root, List<CubeSeriesWithData> items, @NonNull String name) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.root = root;
        this.items = items;
        this.name = name;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull Builder builder() {
        return new Builder();
    }

    @NonNull
    @Generated
    public CubeId getRoot() {
        return this.root;
    }

    @Generated
    public List<CubeSeriesWithData> getItems() {
        return this.items;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CubeRepository)) {
            return false;
        }
        CubeRepository other = (CubeRepository)o;
        CubeId this$root = this.getRoot();
        CubeId other$root = other.getRoot();
        if (this$root == null ? other$root != null : !((Object)this$root).equals(other$root)) {
            return false;
        }
        List<CubeSeriesWithData> this$items = this.getItems();
        List<CubeSeriesWithData> other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CubeId $root = this.getRoot();
        result = result * 59 + ($root == null ? 43 : ((Object)$root).hashCode());
        List<CubeSeriesWithData> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "CubeRepository(root=" + String.valueOf(this.getRoot()) + ", items=" + String.valueOf(this.getItems()) + ", name=" + this.getName() + ")";
    }

    private final class CubeRepositoryConnection
    implements CubeConnection {
        private CubeRepositoryConnection() {
        }

        @Override
        @NonNull
        public Optional<IOException> testConnection() {
            return Optional.empty();
        }

        @Override
        @NonNull
        public CubeId getRoot() {
            return CubeRepository.this.root;
        }

        @Override
        @NonNull
        public Stream<CubeSeries> getAllSeries(@NonNull CubeId id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            CubeRepository.checkNode(id);
            return CubeRepository.this.items.stream().filter(ts -> id.isAncestorOf(ts.getId())).map(CubeSeriesWithData::withoutData);
        }

        @Override
        @NonNull
        public Stream<CubeSeriesWithData> getAllSeriesWithData(@NonNull CubeId id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            CubeRepository.checkNode(id);
            return CubeRepository.this.items.stream().filter(ts -> id.isAncestorOf(ts.getId()));
        }

        @Override
        @NonNull
        public Optional<CubeSeries> getSeries(@NonNull CubeId id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            CubeRepository.checkLeaf(id);
            return CubeRepository.this.items.stream().filter(ts -> id.equals((Object)ts.getId())).map(CubeSeriesWithData::withoutData).findFirst();
        }

        @Override
        @NonNull
        public Optional<CubeSeriesWithData> getSeriesWithData(@NonNull CubeId id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            CubeRepository.checkLeaf(id);
            return CubeRepository.this.items.stream().filter(ts -> id.equals((Object)ts.getId())).findFirst();
        }

        @Override
        @NonNull
        public Stream<CubeId> getChildren(@NonNull CubeId id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            CubeRepository.checkNode(id);
            return CubeRepository.this.items.stream().map(HasCubeId::getId).filter(id::isAncestorOf).map(child -> child.getDimensionValue(id.getLevel())).distinct().sorted().map(xva$0 -> id.child((String)xva$0));
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return CubeRepository.this.name;
        }

        @Override
        @NonNull
        public String getDisplayName(@NonNull CubeId id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            return TableAsCubeUtil.getDisplayName(id, Collectors.joining(", "));
        }

        @Override
        @NonNull
        public String getDisplayNodeName(@NonNull CubeId id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            return TableAsCubeUtil.getDisplayNodeName(id);
        }

        @Override
        public void close() {
        }
    }

    public static final class Builder
    implements Validatable.Builder<CubeRepository> {
        @Generated
        private CubeId root;
        @Generated
        private ArrayList<CubeSeriesWithData> items;
        @Generated
        private String name;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder root(@NonNull CubeId root) {
            if (root == null) {
                throw new NullPointerException("root is marked non-null but is null");
            }
            this.root = root;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder item(CubeSeriesWithData item) {
            if (this.items == null) {
                this.items = new ArrayList();
            }
            this.items.add(item);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder items(@org.jspecify.annotations.NonNull Collection<? extends CubeSeriesWithData> items) {
            if (items == null) {
                throw new NullPointerException("items cannot be null");
            }
            if (this.items == null) {
                this.items = new ArrayList();
            }
            this.items.addAll(items);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearItems() {
            if (this.items != null) {
                this.items.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull CubeRepository buildWithoutValidation() {
            return new CubeRepository(this.root, switch (this.items == null ? 0 : this.items.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.items.get(0));
                default -> Collections.unmodifiableList(new ArrayList<CubeSeriesWithData>(this.items));
            }, this.name);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "CubeRepository.Builder(root=" + String.valueOf(this.root) + ", items=" + String.valueOf(this.items) + ", name=" + this.name + ")";
        }
    }
}

