/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import jdplus.toolkit.base.api.time.ISO_8601;
import jdplus.toolkit.base.api.time.TemporalFormatter;
import jdplus.toolkit.base.api.time.TimeIntervalAccessor;
import jdplus.toolkit.base.api.time.TimeIntervalFormatter;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

@ISO_8601
public final class TimePoint
implements TimeSeriesInterval<Duration> {
    @NonNull
    private final LocalDateTime point;
    private static final TimeIntervalFormatter.StartEnd ISO_8601 = TimeIntervalFormatter.StartEnd.of(TemporalFormatter.EXTENDED_CALENDAR_TIME, LocalDateTime::from, false);

    @Override
    @NonNull
    public LocalDateTime start() {
        return this.point;
    }

    @Override
    @NonNull
    public LocalDateTime end() {
        return this.point;
    }

    @Override
    public boolean contains(@NonNull LocalDateTime element) {
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        return this.point.equals(element);
    }

    @Override
    @NonNull
    public Duration getDuration() {
        return Duration.ZERO;
    }

    public String toString() {
        return ISO_8601.format(this);
    }

    @NonNull
    public static TimePoint parse(@NonNull CharSequence text) throws DateTimeParseException {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return ISO_8601.parse(text, TimePoint::from);
    }

    @NonNull
    public static TimePoint from(@NonNull TimeIntervalAccessor timeInterval) {
        if (timeInterval == null) {
            throw new NullPointerException("timeInterval is marked non-null but is null");
        }
        return TimePoint.of(LocalDateTime.from(timeInterval.start()));
    }

    @Generated
    private TimePoint(@NonNull LocalDateTime point) {
        if (point == null) {
            throw new NullPointerException("point is marked non-null but is null");
        }
        this.point = point;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull TimePoint of(@NonNull LocalDateTime point) {
        if (point == null) {
            throw new NullPointerException("point is marked non-null but is null");
        }
        return new TimePoint(point);
    }

    @NonNull
    @Generated
    public LocalDateTime getPoint() {
        return this.point;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimePoint)) {
            return false;
        }
        TimePoint other = (TimePoint)o;
        LocalDateTime this$point = this.getPoint();
        LocalDateTime other$point = other.getPoint();
        return !(this$point == null ? other$point != null : !((Object)this$point).equals(other$point));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDateTime $point = this.getPoint();
        result = result * 59 + ($point == null ? 43 : ((Object)$point).hashCode());
        return result;
    }
}

