## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

options(gtsummary.print_engine = "gt")

## ----setup--------------------------------------------------------------------
# library(sumExtras)
# library(gtsummary)
# library(gt)

## ----setup2-------------------------------------------------------------------
library(sumExtras)
library(gtsummary)
library(gt)

## -----------------------------------------------------------------------------
use_jama_theme()

trial |>
  tbl_summary(by = trt) |>
  extras()

## ----eval=FALSE---------------------------------------------------------------
# gtsummary::reset_gtsummary_theme()

## ----gt-default, eval=FALSE---------------------------------------------------
# trial |>
#   select(trt, age, grade) |>
#   head(10) |>
#   gt::gt()

## ----gt-compact, eval=FALSE---------------------------------------------------
# trial |>
#   select(trt, age, grade) |>
#   head(10) |>
#   gt::gt() |>
#   theme_gt_compact()

## ----build-gt-theme, echo=FALSE-----------------------------------------------
table_gt_default <- trial |>
  dplyr::select(trt, age, grade) |>
  head(10) |>
  gt::gt()

table_gt_compact <- trial |>
  dplyr::select(trt, age, grade) |>
  head(10) |>
  gt::gt() |>
  theme_gt_compact()

## ----render-gt-default, echo=FALSE--------------------------------------------
table_gt_default

## ----render-gt-compact, echo=FALSE--------------------------------------------
table_gt_compact

## -----------------------------------------------------------------------------
trial |>
  dplyr::select(trt, age, grade, marker) |>
  head(8) |>
  gt::gt() |>
  theme_gt_compact() |>
  gt::tab_header(
    title = "Trial Patient Sample",
    subtitle = "First 8 patients"
  )

