/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.DifferentiableUnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.integration.SimpsonIntegrator;
import org.apache.commons.math.analysis.solvers.NewtonSolver;

public abstract class KernelDensityEstimatorDistribution
implements Distribution {
    protected int N;
    protected double lowerBound;
    protected double upperBound;
    double bandWidth;
    protected double[] sample;
    private final SimpsonIntegrator integrator = new SimpsonIntegrator();
    private final UnivariateRealFunction pdfFunction = new UnivariateRealFunction(){

        @Override
        public double value(double d) throws FunctionEvaluationException {
            return KernelDensityEstimatorDistribution.this.pdf(d);
        }
    };
    private final UnivariateRealFunction cdfFunction = new UnivariateRealFunction(){

        @Override
        public double value(double d) throws FunctionEvaluationException {
            double d2;
            double d3 = KernelDensityEstimatorDistribution.this.getFromPoint();
            try {
                d2 = KernelDensityEstimatorDistribution.this.integrator.integrate(KernelDensityEstimatorDistribution.this.pdfFunction, d3, d);
            }
            catch (MaxIterationsExceededException maxIterationsExceededException) {
                throw new RuntimeException(maxIterationsExceededException.getMessage());
            }
            return d2;
        }
    };

    KernelDensityEstimatorDistribution(Double[] doubleArray, Double d, Double d2, Double d3) {
        this.sample = new double[doubleArray.length];
        for (int i = 0; i < doubleArray.length; ++i) {
            this.sample[i] = doubleArray[i];
        }
        this.N = doubleArray.length;
        this.processBounds(d, d2);
        this.setBandWidth(d3);
    }

    protected abstract double evaluateKernel(double var1);

    protected abstract void processBounds(Double var1, Double var2);

    protected abstract void setBandWidth(Double var1);

    public abstract double getFromPoint();

    public abstract double getToPoint();

    @Override
    public double pdf(double d) {
        return this.evaluateKernel(d);
    }

    @Override
    public double logPdf(double d) {
        return Math.log(this.pdf(d));
    }

    @Override
    public double cdf(double d) {
        double d2;
        try {
            d2 = this.cdfFunction.value(d);
        }
        catch (FunctionEvaluationException functionEvaluationException) {
            throw new RuntimeException(functionEvaluationException.getMessage());
        }
        return d2;
    }

    @Override
    public double quantile(final double d) {
        double d2;
        DifferentiableUnivariateRealFunction differentiableUnivariateRealFunction = new DifferentiableUnivariateRealFunction(){

            @Override
            public UnivariateRealFunction derivative() {
                return KernelDensityEstimatorDistribution.this.pdfFunction;
            }

            @Override
            public double value(double d2) throws FunctionEvaluationException {
                return KernelDensityEstimatorDistribution.this.cdfFunction.value(d2) - d;
            }
        };
        NewtonSolver newtonSolver = new NewtonSolver(differentiableUnivariateRealFunction);
        try {
            d2 = newtonSolver.solve(this.getFromPoint(), this.getToPoint());
        }
        catch (MaxIterationsExceededException maxIterationsExceededException) {
            throw new RuntimeException(maxIterationsExceededException.getMessage());
        }
        catch (FunctionEvaluationException functionEvaluationException) {
            throw new RuntimeException(functionEvaluationException.getMessage());
        }
        return d2;
    }

    @Override
    public double mean() {
        throw new RuntimeException("Not Implemented.");
    }

    @Override
    public double variance() {
        throw new RuntimeException("Not Implemented.");
    }

    @Override
    public UnivariateFunction getProbabilityDensityFunction() {
        throw new RuntimeException("Not Implemented.");
    }

    public double getBandWidth() {
        return this.bandWidth;
    }

    public static enum Type {
        GAUSSIAN("Gaussian"),
        GAMMA("Gamma"),
        LOG_TRANSFORMED_GAUSSIAN("LogTransformedGaussian"),
        BETA("Beta");

        private final String text;

        private Type(String string2) {
            this.text = string2;
        }

        public String getText() {
            return this.text;
        }

        public static Type parseFromString(String string) {
            for (Type type : Type.values()) {
                if (type.getText().compareToIgnoreCase(string) != 0) continue;
                return type;
            }
            return null;
        }
    }
}

