# Licensing Information for `DigestiveDataSets` Package

This package, `DigestiveDataSets`, includes datasets sourced from various R packages. In order to maintain consistency and clarity, a naming convention has been applied where suffixes are added to the dataset names to indicate the type and format of the datasets. The original content of these datasets has not been altered in any way.

## Dataset Licensing Information:

- **weight_loss_df**: 
  Originally wtloss from the MASS package, licensed under GPL-2 | GPL-3. The dataset name has been changed to 'weight_loss_df' to indicate that this dataset is a data frame object.

- **anorexia_weight_change_df**: 
  Originally anorexia from the MASS package, licensed under GPL-2 | GPL-3. The dataset name has been changed to 'anorexia_weight_change_df' to indicate that this dataset is a data frame object.    

- **gi_damage_prevention_df**:
  Originally Lanza from the HSAUR3 package, licensed under GPL-2. The dataset name has been changed to 'gi_damage_prevention_df' to indicate that this dataset is a data frame object.

- **colonoscopy_features_tbl_df**: 
  Originally gastro_data from the gmmsslm package, licensed under GPL-3. The dataset name has been changed to 'colonoscopy_features_tbl_df' to indicate that this dataset is a tibble object.   

- **pancreatic_cancer_df**: 
  Originally pancreatic from the asaur package, licensed under CC0. The dataset name has been changed to 'pancreatic_cancer_df' to indicate that this dataset is a data frame object.   

- **digestive_cancer_survival_df**: 
  Originally PATIENT from the RbyExample package, licensed under GPL (>= 2). The dataset name has been changed to 'digestive_cancer_survival_df' to indicate that this dataset is a data frame object.   

- **helicobacter_children_tbl_df**: 
  Originally Brenner from the pubh package, licensed under GPL-2. The dataset name has been changed to 'helicobacter_children_tbl_df' to indicate that this dataset is a tibble object.   

- **gastric_cancer_trial_df**: 
  Originally GTSG from the coin package, licensed under GPL-2. The dataset name has been changed to 'gastric_cancer_trial_df' to indicate that this dataset is a data frame object.   

- **bleeding_ulcers_df**: 
  Originally ulcer from the SMPracticals package, licensed underGPL (>= 2). The dataset name has been changed to 'bleeding_ulcers_df' to indicate that this dataset is a data frame object.  

- **post_ercp_pancreatitis_tbl_df**: 
  Originally indo_rct from the medicaldata package, licensed under MIT + file LICENSE. The dataset name has been changed to 'post_ercp_pancreatitis_tbl_df' to indicate that this dataset is a tibble object.  

- **intestinal_smartpill_df**: 
  Originally smartpill from the medicaldata package, licensed under MIT + file LICENSE. The dataset name has been changed to 'intestinal_smartpill_df' to indicate that this dataset is a data frame object.   

- **campylobacter_infections_ts**: 
  Originally campy from the tscount package, licensed under GPL-2 | GPL-3. The dataset name has been changed to 'campylobacter_infections_ts' to indicate that this dataset is a time series object.   

- **ecoli_infections_df**: 
  Originally ecoli from the tscount package, licensed under GPL-2 | GPL-3. The dataset name has been changed to 'ecoli_infections_df' to indicate that this dataset is a data frame object.   

- **cholera_deaths_1849_tbl_df**: 
  Originally CholeraDeaths1849 from the HistData package, licensed under GPL. The dataset name has been changed to 'cholera_deaths_1849_tbl_df' to indicate that this dataset is a tibble object.   

- **colon_stageBC_chemo_df**: 
  Originally ColonCancerChemo_df from the OncoDataSets package, licensed under GPL-3. The dataset name has been changed to 'colon_stageBC_chemo_df' to indicate that this dataset is a data frame object.   

- **crc_mirnas_pubmed_tbl_df**: 
  Originally ColorectalMiRNAs_tbl_df from the OncoDataSets package, licensed under GPL-3. The dataset name has been changed to 'crc_mirnas_pubmed_tbl_df' to indicate that this dataset is a tibble object.  

- **lynch_ontario_families_df**: 
  Originally LSfam from the FamEvent package, licensed under GPL (>= 2.0). The dataset name has been changed to 'lynch_ontario_families_df' to indicate that this dataset is a data frame object.  

- **horse_colic_surgery_df**: 
  Originally colic from the VIM package, licensed under GPL (>= 2). The dataset name has been changed to 'horse_colic_surgery_df' to indicate that this dataset is a  data frame object.   

- **norovirus_derbyshire_df**: 
  Originally norovirus_derbyshire_2001_school from the outbreaks package, licensed under GPL (>= 2). The dataset name has been changed to 'norovirus_derbyshire_df' to indicate that this dataset is a data frame object.   

- **intestinal_surgery_df**: 
  Originally surg from the deconvolveR package, licensed under GPL (>= 2). The dataset name has been changed to 'intestinal_surgery_df' to indicate that this dataset is a data frame object.   

- **liver_cirrhosis_prednisone_df**: 
  Originally liver from the JSM package, licensed under BSD_3_clause + file LICENSE. The dataset name has been changed to 'liver_cirrhosis_prednisone_df' to indicate that this dataset is a data frame object.  

- **pbc_mayo_survival_df**: 
  Originally pbc from the JSM package, licensed under BSD_3_clause + file LICENSE. The dataset name has been changed to 'pbc_mayo_survival_df' to indicate that this dataset is a data frame object.   

- **ugi_bleeding_df**: 
  Originally dat.collins1985a from the metadat package, licensed under GPL (>= 2). The dataset name has been changed to 'ugi_bleeding_df' to indicate that this dataset is a data frame object.   

- **ibs_cam_trials_df**: 
  Originally dat.dorn2007 from the metadat package, licensed under GPL (>= 2). The dataset name has been changed to 'ibs_cam_trials_df' to indicate that this dataset is a data frame object. 

- **cystic_fibrosis_snps_df**: 
  Originally cf from the gap.datasets package, licensed under GPL (>= 2). The dataset name has been changed to 'cystic_fibrosis_snps_df' to indicate that this dataset is a data frame object. 



## License

All datasets in this package are provided under the same licenses as their original sources. The licensing information and any specific attribution required for each dataset can be found within their respective packages. The user must adhere to the licensing terms specified by each original source.

This package, `DigestiveDataSets`, is licensed under the GPL-3 License.
