/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.function.tobject.IntIntObjectFunction;
import cern.colt.function.tobject.ObjectFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SparseCCObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.WrapperObjectMatrix2D;
import java.util.Arrays;

public class SparseRCObjectMatrix2D
extends WrapperObjectMatrix2D {
    private static final long serialVersionUID = 1L;
    protected int[] rowPointers;
    protected int[] columnIndexes;
    protected Object[] values;
    protected boolean columnIndexesSorted;

    private static int searchFromTo(int[] nArray, int n, int n2, int n3) {
        while (n2 <= n3) {
            if (nArray[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -(n2 + 1);
    }

    public SparseRCObjectMatrix2D(Object[][] objectArray) {
        this(objectArray.length, objectArray.length == 0 ? 0 : objectArray[0].length);
        this.assign(objectArray);
    }

    public SparseRCObjectMatrix2D(int n, int n2) {
        this(n, n2, (int)Math.min(10L * (long)n, Integer.MAX_VALUE));
    }

    public SparseRCObjectMatrix2D(int n, int n2, int n3) {
        block2: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.columnIndexes = new int[n3];
        this.values = new Object[n3];
        this.rowPointers = new int[n + 1];
    }

    public SparseRCObjectMatrix2D(int n, int n2, int[] nArray, int[] nArray2, Object object, boolean bl) {
        int n3;
        block7: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block7;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (object == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        int n4 = Math.max(nArray.length, 1);
        this.columnIndexes = new int[n4];
        this.values = new Object[n4];
        this.rowPointers = new int[n + 1];
        int[] nArray3 = new int[n];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray[n3];
            nArray3[n5] = nArray3[n5] + 1;
        }
        this.cumsum(this.rowPointers, nArray3, n);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray[n3];
            nArray3[n6] = nArray3[n6] + 1;
            this.columnIndexes[var9_11] = nArray2[n3];
            this.values[var9_11] = object;
        }
        if (bl) {
            this.sortColumnIndexes();
        }
    }

    public SparseRCObjectMatrix2D(int n, int n2, int[] nArray, int[] nArray2, Object[] objectArray, boolean bl, boolean bl2) {
        int n3;
        block8: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block8;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (nArray.length != objectArray.length) {
            throw new IllegalArgumentException("rowIndexes.length != values.length");
        }
        int n4 = Math.max(nArray.length, 1);
        this.columnIndexes = new int[n4];
        this.values = new Object[n4];
        this.rowPointers = new int[n + 1];
        int[] nArray3 = new int[n];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray[n3];
            nArray3[n5] = nArray3[n5] + 1;
        }
        this.cumsum(this.rowPointers, nArray3, n);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray[n3];
            nArray3[n6] = nArray3[n6] + 1;
            this.columnIndexes[var10_12] = nArray2[n3];
            this.values[var10_12] = objectArray[n3];
        }
        if (bl) {
            this.removeZeroes();
        }
        if (bl2) {
            this.sortColumnIndexes();
        }
    }

    public SparseRCObjectMatrix2D(int n, int n2, int[] nArray, int[] nArray2, Object[] objectArray) {
        block3: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != n + 1) {
            throw new IllegalArgumentException("rowPointers.length != rows + 1");
        }
        this.rowPointers = nArray;
        this.columnIndexes = nArray2;
        this.values = objectArray;
    }

    public ObjectMatrix2D assign(final ObjectFunction objectFunction) {
        this.forEachNonZero(new IntIntObjectFunction(){

            public Object apply(int n, int n2, Object object) {
                return objectFunction.apply(object);
            }
        });
        return this;
    }

    public ObjectMatrix2D assign(Object object) {
        if (object == null) {
            Arrays.fill(this.rowPointers, 0);
            Arrays.fill(this.columnIndexes, 0);
            Arrays.fill(this.values, null);
        } else {
            int n = this.cardinality();
            for (int i = 0; i < n; ++i) {
                this.values[i] = object;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D objectMatrix2D) {
        if (objectMatrix2D == this) {
            return this;
        }
        this.checkShape(objectMatrix2D);
        if (objectMatrix2D instanceof SparseRCObjectMatrix2D) {
            SparseRCObjectMatrix2D sparseRCObjectMatrix2D = (SparseRCObjectMatrix2D)objectMatrix2D;
            System.arraycopy(sparseRCObjectMatrix2D.rowPointers, 0, this.rowPointers, 0, this.rows + 1);
            int n = sparseRCObjectMatrix2D.columnIndexes.length;
            if (this.columnIndexes.length < n) {
                this.columnIndexes = new int[n];
                this.values = new Object[n];
            }
            System.arraycopy(sparseRCObjectMatrix2D.columnIndexes, 0, this.columnIndexes, 0, n);
            System.arraycopy(sparseRCObjectMatrix2D.values, 0, this.values, 0, n);
            this.columnIndexesSorted = sparseRCObjectMatrix2D.columnIndexesSorted;
        } else if (objectMatrix2D instanceof SparseCCObjectMatrix2D) {
            SparseCCObjectMatrix2D sparseCCObjectMatrix2D = ((SparseCCObjectMatrix2D)objectMatrix2D).getTranspose();
            this.rowPointers = sparseCCObjectMatrix2D.getColumnPointers();
            this.columnIndexes = sparseCCObjectMatrix2D.getRowIndexes();
            this.values = sparseCCObjectMatrix2D.getValues();
            this.columnIndexesSorted = true;
        } else {
            this.assign(0);
            objectMatrix2D.forEachNonZero(new IntIntObjectFunction(){

                public Object apply(int n, int n2, Object object) {
                    SparseRCObjectMatrix2D.this.setQuick(n, n2, object);
                    return object;
                }
            });
        }
        return this;
    }

    public int cardinality() {
        return this.rowPointers[this.rows];
    }

    public ObjectMatrix2D forEachNonZero(IntIntObjectFunction intIntObjectFunction) {
        int n = this.rows;
        while (--n >= 0) {
            int n2 = this.rowPointers[n];
            int n3 = this.rowPointers[n + 1];
            while (--n3 >= n2) {
                int n4 = this.columnIndexes[n3];
                Object object = this.values[n3];
                Object object2 = intIntObjectFunction.apply(n, n4, object);
                if (object2 == object) continue;
                this.values[n3] = object2;
            }
        }
        return this;
    }

    public SparseCCObjectMatrix2D getColumnCompressed() {
        SparseRCObjectMatrix2D sparseRCObjectMatrix2D = this.getTranspose();
        SparseCCObjectMatrix2D sparseCCObjectMatrix2D = new SparseCCObjectMatrix2D(this.rows, this.columns);
        sparseCCObjectMatrix2D.rowIndexes = sparseRCObjectMatrix2D.columnIndexes;
        sparseCCObjectMatrix2D.columnPointers = sparseRCObjectMatrix2D.rowPointers;
        sparseCCObjectMatrix2D.values = sparseRCObjectMatrix2D.values;
        sparseCCObjectMatrix2D.rowIndexesSorted = true;
        return sparseCCObjectMatrix2D;
    }

    public int[] getColumnIndexes() {
        return this.columnIndexes;
    }

    public DenseObjectMatrix2D getDense() {
        final DenseObjectMatrix2D denseObjectMatrix2D = new DenseObjectMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntObjectFunction(){

            public Object apply(int n, int n2, Object object) {
                denseObjectMatrix2D.setQuick(n, n2, SparseRCObjectMatrix2D.this.getQuick(n, n2));
                return object;
            }
        });
        return denseObjectMatrix2D;
    }

    public synchronized Object getQuick(int n, int n2) {
        int n3 = SparseRCObjectMatrix2D.searchFromTo(this.columnIndexes, n2, this.rowPointers[n], this.rowPointers[n + 1] - 1);
        Object object = 0;
        if (n3 >= 0) {
            object = this.values[n3];
        }
        return object;
    }

    public int[] getRowPointers() {
        return this.rowPointers;
    }

    public SparseRCObjectMatrix2D getTranspose() {
        int n = this.rowPointers[this.rows];
        int[] nArray = new int[this.columns];
        int[] nArray2 = new int[this.columns + 1];
        int[] nArray3 = new int[n];
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            int n2 = this.columnIndexes[i];
            nArray[n2] = nArray[n2] + 1;
        }
        this.cumsum(nArray2, nArray, this.columns);
        for (int i = 0; i < this.rows; ++i) {
            int n3 = this.rowPointers[i + 1];
            for (int j = this.rowPointers[i]; j < n3; ++j) {
                int n4 = this.columnIndexes[j];
                nArray[n4] = nArray[n4] + 1;
                nArray3[i] = i;
                objectArray[i] = this.values[j];
            }
        }
        SparseRCObjectMatrix2D sparseRCObjectMatrix2D = new SparseRCObjectMatrix2D(this.columns, this.rows);
        sparseRCObjectMatrix2D.rowPointers = nArray2;
        sparseRCObjectMatrix2D.columnIndexes = nArray3;
        sparseRCObjectMatrix2D.values = objectArray;
        return sparseRCObjectMatrix2D;
    }

    public Object[] getValues() {
        return this.values;
    }

    public boolean hasColumnIndexesSorted() {
        return this.columnIndexesSorted;
    }

    public ObjectMatrix2D like(int n, int n2) {
        return new SparseRCObjectMatrix2D(n, n2);
    }

    public ObjectMatrix1D like1D(int n) {
        return new SparseObjectMatrix1D(n);
    }

    public void removeZeroes() {
        int n = 0;
        for (int i = 0; i < this.rows; ++i) {
            this.rowPointers[i] = n;
            for (int j = this.rowPointers[i]; j < this.rowPointers[i + 1]; ++j) {
                if (this.values[j] == null) continue;
                this.values[n] = this.values[j];
                this.columnIndexes[n++] = this.columnIndexes[j];
            }
        }
        this.rowPointers[this.rows] = n;
    }

    public synchronized void setQuick(int n, int n2, Object object) {
        int n3 = SparseRCObjectMatrix2D.searchFromTo(this.columnIndexes, n2, this.rowPointers[n], this.rowPointers[n + 1] - 1);
        if (n3 >= 0) {
            if (object == null) {
                this.remove(n, n3);
            } else {
                this.values[n3] = object;
            }
            return;
        }
        if (object != null) {
            n3 = -n3 - 1;
            this.insert(n, n2, n3, object);
        }
    }

    public void sortColumnIndexes() {
        SparseRCObjectMatrix2D sparseRCObjectMatrix2D = this.getTranspose();
        this.rows = sparseRCObjectMatrix2D.rows;
        this.columns = sparseRCObjectMatrix2D.columns;
        this.columnIndexes = sparseRCObjectMatrix2D.columnIndexes;
        this.rowPointers = sparseRCObjectMatrix2D.rowPointers;
        this.values = sparseRCObjectMatrix2D.values;
        sparseRCObjectMatrix2D = this.getTranspose();
        this.rows = sparseRCObjectMatrix2D.rows;
        this.columns = sparseRCObjectMatrix2D.columns;
        this.columnIndexes = sparseRCObjectMatrix2D.columnIndexes;
        this.rowPointers = sparseRCObjectMatrix2D.rowPointers;
        this.values = sparseRCObjectMatrix2D.values;
        this.columnIndexesSorted = true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.rows; ++i) {
            int n = this.rowPointers[i + 1];
            for (int j = this.rowPointers[i]; j < n; ++j) {
                stringBuilder.append('(').append(i).append(',').append(this.columnIndexes[j]).append(')').append('\t').append(this.values[j]).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public void trimToSize() {
        this.realloc(0);
    }

    private Object cumsum(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            nArray[i] = n2;
            n2 += nArray2[i];
            d += (double)nArray2[i];
            nArray2[i] = nArray[i];
        }
        nArray[n] = n2;
        return d;
    }

    private void realloc(int n) {
        if (n <= 0) {
            n = this.rowPointers[this.rows];
        }
        int[] nArray = new int[n];
        int n2 = Math.min(n, this.columnIndexes.length);
        System.arraycopy(this.columnIndexes, 0, nArray, 0, n2);
        this.columnIndexes = nArray;
        Object[] objectArray = new Object[n];
        n2 = Math.min(n, this.values.length);
        System.arraycopy(this.values, 0, objectArray, 0, n2);
        this.values = objectArray;
    }

    protected ObjectMatrix2D getContent() {
        return this;
    }

    protected void insert(int n, int n2, int n3, Object object) {
        IntArrayList intArrayList = new IntArrayList(this.columnIndexes);
        intArrayList.setSizeRaw(this.rowPointers[this.rows]);
        ObjectArrayList objectArrayList = new ObjectArrayList(this.values);
        objectArrayList.setSizeRaw(this.rowPointers[this.rows]);
        intArrayList.beforeInsert(n3, n2);
        objectArrayList.beforeInsert(n3, object);
        int n4 = this.rowPointers.length;
        while (--n4 > n) {
            int n5 = n4;
            this.rowPointers[n5] = this.rowPointers[n5] + 1;
        }
        this.columnIndexes = intArrayList.elements();
        this.values = objectArrayList.elements();
    }

    protected void remove(int n, int n2) {
        IntArrayList intArrayList = new IntArrayList(this.columnIndexes);
        intArrayList.setSizeRaw(this.rowPointers[this.rows]);
        ObjectArrayList objectArrayList = new ObjectArrayList(this.values);
        objectArrayList.setSizeRaw(this.rowPointers[this.rows]);
        intArrayList.remove(n2);
        objectArrayList.remove(n2);
        int n3 = this.rowPointers.length;
        while (--n3 > n) {
            int n4 = n3;
            this.rowPointers[n4] = this.rowPointers[n4] - 1;
        }
        this.columnIndexes = intArrayList.elements();
        this.values = objectArrayList.elements();
    }
}

