/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DenseLargeFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix2DTest;
import cern.colt.matrix.tfloat.impl.DenseLargeFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.WrapperFloatMatrix2D;

public class DenseLargeFloatMatrix2DTest
extends FloatMatrix2DTest {
    public DenseLargeFloatMatrix2DTest(String string) {
        super(string);
    }

    protected void createMatrices() throws Exception {
        this.A = new DenseLargeFloatMatrix2D(this.NROWS, this.NCOLUMNS);
        this.B = new DenseLargeFloatMatrix2D(this.NROWS, this.NCOLUMNS);
        this.Bt = new DenseLargeFloatMatrix2D(this.NCOLUMNS, this.NROWS);
    }

    public void testDct2() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        ((WrapperFloatMatrix2D)this.A).dct2(true);
        ((WrapperFloatMatrix2D)this.A).idct2(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DenseLargeFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testDctColumns() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        ((WrapperFloatMatrix2D)this.A).dctColumns(true);
        ((WrapperFloatMatrix2D)this.A).idctColumns(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DenseLargeFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testDctRows() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        ((WrapperFloatMatrix2D)this.A).dctRows(true);
        ((WrapperFloatMatrix2D)this.A).idctRows(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DenseLargeFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testDht2() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        ((WrapperFloatMatrix2D)this.A).dht2();
        ((WrapperFloatMatrix2D)this.A).idht2(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DenseLargeFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testDhtColumns() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        ((WrapperFloatMatrix2D)this.A).dhtColumns();
        ((WrapperFloatMatrix2D)this.A).idhtColumns(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DenseLargeFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testDhtRows() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        ((WrapperFloatMatrix2D)this.A).dhtRows();
        ((WrapperFloatMatrix2D)this.A).idhtRows(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DenseLargeFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testDst2() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        ((WrapperFloatMatrix2D)this.A).dst2(true);
        ((WrapperFloatMatrix2D)this.A).idst2(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DenseLargeFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testDstColumns() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        ((WrapperFloatMatrix2D)this.A).dstColumns(true);
        ((WrapperFloatMatrix2D)this.A).idstColumns(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DenseLargeFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testDstRows() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        ((WrapperFloatMatrix2D)this.A).dstRows(true);
        ((WrapperFloatMatrix2D)this.A).idstRows(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DenseLargeFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testFft2() {
        int n;
        int n2;
        int n3 = 64;
        int n4 = 128;
        FloatMatrix2D floatMatrix2D = new DenseLargeFloatMatrix2D(n3, n4);
        FloatMatrix2D floatMatrix2D2 = floatMatrix2D.copy();
        ((DenseLargeFloatMatrix2D)floatMatrix2D).fft2();
        ((DenseLargeFloatMatrix2D)floatMatrix2D).ifft2(true);
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                DenseLargeFloatMatrix2DTest.assertEquals((float)floatMatrix2D2.getQuick(n2, n), (float)floatMatrix2D.getQuick(n2, n), (float)this.TOL);
            }
        }
        floatMatrix2D = floatMatrix2D.viewDice();
        floatMatrix2D2 = floatMatrix2D.copy();
        ((WrapperFloatMatrix2D)floatMatrix2D).fft2();
        ((WrapperFloatMatrix2D)floatMatrix2D).ifft2(true);
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                DenseLargeFloatMatrix2DTest.assertEquals((float)floatMatrix2D2.getQuick(n2, n), (float)floatMatrix2D.getQuick(n2, n), (float)this.TOL);
            }
        }
    }

    public void testGetFft2() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        DenseLargeFComplexMatrix2D denseLargeFComplexMatrix2D = ((WrapperFloatMatrix2D)this.A).getFft2();
        denseLargeFComplexMatrix2D.ifft2(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                float[] fArray = ((FComplexMatrix2D)denseLargeFComplexMatrix2D).getQuick(i, j);
                DenseLargeFloatMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i, j), (float)fArray[0], (float)this.TOL);
                DenseLargeFloatMatrix2DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
            }
        }
    }

    public void testGetIfft2() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        DenseLargeFComplexMatrix2D denseLargeFComplexMatrix2D = ((WrapperFloatMatrix2D)this.A).getIfft2(true);
        denseLargeFComplexMatrix2D.fft2();
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                float[] fArray = ((FComplexMatrix2D)denseLargeFComplexMatrix2D).getQuick(i, j);
                DenseLargeFloatMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i, j), (float)fArray[0], (float)this.TOL);
                DenseLargeFloatMatrix2DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
            }
        }
    }

    public void testGetFftColumns() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        DenseLargeFComplexMatrix2D denseLargeFComplexMatrix2D = ((WrapperFloatMatrix2D)this.A).getFftColumns();
        denseLargeFComplexMatrix2D.ifftColumns(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                float[] fArray = ((FComplexMatrix2D)denseLargeFComplexMatrix2D).getQuick(i, j);
                DenseLargeFloatMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i, j), (float)fArray[0], (float)this.TOL);
                DenseLargeFloatMatrix2DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
            }
        }
    }

    public void testGetIfftColumns() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        DenseLargeFComplexMatrix2D denseLargeFComplexMatrix2D = ((WrapperFloatMatrix2D)this.A).getIfftColumns(true);
        denseLargeFComplexMatrix2D.fftColumns();
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                float[] fArray = ((FComplexMatrix2D)denseLargeFComplexMatrix2D).getQuick(i, j);
                DenseLargeFloatMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i, j), (float)fArray[0], (float)this.TOL);
                DenseLargeFloatMatrix2DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
            }
        }
    }

    public void testGetFftRows() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        DenseLargeFComplexMatrix2D denseLargeFComplexMatrix2D = ((WrapperFloatMatrix2D)this.A).getFftRows();
        denseLargeFComplexMatrix2D.ifftRows(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                float[] fArray = ((FComplexMatrix2D)denseLargeFComplexMatrix2D).getQuick(i, j);
                DenseLargeFloatMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i, j), (float)fArray[0], (float)this.TOL);
                DenseLargeFloatMatrix2DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
            }
        }
    }

    public void testGetIfftRows() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        DenseLargeFComplexMatrix2D denseLargeFComplexMatrix2D = ((WrapperFloatMatrix2D)this.A).getIfftRows(true);
        denseLargeFComplexMatrix2D.fftRows();
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                float[] fArray = ((FComplexMatrix2D)denseLargeFComplexMatrix2D).getQuick(i, j);
                DenseLargeFloatMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i, j), (float)fArray[0], (float)this.TOL);
                DenseLargeFloatMatrix2DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
            }
        }
    }
}

