/*
 * Decompiled with CFR 0.152.
 */
package ihm;

import com.visutools.nav.bislider.BiSlider;
import epp.EPPLab;
import epp.OrdonnerPP;
import ihm.Ihm;
import ihm.controle.ButtonTabComponent;
import ihm.controle.JDialogFichier;
import ihm.graphique.CourbeAtypique;
import ihm.graphique.CourbeIndice;
import ihm.graphique.EstimateurNoyau;
import ihm.graphique.Histogramme;
import indice.Discriminant;
import indice.Friedman;
import indice.FriedmanTukey;
import indice.Indice;
import indice.Indice4;
import indice.KurtosisMax;
import indice.KurtosisMin;
import indice.StahelDonoho;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import javalain.algorithmegenetique.ihm.composant.JButtonEA;
import javalain.algorithmegenetique.ihm.composant.JComboBoxEA;
import javalain.algorithmegenetique.ihm.composant.JLabelEAPar;
import javalain.algorithmegenetique.ihm.composant.JLabelEAPres;
import javalain.algorithmegenetique.ihm.composant.JRadioButtonEA;
import javalain.algorithmegenetique.ihm.composant.TitledBorderEA;
import javalain.math.Calcul;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import math.Matrice;
import util.FileUtils;
import util.GuiUtils;
import util.MsgUtils;
import util.StringUtils;

public class Analyse
extends JFrame {
    private Ihm frIhm;
    private JPanel jpOuest;
    private JRadioButtonEA rbHistogramme;
    private JRadioButtonEA rbEstimateur;
    private Histogramme histogramme;
    private EstimateurNoyau estimateurNoyau;
    private JLabelEAPres lblAtypiques;
    private JLabelEAPar lblSigma;
    private JSlider sliderAtypiques;
    private JButtonEA btSaveSelection;
    private JButtonEA btSaveAtypique;
    private JButtonEA btSaveGraphique;
    private JPanel jpProjection;
    private JLabelEAPres lblFichier;
    private JLabelEAPres lblNomMethode;
    private JLabelEAPres lblNomIndice;
    private JLabelEAPres lblValeurI;
    private JLabelEAPres lblNbObservations;
    private JLabelEAPar lblIndividus;
    private JLabelEAPres lblNbIndividus;
    private JLabelEAPres lblNbIterations;
    private JLabelEAPres lblNbSimulations;
    private JComboBoxEA cbListeSortie;
    private JButtonEA btAnalyse;
    private JPanel jpEst;
    private JTabbedPane ongletCourbe;
    private JPanel jpCourbeIndice;
    private JPanel jpCourbeCosinus;
    private JPanel jpCourbeAtypique;
    private GridBagLayout gb2;
    private GridBagConstraints gbc2;
    private GridBagLayout gb1;
    private GridBagConstraints gbc1;
    private GridBagLayout gb3;
    private GridBagConstraints gbc3;
    private CourbeIndice courbeIndice;
    private CourbeIndice courbeCosinus;
    private CourbeAtypique courbeAtypiques;
    private JSlider sliderNumLancement;
    private JSlider sliderNumObservation;
    private BiSlider biSlider;
    private JTabbedPane tabPaneHistogramme;
    private JTabbedPane tabPaneEstimateur;
    private String nomFicherResult;
    private String nomIndice;
    private Indice indice;
    private String fichierDonnees;
    private Matrice matrice;
    private int nbObservations;
    private int dimObservation;
    private String transformDonnees;
    private String methode;
    private int nbSimulations;
    private int nbIterations;
    private int nbIndividus;
    private double[] donnees_x;
    private double ecart_type;
    private double moyenne;
    private ArrayList<OrdonnerPP> liste = new ArrayList(100);
    private int numLancementRef;

    public Analyse(int x, int y, String fich, Ihm f) {
        this.setLocation(x, y);
        this.setResizable(false);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                EPPLab.savePrefs(Analyse.this.frIhm.getParametre(), Analyse.this.getX(), Analyse.this.getY());
                System.exit(0);
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
                Analyse.this.cbListeSortie.updateUI();
            }
        });
        this.frIhm = f;
        this.nomFicherResult = fich;
        this.histogramme = new Histogramme(6, 3, true, true, this);
        this.estimateurNoyau = new EstimateurNoyau(6, 3, true, true, this);
        this.courbeCosinus = new CourbeIndice(400, 200);
        this.courbeIndice = new CourbeIndice(400, 200);
        this.courbeAtypiques = new CourbeAtypique(400, 200);
        Container conteneur = this.getContentPane();
        conteneur.setLayout(new BoxLayout(conteneur, 0));
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.jpOuest = new JPanel();
        this.jpOuest.setLayout(new BoxLayout(this.jpOuest, 1));
        JPanel jpCde = new JPanel();
        jpCde.setLayout(gb);
        Component espace = Box.createHorizontalStrut(150);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = GuiUtils.INSETS_5500;
        gbc.anchor = 23;
        gb.setConstraints(espace, gbc);
        jpCde.add(espace);
        JLabelEAPres lblGraph = new JLabelEAPres(EPPLab.msg.getString("label.graphique"));
        gb.setConstraints(lblGraph, gbc);
        jpCde.add(lblGraph);
        ButtonGroup groupGraph = new ButtonGroup();
        this.rbHistogramme = new JRadioButtonEA(EPPLab.msg.getString("label.histogramme"));
        this.rbHistogramme.setSelected(false);
        this.rbHistogramme.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (Analyse.this.rbHistogramme.isSelected()) {
                    Analyse.this.jpProjection.remove(Analyse.this.estimateurNoyau);
                    Analyse.this.jpProjection.add((Component)Analyse.this.histogramme, 0);
                    Analyse.this.histogramme.setSelection(Analyse.this.estimateurNoyau.isSelection(), Analyse.this.estimateurNoyau.getBorneInfSelect(), Analyse.this.estimateurNoyau.getBorneSupSelect());
                    if (Analyse.this.tabPaneEstimateur.getTabCount() != Analyse.this.tabPaneHistogramme.getTabCount()) {
                        for (int i = 0; i < Analyse.this.tabPaneEstimateur.getTabCount(); ++i) {
                            while (!Analyse.this.tabPaneEstimateur.getTitleAt(i).equals(Analyse.this.tabPaneHistogramme.getTitleAt(i))) {
                                Analyse.this.tabPaneHistogramme.remove(i);
                            }
                        }
                        while (Analyse.this.tabPaneEstimateur.getTabCount() < Analyse.this.tabPaneHistogramme.getTabCount()) {
                            Analyse.this.tabPaneHistogramme.remove(Analyse.this.tabPaneEstimateur.getTabCount());
                        }
                    }
                    Analyse.this.jpEst.remove(Analyse.this.tabPaneEstimateur);
                    Analyse.this.jpEst.add(Analyse.this.tabPaneHistogramme);
                    Analyse.this.tabPaneHistogramme.setSelectedIndex(Analyse.this.tabPaneEstimateur.getSelectedIndex());
                    Analyse.this.repaint();
                    Analyse.this.pack();
                }
            }
        });
        gbc.gridy = 1;
        gbc.insets = GuiUtils.INSETS_5A00;
        gbc.gridwidth = 2;
        gb.setConstraints(this.rbHistogramme, gbc);
        jpCde.add(this.rbHistogramme);
        groupGraph.add(this.rbHistogramme);
        this.rbEstimateur = new JRadioButtonEA(EPPLab.msg.getString("label.estimateur"));
        this.rbEstimateur.setSelected(true);
        this.rbEstimateur.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (Analyse.this.rbEstimateur.isSelected()) {
                    Analyse.this.jpProjection.remove(Analyse.this.histogramme);
                    Analyse.this.jpProjection.add((Component)Analyse.this.estimateurNoyau, 0);
                    Analyse.this.estimateurNoyau.setSelection(Analyse.this.histogramme.isSelection(), Analyse.this.histogramme.getBorneInfSelect(), Analyse.this.histogramme.getBorneSupSelect());
                    if (Analyse.this.tabPaneHistogramme.getTabCount() != Analyse.this.tabPaneEstimateur.getTabCount()) {
                        for (int i = 0; i < Analyse.this.tabPaneHistogramme.getTabCount(); ++i) {
                            while (!Analyse.this.tabPaneHistogramme.getTitleAt(i).equals(Analyse.this.tabPaneEstimateur.getTitleAt(i))) {
                                Analyse.this.tabPaneEstimateur.remove(i);
                            }
                        }
                        while (Analyse.this.tabPaneHistogramme.getTabCount() < Analyse.this.tabPaneEstimateur.getTabCount()) {
                            Analyse.this.tabPaneEstimateur.remove(Analyse.this.tabPaneHistogramme.getTabCount());
                        }
                    }
                    Analyse.this.jpEst.remove(Analyse.this.tabPaneHistogramme);
                    Analyse.this.jpEst.add(Analyse.this.tabPaneEstimateur);
                    Analyse.this.tabPaneEstimateur.setSelectedIndex(Analyse.this.tabPaneHistogramme.getSelectedIndex());
                    Analyse.this.repaint();
                    Analyse.this.pack();
                }
            }
        });
        gbc.gridy = 2;
        gbc.insets = GuiUtils.INSETS_0A00;
        gb.setConstraints(this.rbEstimateur, gbc);
        jpCde.add(this.rbEstimateur);
        groupGraph.add(this.rbEstimateur);
        this.sliderAtypiques = new JSlider(0, 1, 10, 3);
        this.sliderAtypiques.setMajorTickSpacing(1);
        this.sliderAtypiques.setPaintLabels(true);
        this.sliderAtypiques.setFont(GuiUtils.FONT_PARAMETRE);
        this.sliderAtypiques.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!((JSlider)e.getSource()).getValueIsAdjusting()) {
                    long start = System.currentTimeMillis();
                    int i = Analyse.this.sliderAtypiques.getValue();
                    Analyse.this.lblAtypiques.setText(EPPLab.msg.getString("label.sigma") + " " + i + "\u03c3");
                    Analyse.this.histogramme.setValeurAtypiques(i);
                    Analyse.this.histogramme.repaint();
                    Analyse.this.estimateurNoyau.setValeurAtypiques(i);
                    Analyse.this.estimateurNoyau.repaint();
                    Analyse.this.courbeAtypiques.setValeurAtypiques(i);
                    Analyse.this.courbeAtypiques.repaint();
                    long stop = System.currentTimeMillis();
                    System.out.println("Temps : " + (stop - start));
                } else {
                    System.out.println("sliderAtypiques en cours de modification");
                }
            }
        });
        this.lblAtypiques = new JLabelEAPres(EPPLab.msg.getString("label.sigma") + " " + this.sliderAtypiques.getValue() + "\u03c3");
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.insets = GuiUtils.INSETS_5000;
        gb.setConstraints(this.lblAtypiques, gbc);
        jpCde.add(this.lblAtypiques);
        this.lblSigma = new JLabelEAPar("\u03c3 = ");
        gbc.gridy = 1;
        gbc.insets = GuiUtils.INSETS_5500;
        gb.setConstraints(this.lblSigma, gbc);
        jpCde.add(this.lblSigma);
        gbc.gridy = 2;
        gbc.gridheight = 2;
        gbc.insets = GuiUtils.INSETS_0500;
        gb.setConstraints(this.sliderAtypiques, gbc);
        jpCde.add(this.sliderAtypiques);
        JPanel jpBoutons = new JPanel(new GridLayout(4, 1, 0, 2));
        this.btSaveSelection = new JButtonEA(EPPLab.msg.getString("bt.sauvegardeSelection"));
        this.btSaveSelection.setEnabled(false);
        this.btSaveSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int cpt = 0;
                double x0 = 0.0;
                double x1 = 0.0;
                StringBuilder sb = new StringBuilder();
                if (Analyse.this.rbHistogramme.isSelected()) {
                    x0 = Calcul.min(Analyse.this.histogramme.getBorneInfSelect(), Analyse.this.histogramme.getBorneSupSelect());
                    x1 = Calcul.max(Analyse.this.histogramme.getBorneInfSelect(), Analyse.this.histogramme.getBorneSupSelect());
                } else if (Analyse.this.rbEstimateur.isSelected()) {
                    x0 = Calcul.min(Analyse.this.estimateurNoyau.getBorneInfSelect(), Analyse.this.estimateurNoyau.getBorneSupSelect());
                    x1 = Calcul.max(Analyse.this.estimateurNoyau.getBorneInfSelect(), Analyse.this.estimateurNoyau.getBorneSupSelect());
                }
                for (int i = 0; i < Analyse.this.donnees_x.length; ++i) {
                    if (!(Analyse.this.donnees_x[i] >= x0) || !(Analyse.this.donnees_x[i] <= x1)) continue;
                    for (int j = 0; j < Analyse.this.dimObservation - 1; ++j) {
                        sb.append(Analyse.this.matrice.element(i, j)).append(" ");
                    }
                    sb.append(Analyse.this.matrice.element(i, Analyse.this.dimObservation - 1)).append("\n");
                    ++cpt;
                }
                sb = new StringBuilder().append(cpt).append(" ").append(Analyse.this.dimObservation).append("\n\n").append((CharSequence)sb);
                if (cpt != 0) {
                    String nom_fich = Analyse.this.fichierDonnees.substring(0, Analyse.this.fichierDonnees.length() - 4) + "[" + GuiUtils.DECIMAL_2.format(x0).replace(",", ".") + "," + GuiUtils.DECIMAL_2.format(x1).replace(",", ".") + "].txt";
                    JDialogFichier dlg = new JDialogFichier(Analyse.this, ((Analyse)Analyse.this).frIhm.getParametre().rep_donnees, nom_fich, "Nom du fichier 's\u00e9lection'");
                    if (!"".equals(nom_fich = dlg.afficher())) {
                        FileUtils.saveStringToFich(((Analyse)Analyse.this).frIhm.getParametre().rep_donnees, nom_fich, sb);
                        ((Analyse)Analyse.this).frIhm.l_fichiers_donnees.add(nom_fich);
                    }
                }
            }
        });
        jpBoutons.add(this.btSaveSelection);
        this.btSaveAtypique = new JButtonEA(EPPLab.msg.getString("bt.sauvegardeAtypiques"));
        this.btSaveAtypique.setEnabled(true);
        this.btSaveAtypique.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringBuilder sb = new StringBuilder();
                int cpt = 0;
                double d = Analyse.this.ecart_type * (double)Analyse.this.sliderAtypiques.getValue();
                System.out.println("==");
                for (int i = 0; i < Analyse.this.donnees_x.length; ++i) {
                    if (!(Analyse.this.donnees_x[i] > Analyse.this.moyenne + d) && !(Analyse.this.donnees_x[i] < Analyse.this.moyenne - d)) continue;
                    System.out.println("i : " + i);
                    for (int j = 0; j < Analyse.this.dimObservation - 1; ++j) {
                        sb.append(Analyse.this.matrice.element(i, j)).append(" ");
                    }
                    sb.append(Analyse.this.matrice.element(i, Analyse.this.dimObservation - 1)).append("\n");
                    ++cpt;
                }
                sb = new StringBuilder().append(cpt).append(" ").append(Analyse.this.dimObservation).append("\n\n").append((CharSequence)sb);
                if (cpt != 0) {
                    String nom_fich = Analyse.this.fichierDonnees.substring(0, Analyse.this.fichierDonnees.length() - 4) + "_outliers-" + Analyse.this.sliderAtypiques.getValue() + "s.txt";
                    JDialogFichier dlg = new JDialogFichier(Analyse.this, ((Analyse)Analyse.this).frIhm.getParametre().rep_donnees, nom_fich, "Nom du fichier 'atypique'");
                    if (!"".equals(nom_fich = dlg.afficher())) {
                        FileUtils.saveStringToFich(((Analyse)Analyse.this).frIhm.getParametre().rep_donnees, nom_fich, sb);
                        ((Analyse)Analyse.this).frIhm.l_fichiers_donnees.add(nom_fich);
                    }
                }
            }
        });
        jpBoutons.add(this.btSaveAtypique);
        this.btSaveGraphique = new JButtonEA(EPPLab.msg.getString("bt.sauvegardeGraphique"));
        this.btSaveGraphique.setEnabled(true);
        this.btSaveGraphique.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = "";
                if (Analyse.this.rbHistogramme.isSelected()) {
                    s = "_histogramme_";
                } else if (Analyse.this.rbEstimateur.isSelected()) {
                    s = "_estimateur_";
                }
                String nom_fich = FileUtils.creeNomFichierJpg(((Analyse)Analyse.this).frIhm.getParametre().rep_graph, Analyse.this.fichierDonnees.substring(0, Analyse.this.fichierDonnees.length() - 4) + s);
                JDialogFichier dlg = new JDialogFichier(Analyse.this, ((Analyse)Analyse.this).frIhm.getParametre().rep_graph, nom_fich, "Nom du fichier 'image'");
                nom_fich = dlg.afficher();
                try {
                    if (!"".equals(nom_fich)) {
                        if (Analyse.this.rbHistogramme.isSelected()) {
                            FileUtils.saveJPanelToFile(Analyse.this.histogramme, new File(((Analyse)Analyse.this).frIhm.getParametre().rep_graph + File.separatorChar + nom_fich));
                        } else if (Analyse.this.rbEstimateur.isSelected()) {
                            FileUtils.saveJPanelToFile(Analyse.this.estimateurNoyau, new File(((Analyse)Analyse.this).frIhm.getParametre().rep_graph + File.separatorChar + nom_fich));
                        }
                    }
                }
                catch (IOException ioe) {
                    MsgUtils.erreur(Analyse.this, EPPLab.msg.getString("showOptionDialog.erreurCopie") + nom_fich, EPPLab.msg.getString("showOptionDialog.erreur"));
                }
            }
        });
        jpBoutons.add(this.btSaveGraphique);
        this.sliderNumObservation = new JSlider(0);
        this.sliderNumObservation.setOpaque(true);
        this.sliderNumObservation.setPaintTrack(true);
        this.sliderNumObservation.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!((JSlider)e.getSource()).getValueIsAdjusting()) {
                    long start = System.currentTimeMillis();
                    Analyse.this.courbeAtypiques.setIndiceObsSelect(Analyse.this.sliderNumObservation.getValue() - 1);
                    if (Analyse.this.ongletCourbe.getSelectedIndex() == 2) {
                        Analyse.this.courbeAtypiques.repaint();
                    }
                    long stop = System.currentTimeMillis();
                    System.out.println("Temps : " + (stop - start));
                } else {
                    System.out.println("sliderNumObservation en cours de modification");
                }
            }
        });
        jpBoutons.add(this.sliderNumObservation);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 3;
        gbc.insets = GuiUtils.INSETS_5000;
        gbc.anchor = 24;
        gbc.weightx = 1.0;
        gb.setConstraints(jpBoutons, gbc);
        jpCde.add(jpBoutons);
        JButtonEA btAide = new JButtonEA(new ImageIcon(this.getClass().getResource("icone/help.gif")));
        btAide.setToolTipText(EPPLab.msg.getString("menu.aide"));
        btAide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(EPPLab.msg.getString("menu.aide"));
            }
        });
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridheight = 1;
        gbc.insets = GuiUtils.INSETS_5500;
        gbc.anchor = 23;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gb.setConstraints(btAide, gbc);
        jpCde.add(btAide);
        JPanel jpNav = new JPanel();
        jpNav.setLayout(new BorderLayout(5, 0));
        JButtonEA btRetour = new JButtonEA(EPPLab.msg.getString("menu.retour"));
        btRetour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Analyse.this.setVisible(false);
                if (((Analyse)Analyse.this).frIhm.frRecherche != null) {
                    ((Analyse)Analyse.this).frIhm.frRecherche.setVisible(true);
                } else {
                    Analyse.this.frIhm.setVisible(true);
                }
            }
        });
        jpNav.add((Component)btRetour, "West");
        this.cbListeSortie = new JComboBoxEA(this.frIhm.l_fichiers_sortie);
        this.cbListeSortie.setMaximumSize(new Dimension(350, 23));
        this.cbListeSortie.setPreferredSize(new Dimension(350, 23));
        this.cbListeSortie.setSelectedIndex(0);
        this.cbListeSortie.setEnabled(true);
        this.cbListeSortie.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Analyse.this.cbListeSortie.getSelectedItem().equals(EPPLab.msg.getString("cb.listeSortie")) || Analyse.this.cbListeSortie.getSelectedItem().equals(Analyse.this.nomFicherResult)) {
                    Analyse.this.btAnalyse.setEnabled(false);
                } else {
                    Analyse.this.btAnalyse.setEnabled(true);
                }
            }
        });
        jpNav.add((Component)this.cbListeSortie, "Center");
        this.btAnalyse = new JButtonEA(EPPLab.msg.getString("bt.analyse"));
        this.btAnalyse.setEnabled(false);
        this.btAnalyse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Analyse.this.initialise((String)Analyse.this.cbListeSortie.getSelectedItem());
            }
        });
        jpNav.add((Component)this.btAnalyse, "East");
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.insets = GuiUtils.INSETS_5000;
        gbc.anchor = 24;
        gb.setConstraints(jpNav, gbc);
        jpCde.add(jpNav);
        this.jpOuest.add(jpCde);
        this.jpOuest.add(Box.createVerticalStrut(19));
        JPanel jpInfo = new JPanel();
        jpInfo.setBorder(new TitledBorderEA(EPPLab.msg.getString("tb.info")));
        gb = new GridBagLayout();
        gbc = new GridBagConstraints();
        jpInfo.setLayout(gb);
        JLabelEAPar jl = new JLabelEAPar(EPPLab.msg.getString("label.Fdonnees"));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = GuiUtils.INSETS_5A00;
        gbc.anchor = 23;
        gb.setConstraints(jl, gbc);
        jpInfo.add(jl);
        this.lblFichier = new JLabelEAPres(this.fichierDonnees);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 20, 0, 0);
        gb.setConstraints(this.lblFichier, gbc);
        jpInfo.add(this.lblFichier);
        jl = new JLabelEAPar(EPPLab.msg.getString("label.nbObs"));
        gbc.gridx = 2;
        gbc.gridy = 0;
        gb.setConstraints(jl, gbc);
        jpInfo.add(jl);
        this.lblNbObservations = new JLabelEAPres("n=" + this.nbObservations + " p=" + this.dimObservation);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gb.setConstraints(this.lblNbObservations, gbc);
        jpInfo.add(this.lblNbObservations);
        jl = new JLabelEAPar(EPPLab.msg.getString("label.methode"));
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = GuiUtils.INSETS_5A00;
        gb.setConstraints(jl, gbc);
        jpInfo.add(jl);
        this.lblNomMethode = new JLabelEAPres(this.methode);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 20, 0, 0);
        gb.setConstraints(this.lblNomMethode, gbc);
        jpInfo.add(this.lblNomMethode);
        this.lblIndividus = new JLabelEAPar("");
        gbc.gridx = 2;
        gbc.gridy = 1;
        gb.setConstraints(this.lblIndividus, gbc);
        jpInfo.add(this.lblIndividus);
        this.lblNbIndividus = new JLabelEAPres("" + this.nbIndividus);
        gbc.gridx = 3;
        gbc.gridy = 1;
        gb.setConstraints(this.lblNbIndividus, gbc);
        jpInfo.add(this.lblNbIndividus);
        jl = new JLabelEAPar(EPPLab.msg.getString("label.indice"));
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = GuiUtils.INSETS_5A00;
        gb.setConstraints(jl, gbc);
        jpInfo.add(jl);
        this.lblNomIndice = new JLabelEAPres(this.nomIndice);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 20, 0, 0);
        gb.setConstraints(this.lblNomIndice, gbc);
        jpInfo.add(this.lblNomIndice);
        jl = new JLabelEAPar(EPPLab.msg.getString("label.iteration"));
        gbc.gridx = 2;
        gbc.gridy = 2;
        gb.setConstraints(jl, gbc);
        jpInfo.add(jl);
        this.lblNbIterations = new JLabelEAPres("" + this.nbIterations);
        gbc.gridx = 3;
        gbc.gridy = 2;
        gb.setConstraints(this.lblNbIterations, gbc);
        jpInfo.add(this.lblNbIterations);
        jl = new JLabelEAPar(EPPLab.msg.getString("label.valeurIndice"));
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 0.0;
        gbc.insets = GuiUtils.INSETS_5A00;
        gb.setConstraints(jl, gbc);
        jpInfo.add(jl);
        this.lblValeurI = new JLabelEAPres("");
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 20, 10, 0);
        gb.setConstraints(this.lblValeurI, gbc);
        jpInfo.add(this.lblValeurI);
        jl = new JLabelEAPar(EPPLab.msg.getString("label.simulation"));
        gbc.gridx = 2;
        gbc.gridy = 3;
        gb.setConstraints(jl, gbc);
        jpInfo.add(jl);
        this.lblNbSimulations = new JLabelEAPres("" + this.nbSimulations);
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gb.setConstraints(this.lblNbSimulations, gbc);
        jpInfo.add(this.lblNbSimulations);
        this.jpOuest.add(jpInfo);
        this.jpProjection = new JPanel(GuiUtils.FL_LEFT_00);
        this.jpProjection.add(this.estimateurNoyau);
        JButtonEA btAjoutOnglet = new JButtonEA(new ImageIcon(this.getClass().getResource("icone/forward.gif")));
        btAjoutOnglet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String select;
                int i;
                int num = Analyse.this.sliderNumLancement.getValue();
                boolean ajoute = true;
                if (num == 1) {
                    ajoute = false;
                } else if (Analyse.this.rbHistogramme.isSelected()) {
                    for (i = 1; i < Analyse.this.tabPaneHistogramme.getTabCount(); ++i) {
                        select = Analyse.this.tabPaneHistogramme.getTitleAt(i);
                        if (num != Integer.parseInt(select = select.replace("n\u00b0 ", ""))) continue;
                        ajoute = false;
                    }
                } else {
                    for (i = 1; i < Analyse.this.tabPaneEstimateur.getTabCount(); ++i) {
                        select = Analyse.this.tabPaneEstimateur.getTitleAt(i);
                        if (num != Integer.parseInt(select = select.replace("n\u00b0 ", ""))) continue;
                        ajoute = false;
                    }
                }
                if (ajoute) {
                    Histogramme histo = new Histogramme(4, 2, false, false, Analyse.this);
                    histo.setFichierDonnees(Analyse.this.fichierDonnees);
                    histo.setProjection(Analyse.this.donnees_x);
                    Analyse.this.tabPaneHistogramme.add("n\u00b0 " + num, histo);
                    Analyse.this.tabPaneHistogramme.setTabComponentAt(Analyse.this.tabPaneHistogramme.getTabCount() - 1, new ButtonTabComponent(Analyse.this.tabPaneHistogramme));
                    EstimateurNoyau estim = new EstimateurNoyau(4, 2, false, false, null);
                    estim.setProjection(Analyse.this.donnees_x);
                    Analyse.this.tabPaneEstimateur.add("n\u00b0 " + num, estim);
                    Analyse.this.tabPaneEstimateur.setTabComponentAt(Analyse.this.tabPaneEstimateur.getTabCount() - 1, new ButtonTabComponent(Analyse.this.tabPaneEstimateur));
                    Analyse.this.pack();
                }
            }
        });
        JButtonEA btRef = new JButtonEA(new ImageIcon(this.getClass().getResource("icone/back.gif")));
        btRef.setEnabled(false);
        btRef.setVisible(false);
        btRef.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("R\u00e9f\u00e9rence");
            }
        });
        JPanel jp0 = new JPanel();
        jp0.setLayout(new BoxLayout(jp0, 1));
        jp0.add(btAjoutOnglet);
        jp0.add(Box.createVerticalStrut(3));
        jp0.add(btRef);
        this.jpProjection.add(jp0);
        this.jpOuest.add(this.jpProjection);
        conteneur.add((Component)this.jpOuest, "West");
        conteneur.add(Box.createHorizontalStrut(5));
        this.jpEst = new JPanel();
        this.jpEst.setLayout(new BoxLayout(this.jpEst, 1));
        final Insets marge_slider = new Insets(0, this.courbeIndice.getMargeGauche() - 7, 0, this.courbeIndice.getMargeDroite() - 7);
        this.sliderNumLancement = new JSlider(0);
        this.sliderNumLancement.setOpaque(false);
        this.sliderNumLancement.setPaintTrack(true);
        this.sliderNumLancement.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!((JSlider)e.getSource()).getValueIsAdjusting()) {
                    long start = System.currentTimeMillis();
                    int i = Analyse.this.sliderNumLancement.getValue() - 1;
                    Analyse.this.courbeIndice.setIndiceRunSelect(i);
                    Analyse.this.courbeCosinus.setIndiceRunSelect(i);
                    Analyse.this.courbeAtypiques.setIndiceRunSelect(i);
                    if (Analyse.this.ongletCourbe.getSelectedIndex() == 0) {
                        Analyse.this.courbeIndice.repaint();
                    }
                    if (Analyse.this.ongletCourbe.getSelectedIndex() == 1) {
                        Analyse.this.courbeCosinus.repaint();
                    }
                    if (Analyse.this.ongletCourbe.getSelectedIndex() == 2) {
                        Analyse.this.courbeAtypiques.repaint();
                    }
                    Analyse.this.lblValeurI.setText(GuiUtils.DECIMAL_9.format(((OrdonnerPP)Analyse.this.liste.get(i)).getI()));
                    for (int j = 0; j < Analyse.this.indice.getMatrice().nbLigne(); ++j) {
                        ((Analyse)Analyse.this).donnees_x[j] = Calcul.produitScalaireVecteur(Analyse.this.indice.getMatrice().ligne(j), ((OrdonnerPP)Analyse.this.liste.get(i)).getA());
                    }
                    Analyse.this.ecart_type = Calcul.ecartType(Analyse.this.donnees_x);
                    Analyse.this.histogramme.setProjection(Analyse.this.donnees_x);
                    Analyse.this.estimateurNoyau.setProjection(Analyse.this.donnees_x);
                    if (Analyse.this.rbHistogramme.isSelected()) {
                        Analyse.this.histogramme.repaint();
                    }
                    if (Analyse.this.rbEstimateur.isSelected()) {
                        Analyse.this.estimateurNoyau.repaint();
                    }
                    long stop = System.currentTimeMillis();
                    System.out.println("Temps : " + (stop - start));
                } else {
                    System.out.println("sliderNumLancement en cours de modification");
                }
            }
        });
        this.gb3 = new GridBagLayout();
        this.gbc3 = new GridBagConstraints();
        this.jpCourbeAtypique = new JPanel(this.gb3);
        this.jpCourbeAtypique.setBackground(GuiUtils.blanc);
        this.gbc3.gridx = 0;
        this.gbc3.gridy = 0;
        this.gbc3.anchor = 23;
        this.gb3.setConstraints(this.courbeAtypiques, this.gbc3);
        this.jpCourbeAtypique.add(this.courbeAtypiques);
        this.gbc3.gridx = 0;
        this.gbc3.gridy = 1;
        this.gbc3.insets = marge_slider;
        this.gbc3.fill = 2;
        this.gb3.setConstraints(this.sliderNumLancement, this.gbc3);
        this.jpCourbeAtypique.add(this.sliderNumLancement);
        JLabelEAPres lbl_axe2 = new JLabelEAPres(EPPLab.msg.getString("label.axeLancements"));
        lbl_axe2.setHorizontalAlignment(0);
        this.gbc3.gridx = 0;
        this.gbc3.gridy = 2;
        this.gbc3.insets = new Insets(0, 0, 5, 0);
        this.gb3.setConstraints(lbl_axe2, this.gbc3);
        this.jpCourbeAtypique.add(lbl_axe2);
        this.gb2 = new GridBagLayout();
        this.gbc2 = new GridBagConstraints();
        this.jpCourbeCosinus = new JPanel(this.gb2);
        this.jpCourbeCosinus.setBackground(GuiUtils.blanc);
        this.gbc2.gridx = 0;
        this.gbc2.gridy = 0;
        this.gbc2.anchor = 23;
        this.gb2.setConstraints(this.courbeCosinus, this.gbc2);
        this.jpCourbeCosinus.add(this.courbeCosinus);
        this.gbc2.gridx = 0;
        this.gbc2.gridy = 1;
        this.gbc2.insets = marge_slider;
        this.gbc2.fill = 2;
        this.gb2.setConstraints(this.sliderNumLancement, this.gbc2);
        this.jpCourbeCosinus.add(this.sliderNumLancement);
        JLabelEAPres lbl_axe = new JLabelEAPres(EPPLab.msg.getString("label.axeLancements"));
        lbl_axe.setHorizontalAlignment(0);
        this.gbc2.gridx = 0;
        this.gbc2.gridy = 2;
        this.gbc2.insets = new Insets(0, 0, 5, 0);
        this.gb2.setConstraints(lbl_axe, this.gbc2);
        this.jpCourbeCosinus.add(lbl_axe);
        this.gb1 = new GridBagLayout();
        this.gbc1 = new GridBagConstraints();
        this.jpCourbeIndice = new JPanel(this.gb1);
        this.jpCourbeIndice.setBackground(Color.WHITE);
        this.gbc1.gridx = 0;
        this.gbc1.gridy = 0;
        this.gbc1.anchor = 23;
        this.gb1.setConstraints(this.courbeIndice, this.gbc1);
        this.jpCourbeIndice.add(this.courbeIndice);
        this.gbc1.gridx = 0;
        this.gbc1.gridy = 1;
        this.gbc1.insets = marge_slider;
        this.gbc1.fill = 2;
        this.gb1.setConstraints(this.sliderNumLancement, this.gbc1);
        this.jpCourbeIndice.add(this.sliderNumLancement);
        JLabelEAPres lbl_axe1 = new JLabelEAPres(EPPLab.msg.getString("label.axeLancements"));
        lbl_axe1.setHorizontalAlignment(0);
        this.gbc1.gridx = 0;
        this.gbc1.gridy = 2;
        this.gbc1.insets = new Insets(0, 0, 5, 0);
        this.gb1.setConstraints(lbl_axe1, this.gbc1);
        this.jpCourbeIndice.add(lbl_axe1);
        this.ongletCourbe = new JTabbedPane();
        this.ongletCourbe.addTab(EPPLab.msg.getString("tab.indice"), this.jpCourbeIndice);
        this.ongletCourbe.addTab(EPPLab.msg.getString("tab.cosinus"), this.jpCourbeCosinus);
        this.ongletCourbe.addTab(EPPLab.msg.getString("tab.atypiques"), this.jpCourbeAtypique);
        this.ongletCourbe.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (((JTabbedPane)e.getSource()).getSelectedIndex() == 0) {
                    ((Analyse)Analyse.this).gbc1.gridx = 0;
                    ((Analyse)Analyse.this).gbc1.gridy = 1;
                    ((Analyse)Analyse.this).gbc1.insets = marge_slider;
                    ((Analyse)Analyse.this).gbc1.fill = 2;
                    Analyse.this.gb1.setConstraints(Analyse.this.sliderNumLancement, Analyse.this.gbc1);
                    Analyse.this.jpCourbeIndice.add(Analyse.this.sliderNumLancement);
                } else if (((JTabbedPane)e.getSource()).getSelectedIndex() == 1) {
                    ((Analyse)Analyse.this).gbc2.gridx = 0;
                    ((Analyse)Analyse.this).gbc2.gridy = 1;
                    ((Analyse)Analyse.this).gbc2.insets = marge_slider;
                    ((Analyse)Analyse.this).gbc2.fill = 2;
                    Analyse.this.gb2.setConstraints(Analyse.this.sliderNumLancement, Analyse.this.gbc2);
                    Analyse.this.jpCourbeCosinus.add(Analyse.this.sliderNumLancement);
                } else {
                    ((Analyse)Analyse.this).gbc3.gridx = 0;
                    ((Analyse)Analyse.this).gbc3.gridy = 1;
                    ((Analyse)Analyse.this).gbc3.insets = marge_slider;
                    ((Analyse)Analyse.this).gbc3.fill = 2;
                    Analyse.this.gb3.setConstraints(Analyse.this.sliderNumLancement, Analyse.this.gbc3);
                    Analyse.this.jpCourbeAtypique.add(Analyse.this.sliderNumLancement);
                }
            }
        });
        this.jpEst.add(this.ongletCourbe);
        JPanel jpZoom = new JPanel(new BorderLayout(0, 0));
        jpZoom.setBorder(new TitledBorderEA(EPPLab.msg.getString("slider.zoom")));
        this.biSlider = new BiSlider("RGB");
        this.biSlider.setMinimumColor(GuiUtils.GRIS_238);
        this.biSlider.setMaximumColor(GuiUtils.GRIS_238);
        this.biSlider.setArcSize(5);
        this.biSlider.setPreferredSize(new Dimension(100, 30));
        this.biSlider.setMinimumSize(new Dimension(100, 30));
        this.biSlider.setFont(GuiUtils.FONT_PARAMETRE);
        this.biSlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent MouseEvent_Arg) {
                Analyse.this.courbeIndice.setIndiceMinimum(Analyse.this.biSlider.getMinimumColoredValue() - 1);
                Analyse.this.courbeIndice.setIndiceMaximum(Analyse.this.biSlider.getMaximumColoredValue() - 1);
                Analyse.this.courbeCosinus.setIndiceMinimum(Analyse.this.biSlider.getMinimumColoredValue() - 1);
                Analyse.this.courbeCosinus.setIndiceMaximum(Analyse.this.biSlider.getMaximumColoredValue() - 1);
                Analyse.this.courbeAtypiques.setIndiceMinimum(Analyse.this.biSlider.getMinimumColoredValue() - 1);
                Analyse.this.courbeAtypiques.setIndiceMaximum(Analyse.this.biSlider.getMaximumColoredValue() - 1);
                Analyse.this.sliderNumLancement.setMinimum(Analyse.this.biSlider.getMinimumColoredValue());
                Analyse.this.sliderNumLancement.setMaximum(Analyse.this.biSlider.getMaximumColoredValue());
                System.out.println(Analyse.this);
            }
        });
        jpZoom.add((Component)this.biSlider, "Center");
        this.jpEst.add(jpZoom);
        this.jpEst.add(Box.createVerticalStrut(26));
        this.tabPaneHistogramme = new JTabbedPane(1, 1);
        this.tabPaneHistogramme.add(EPPLab.msg.getString("tab.optimum"), null);
        this.tabPaneHistogramme.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                String select = Analyse.this.tabPaneHistogramme.getTitleAt(Analyse.this.tabPaneHistogramme.getSelectedIndex());
                if (select.equals(EPPLab.msg.getString("tab.optimum"))) {
                    Analyse.this.numLancementRef = 0;
                } else {
                    select = select.replace("n\u00b0 ", "");
                    Analyse.this.numLancementRef = Integer.parseInt(select) - 1;
                }
                Analyse.this.courbeCosinus.setIndiceReference(Analyse.this.numLancementRef);
                Analyse.this.courbeIndice.setIndiceReference(Analyse.this.numLancementRef);
                Analyse.this.courbeAtypiques.setIndiceReference(Analyse.this.numLancementRef);
                double[] proj = ((OrdonnerPP)Analyse.this.liste.get(Analyse.this.numLancementRef)).getA();
                Analyse.this.courbeCosinus.raz();
                for (int i = 0; i < Analyse.this.liste.size(); ++i) {
                    Analyse.this.courbeCosinus.addNombre((float)Calcul.cosinus(proj, ((OrdonnerPP)Analyse.this.liste.get(i)).getA()));
                }
                Analyse.this.courbeCosinus.repaint();
                Analyse.this.courbeIndice.repaint();
                Analyse.this.courbeAtypiques.repaint();
            }
        });
        this.tabPaneEstimateur = new JTabbedPane(1, 1);
        this.tabPaneEstimateur.add(EPPLab.msg.getString("tab.optimum"), null);
        this.tabPaneEstimateur.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                String select = Analyse.this.tabPaneEstimateur.getTitleAt(Analyse.this.tabPaneEstimateur.getSelectedIndex());
                if (select.equals(EPPLab.msg.getString("tab.optimum"))) {
                    Analyse.this.numLancementRef = 0;
                } else {
                    select = select.replace("n\u00b0 ", "");
                    Analyse.this.numLancementRef = Integer.parseInt(select) - 1;
                }
                Analyse.this.courbeCosinus.setIndiceReference(Analyse.this.numLancementRef);
                Analyse.this.courbeIndice.setIndiceReference(Analyse.this.numLancementRef);
                Analyse.this.courbeAtypiques.setIndiceReference(Analyse.this.numLancementRef);
                double[] proj = ((OrdonnerPP)Analyse.this.liste.get(Analyse.this.numLancementRef)).getA();
                Analyse.this.courbeCosinus.raz();
                for (int i = 0; i < Analyse.this.liste.size(); ++i) {
                    Analyse.this.courbeCosinus.addNombre((float)Calcul.cosinus(proj, ((OrdonnerPP)Analyse.this.liste.get(i)).getA()));
                }
                Analyse.this.courbeCosinus.repaint();
                Analyse.this.courbeIndice.repaint();
                Analyse.this.courbeAtypiques.repaint();
            }
        });
        this.jpEst.add(this.tabPaneEstimateur);
        conteneur.add((Component)this.jpEst, "East");
    }

    public void setEnabledSaveSelection(boolean b) {
        this.btSaveSelection.setEnabled(b);
    }

    public Ihm getIhm() {
        return this.frIhm;
    }

    public void initialise(String fich) {
        int i;
        this.setTitle(EPPLab.msg.getString("tb.analyse") + " '" + fich + "'");
        this.nomFicherResult = fich;
        String filePath = this.frIhm.getParametre().rep_sortie + File.separatorChar + this.nomFicherResult;
        this.majCompatible(this.frIhm.getParametre().rep_sortie, this.nomFicherResult);
        double[][] A = null;
        float[] tab_I = null;
        try {
            FileReader fichier = new FileReader(filePath);
            BufferedReader buffer = new BufferedReader(fichier);
            buffer.readLine();
            String ch = buffer.readLine();
            StringTokenizer st = new StringTokenizer(ch);
            st.nextToken();
            this.fichierDonnees = st.nextToken();
            this.matrice = new Matrice(this.frIhm.getParametre().rep_donnees + File.separatorChar + this.fichierDonnees);
            ch = buffer.readLine();
            st = new StringTokenizer(ch);
            st.nextToken();
            this.nbObservations = Integer.parseInt(st.nextToken());
            this.dimObservation = Integer.parseInt(st.nextToken());
            ch = buffer.readLine();
            st = new StringTokenizer(ch);
            st.nextToken();
            this.transformDonnees = st.nextToken();
            Matrice mat = null;
            if (this.transformDonnees.equals("Spherique")) {
                mat = this.fichierDonnees.equals("fiab_880.txt") ? new Matrice(this.frIhm.getParametre().rep_donnees + File.separatorChar + "fiab_880_sphere.txt") : (this.fichierDonnees.equals("geno_transpose.txt") ? new Matrice(this.frIhm.getParametre().rep_donnees + File.separatorChar + "geno_transpose_sph.txt") : this.matrice.spherique());
            } else if (this.transformDonnees.equals("Centree_reduite")) {
                mat = this.matrice.centreReduite();
            }
            ch = buffer.readLine();
            st = new StringTokenizer(ch);
            st.nextToken();
            this.nomIndice = st.nextToken();
            if (this.nomIndice.equals("KurtosisMax")) {
                this.indice = new KurtosisMax(mat);
            } else if (this.nomIndice.equals("KurtosisMin")) {
                this.indice = new KurtosisMin(mat);
            } else if (this.nomIndice.equals("Friedman")) {
                this.indice = new Friedman(mat);
            } else if (this.nomIndice.equals("FriedmanTukey")) {
                this.indice = new FriedmanTukey(mat);
            } else if (this.nomIndice.equals("Discriminant")) {
                this.indice = new Discriminant(mat);
            } else if (this.nomIndice.equals("Indice4")) {
                this.indice = new Indice4(mat);
            } else if (this.nomIndice.equals("StahelDonoho")) {
                this.indice = new StahelDonoho(mat);
            }
            buffer.readLine();
            buffer.readLine();
            buffer.readLine();
            buffer.readLine();
            ch = buffer.readLine();
            st = new StringTokenizer(ch);
            st.nextToken();
            this.methode = "";
            while (st.hasMoreElements()) {
                this.methode = this.methode + st.nextToken() + " ";
            }
            this.methode = this.methode.substring(0, this.methode.length() - 1);
            ch = buffer.readLine();
            st = new StringTokenizer(ch);
            st.nextToken();
            this.nbIterations = Integer.parseInt(st.nextToken());
            ch = buffer.readLine();
            st = new StringTokenizer(ch);
            st.nextToken();
            ch = st.nextToken();
            if (!ch.equals("?")) {
                this.nbIndividus = Integer.parseInt(ch);
            }
            while (!(ch = buffer.readLine()).startsWith("<Nombre_de_simulations>")) {
            }
            st = new StringTokenizer(ch);
            st.nextToken();
            this.nbSimulations = Integer.parseInt(st.nextToken());
            A = new double[this.nbSimulations][this.dimObservation];
            for (int i2 = 0; i2 < this.nbSimulations; ++i2) {
                int j;
                while (!(ch = buffer.readLine()).startsWith("<A>")) {
                }
                ch = ch.replace(",", ".");
                st = new StringTokenizer(ch);
                st.nextToken();
                for (j = 0; j < this.dimObservation; ++j) {
                    A[i2][j] = Double.parseDouble(st.nextToken());
                }
                if (!(A[i2][0] < 0.0)) continue;
                for (j = 0; j < this.dimObservation; ++j) {
                    A[i2][j] = -A[i2][j];
                }
            }
            while (!(ch = buffer.readLine()).equals("<Les_I>")) {
            }
            StringBuilder sb = new StringBuilder();
            ch = buffer.readLine();
            while (!ch.equals("</Les_I>")) {
                sb.append(ch).append(" ");
                ch = buffer.readLine();
            }
            sb.deleteCharAt(sb.length() - 1);
            StringUtils.replaceAll(sb, ",", ".");
            String[] tab_string = sb.toString().split(" ");
            tab_I = new float[tab_string.length];
            for (int i3 = 0; i3 < this.nbSimulations; ++i3) {
                tab_I[i3] = Float.parseFloat(tab_string[i3]);
            }
            buffer.close();
            fichier.close();
        }
        catch (Exception e) {
            MsgUtils.erreurAndExit(this, "Probl\u00e8me lors de la lecture du fichier '" + filePath + "'. " + e.getMessage(), "Visualisation");
        }
        this.liste.clear();
        for (i = 0; i < tab_I.length; ++i) {
            this.liste.add(new OrdonnerPP(i, (double)tab_I[i], A[i]));
        }
        Collections.sort(this.liste);
        this.donnees_x = new double[this.nbObservations];
        for (i = 0; i < this.indice.getMatrice().nbLigne(); ++i) {
            this.donnees_x[i] = Calcul.produitScalaireVecteur(this.indice.getMatrice().ligne(i), this.liste.get(0).getA());
        }
        this.ecart_type = Calcul.ecartType(this.donnees_x);
        this.moyenne = Calcul.moyenne(this.donnees_x);
        this.histogramme.setFichierDonnees(this.fichierDonnees);
        this.histogramme.setProjection(this.donnees_x);
        this.histogramme.setValeurAtypiques(this.sliderAtypiques.getValue());
        this.histogramme.setInfos(this.nomIndice, this.methode);
        this.estimateurNoyau.setProjection(this.donnees_x);
        this.estimateurNoyau.setValeurAtypiques(this.sliderAtypiques.getValue());
        if (this.rbHistogramme.isSelected()) {
            this.histogramme.repaint();
        }
        if (this.rbEstimateur.isSelected()) {
            this.estimateurNoyau.repaint();
        }
        this.courbeIndice.raz();
        this.courbeIndice.setInfos(this.fichierDonnees, this.nomIndice, this.methode);
        for (i = 0; i < this.liste.size(); ++i) {
            this.courbeIndice.addNombre((float)this.liste.get(i).getI());
        }
        this.courbeIndice.repaint();
        this.numLancementRef = 0;
        double[] proj = this.liste.get(this.numLancementRef).getA();
        this.courbeCosinus.raz();
        this.courbeCosinus.setInfos(this.fichierDonnees, this.nomIndice, this.methode);
        for (int i4 = 0; i4 < this.liste.size(); ++i4) {
            this.courbeCosinus.addNombre((float)Calcul.cosinus(proj, this.liste.get(i4).getA()));
        }
        this.courbeCosinus.repaint();
        this.courbeAtypiques.raz();
        this.courbeAtypiques.setIndProjAndListeSimu(this.indice, this.liste);
        this.courbeAtypiques.setValeurAtypiques(this.sliderAtypiques.getValue());
        this.courbeAtypiques.repaint();
        this.biSlider.setMinimumValue(1);
        this.biSlider.setMaximumValue(this.liste.size());
        this.biSlider.setMinimumColoredValue(1);
        this.biSlider.setMaximumColoredValue(this.liste.size());
        this.biSlider.setSegmentSize(-1.0);
        this.sliderNumLancement.setValue(1);
        this.sliderNumLancement.setMinimum(1);
        this.sliderNumLancement.setMaximum(this.liste.size());
        this.lblSigma.setText("m = " + GuiUtils.DECIMAL_3.format(this.moyenne) + "   \u03c3 = " + GuiUtils.DECIMAL_3.format(this.ecart_type));
        this.sliderNumObservation.setValue(1);
        this.sliderNumObservation.setMinimum(1);
        this.sliderNumObservation.setMaximum(this.indice.getMatrice().nbLigne());
        this.tabPaneHistogramme.setSelectedIndex(0);
        this.tabPaneEstimateur.setSelectedIndex(0);
        while (this.tabPaneHistogramme.getTabCount() != 1) {
            this.tabPaneHistogramme.remove(1);
            this.tabPaneEstimateur.remove(1);
        }
        Histogramme histo = new Histogramme(4, 2, false, false, this);
        histo.setFichierDonnees(this.fichierDonnees);
        histo.setProjection(this.donnees_x);
        this.tabPaneHistogramme.setComponentAt(0, histo);
        EstimateurNoyau estim = new EstimateurNoyau(4, 2, false, false, null);
        estim.setProjection(this.donnees_x);
        this.tabPaneEstimateur.setComponentAt(0, estim);
        this.lblFichier.setText(this.fichierDonnees);
        this.lblNomIndice.setText(this.nomIndice);
        this.lblNomMethode.setText(this.methode);
        this.lblValeurI.setText(GuiUtils.DECIMAL_9.format(this.liste.get(0).getI()));
        if (this.methode.equals("Particule Swarm Optimization")) {
            this.lblIndividus.setText(EPPLab.msg.getString("label.particule"));
        } else {
            this.lblIndividus.setText(EPPLab.msg.getString("label.individu"));
        }
        this.lblNbObservations.setText("n=" + this.nbObservations + " p=" + this.dimObservation);
        this.lblNbIndividus.setText("" + this.nbIndividus);
        this.lblNbIterations.setText("" + this.nbIterations);
        this.lblNbSimulations.setText("" + this.nbSimulations);
        this.cbListeSortie.setSelectedItem(fich);
        this.pack();
    }

    public void majCompatible(String path, String file) {
        StringBuilder sb = new StringBuilder();
        try {
            String ch;
            FileReader fichier = new FileReader(path + File.separatorChar + file);
            BufferedReader buffer = new BufferedReader(fichier);
            do {
                ch = buffer.readLine();
                sb.append(ch).append('\n');
            } while (!ch.startsWith("<Dimension_matrice>"));
            ch = buffer.readLine();
            if (!ch.startsWith("<Transformation_donnees>")) {
                sb.append("<Transformation_donnees>   Spherique").append('\n');
                sb.append(ch).append('\n');
                while ((ch = buffer.readLine()) != null) {
                    sb.append(ch).append('\n');
                }
                buffer.close();
                fichier.close();
                FileUtils.saveStringToFich(path, file, sb);
            } else {
                buffer.close();
                fichier.close();
            }
        }
        catch (Exception e) {
            MsgUtils.erreurAndExit(this, "Analyse.majCompatibilite()", EPPLab.msg.getString("showOptionDialog.erreur"));
        }
    }
}

