/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.ssf.DefaultSsfInitializer;
import ec.tstoolkit.ssf.DurbinKoopmanInitializer;
import ec.tstoolkit.ssf.IFilteringResults;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.ISsfData;
import ec.tstoolkit.ssf.ISsfInitializer;
import ec.tstoolkit.ssf.SsfException;
import ec.tstoolkit.ssf.State;

public class Filter<F extends ISsf> {
    public static int fnCalls = 0;
    private State m_state;
    private F m_ssf;
    private ISsfData m_data;
    private ISsfInitializer<F> m_initializer;
    private int m_pos;
    private int m_end;
    private int m_r;
    private int m_steadypos = -1;
    private int[] m_idxR;
    private Matrix m_Q;
    private Matrix m_WQW;
    private Matrix m_W;
    private boolean m_bsteady;
    private boolean m_fixedsteadypos;
    private boolean m_qinit;
    protected double m_lastff;

    public Filter() {
    }

    public Filter(F ssf, ISsfInitializer<F> initializer) {
        this.m_ssf = ssf;
        this.m_initializer = initializer;
    }

    private void addRQR(Matrix P) {
        if (!this.m_ssf.hasTransitionRes(this.m_pos)) {
            return;
        }
        if (this.m_WQW != null) {
            if (!this.m_ssf.hasR()) {
                P.add(this.m_WQW);
            } else {
                int nr = this.m_idxR.length;
                for (int i = 0; i < nr; ++i) {
                    for (int j = 0; j <= i; ++j) {
                        double w = this.m_WQW.get(i, j);
                        P.add(this.m_idxR[i], this.m_idxR[j], w);
                        if (i == j) continue;
                        P.add(this.m_idxR[j], this.m_idxR[i], w);
                    }
                }
            }
        }
    }

    private void checkSteadyState() {
    }

    public void epred() {
        if (!this.m_bsteady) {
            this.m_state.f = this.m_ssf.ZVZ(this.m_pos, this.m_state.P.subMatrix());
            if (this.m_state.f < 1.0E-9) {
                this.m_state.f = 0.0;
            }
            this.m_lastff = this.m_state.f;
        }
        if (this.m_data.hasData()) {
            double y = this.m_data.get(this.m_pos);
            if (Double.isNaN(y)) {
                this.m_bsteady = false;
                this.m_state.e = Double.NaN;
            } else {
                this.m_ssf.ZM(this.m_pos, this.m_state.P.subMatrix(), this.m_state.C);
                this.m_ssf.TX(this.m_pos, this.m_state.C);
                this.m_state.e = y - this.m_ssf.ZX(this.m_pos, this.m_state.A);
                if (this.m_state.f == 0.0) {
                    if (Math.abs(this.m_state.e) > 1.0E-6) {
                        throw new SsfException(SsfException.INCONSISTENT);
                    }
                    this.m_state.e = 0.0;
                }
            }
        } else {
            this.m_ssf.ZM(this.m_pos, this.m_state.P.subMatrix(), this.m_state.C);
            this.m_ssf.TX(this.m_pos, this.m_state.C);
            this.m_state.e = 0.0;
        }
    }

    public ISsfInitializer<F> getInitializer() {
        return this.m_initializer;
    }

    public double getLastFf() {
        return this.m_lastff;
    }

    private boolean getModelInfo() {
        try {
            if (!this.m_ssf.hasTransitionRes(this.m_pos) || this.m_qinit && this.m_ssf.isTransitionEquationTimeInvariant()) {
                return true;
            }
            if (this.m_idxR != null && this.m_ssf.hasR()) {
                SubArrayOfInt R = SubArrayOfInt.create(this.m_idxR);
                R.set(0);
                this.m_ssf.R(this.m_pos, R);
            }
            if (this.m_Q != null) {
                this.m_Q.set(0.0);
                this.m_ssf.Q(this.m_pos, this.m_Q.subMatrix());
            }
            if (this.m_W != null && this.m_ssf.hasW()) {
                this.m_W.set(0.0);
                this.m_ssf.W(this.m_pos, this.m_W.subMatrix());
                SymmetricMatrix.quadraticFormT(this.m_Q.subMatrix(), this.m_W.subMatrix(), this.m_WQW.subMatrix());
                if (this.m_ssf.isTransitionEquationTimeInvariant()) {
                    this.m_qinit = true;
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public F getSsf() {
        return this.m_ssf;
    }

    public State getState() {
        return this.m_state;
    }

    public int getSteadyStatePosition() {
        return this.m_steadypos;
    }

    private boolean initFilter() {
        this.m_qinit = false;
        this.m_pos = 0;
        this.m_bsteady = false;
        if (!this.m_fixedsteadypos) {
            this.m_steadypos = -1;
        }
        this.m_lastff = 0.0;
        this.m_r = this.m_ssf.getStateDim();
        this.m_end = this.m_data.getCount();
        this.m_pos = 0;
        int rescount = this.m_ssf.getTransitionResCount();
        int resdim = this.m_ssf.getTransitionResDim();
        if (rescount != 0) {
            this.m_Q = new Matrix(resdim, resdim);
            this.m_idxR = (int[])(this.m_ssf.hasR() ? new int[rescount] : null);
            this.m_W = this.m_ssf.hasW() ? new Matrix(rescount, resdim) : null;
            this.m_WQW = this.m_W == null ? this.m_Q : new Matrix(rescount, rescount);
        } else {
            this.m_Q = null;
            this.m_idxR = null;
            this.m_W = null;
            this.m_WQW = null;
        }
        this.getModelInfo();
        return true;
    }

    private int initState(IFilteringResults rslts) {
        this.m_state = new State(this.m_r, this.m_data.hasData());
        if (this.m_initializer != null) {
            return this.m_initializer.initialize(this.m_ssf, this.m_data, this.m_state, rslts);
        }
        if (!this.m_ssf.isDiffuse()) {
            new DefaultSsfInitializer().initialize((ISsf)this.m_ssf, this.m_data, this.m_state, rslts);
            return 0;
        }
        DurbinKoopmanInitializer dk = new DurbinKoopmanInitializer();
        return dk.initialize((ISsf)this.m_ssf, this.m_data, this.m_state, rslts);
    }

    public boolean isInSteadyState() {
        return this.m_bsteady;
    }

    private boolean isNull(Matrix P) {
        return P.isZero(1.0E-6);
    }

    public void next() {
        if (this.m_state.isMissing()) {
            this.nextMissing();
        } else {
            if (!this.m_bsteady) {
                this.m_ssf.TVT(this.m_pos, this.m_state.P.subMatrix());
                if (this.m_state.f != 0.0) {
                    DataBlockIterator cols = this.m_state.P.columns();
                    DataBlock col = cols.getData();
                    int pos = 0;
                    do {
                        double c = -this.m_state.C.get(pos) / this.m_state.f;
                        if (pos > 0) {
                            col.drop(pos, 0).addAY(c, this.m_state.C.drop(pos, 0));
                        } else {
                            col.addAY(c, this.m_state.C);
                        }
                        ++pos;
                    } while (cols.next());
                    SymmetricMatrix.fromLower(this.m_state.P);
                }
                this.addRQR(this.m_state.P);
                if (this.m_ssf.isTimeInvariant()) {
                    this.checkSteadyState();
                }
            }
            if (this.m_data.hasData()) {
                this.m_ssf.TX(this.m_pos, this.m_state.A);
                if (this.m_state.e != 0.0) {
                    double v = this.m_state.e / this.m_state.f;
                    this.m_state.A.addAY(v, this.m_state.C);
                }
            }
        }
    }

    public boolean nextForecast() {
        if (!this.m_ssf.isTimeInvariant() && !this.getModelInfo()) {
            return false;
        }
        this.next();
        ++this.m_pos;
        return true;
    }

    private void nextMissing() {
        this.m_ssf.TVT(this.m_pos, this.m_state.P.subMatrix());
        this.addRQR(this.m_state.P);
        this.m_ssf.TX(this.m_pos, this.m_state.A);
    }

    public boolean process(ISsfData data, IFilteringResults rslts) {
        if (this.m_ssf == null) {
            return false;
        }
        ++fnCalls;
        this.m_data = data;
        if (!this.initFilter()) {
            return false;
        }
        this.m_pos = this.initState(rslts);
        if (this.m_pos < 0) {
            return false;
        }
        if (rslts != null) {
            rslts.prepare((ISsf)this.m_ssf, this.m_data);
        }
        if (this.m_pos < this.m_end) {
            do {
                if (!this.m_ssf.isTimeInvariant() && !this.getModelInfo()) {
                    return false;
                }
                this.epred();
                if (rslts != null) {
                    rslts.save(this.m_pos, this.m_state);
                }
                this.next();
            } while (++this.m_pos < this.m_end);
        }
        if (rslts != null) {
            rslts.close();
        }
        return true;
    }

    public void setInitializer(ISsfInitializer<F> value) {
        this.m_initializer = value;
    }

    public void setSsf(F value) {
        this.m_ssf = value;
    }

    public void setSteadyStatePosition(int value) {
        this.m_steadypos = value;
        this.m_fixedsteadypos = this.m_steadypos > 0;
    }
}

