/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.realfunctions;

import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.realfunctions.IFunctionMinimizer;
import ec.tstoolkit.maths.realfunctions.ISsqFunction;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionInstance;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionMinimizer;
import ec.tstoolkit.maths.realfunctions.SsqProxyFunction;
import ec.tstoolkit.maths.realfunctions.SsqProxyFunctionInstance;

public class SsqProxyMinimizer
implements ISsqFunctionMinimizer {
    private IFunctionMinimizer m_min;

    public SsqProxyMinimizer(IFunctionMinimizer min) {
        this.m_min = min;
    }

    @Override
    public ISsqFunctionMinimizer exemplar() {
        return new SsqProxyMinimizer(this.m_min.exemplar());
    }

    @Override
    public double getConvergenceCriterion() {
        return this.m_min.getConvergenceCriterion();
    }

    @Override
    public Matrix getCurvature() {
        return this.m_min.getCurvature();
    }

    @Override
    public double[] getGradient() {
        return this.m_min.getGradient();
    }

    @Override
    public int getIterCount() {
        return this.m_min.getIterCount();
    }

    @Override
    public int getMaxIter() {
        return this.m_min.getMaxIter();
    }

    @Override
    public ISsqFunctionInstance getResult() {
        SsqProxyFunctionInstance rslt = (SsqProxyFunctionInstance)this.m_min.getResult();
        return rslt.m_f;
    }

    @Override
    public double getObjective() {
        return this.m_min.getObjective();
    }

    @Override
    public boolean minimize(ISsqFunction function, ISsqFunctionInstance start) {
        return this.m_min.minimize(new SsqProxyFunction(function), new SsqProxyFunctionInstance(start));
    }

    @Override
    public void setConvergenceCriterion(double value) {
        this.m_min.setConvergenceCriterion(value);
    }

    @Override
    public void setMaxIter(int n) {
        this.m_min.setMaxIter(n);
    }
}

