/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.listener;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javolution.xml.ObjectWriter;
import net.sf.jclec.AlgorithmEvent;
import net.sf.jclec.IAlgorithmListener;
import net.sf.jclec.IConfigure;
import net.sf.jclec.IFitness;
import net.sf.jclec.IIndividual;
import net.sf.jclec.algorithm.PopulationAlgorithm;
import net.sf.jclec.fitness.IValueFitness;
import net.sf.jclec.listener.BasePopulationReportEntry;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasePopulationReport
implements IAlgorithmListener<PopulationAlgorithm>,
IConfigure {
    private static final long serialVersionUID = -8548482239030974796L;
    protected String reportDirName;
    protected int reportFrequency;
    private boolean includeIndividuals;
    protected IIndividual absolutelyBest;
    private File reportDirectory;
    private ObjectWriter<BasePopulationReportEntry> writer = new ObjectWriter();

    public final boolean isIncludeIndividuals() {
        return this.includeIndividuals;
    }

    public final void setIncludeIndividuals(boolean includeIndividuals) {
        this.includeIndividuals = includeIndividuals;
    }

    public final String getReportDirName() {
        return this.reportDirName;
    }

    public final void setReportDirName(String reportDirName) {
        this.reportDirName = reportDirName;
    }

    public final int getReportFrequency() {
        return this.reportFrequency;
    }

    public final void setReportFrequency(int reportFrequency) {
        this.reportFrequency = reportFrequency;
    }

    @Override
    public void algorithmStarted(AlgorithmEvent<PopulationAlgorithm> event) {
        String dateString = new Date(System.currentTimeMillis()).toString().replace(':', '.');
        this.reportDirectory = new File(String.valueOf(this.reportDirName) + "_" + dateString);
        if (!this.reportDirectory.mkdir()) {
            throw new RuntimeException("Error creating report directory");
        }
        this.doIterationReport(event.getAlgorithm());
    }

    @Override
    public void algorithmFinished(AlgorithmEvent<PopulationAlgorithm> event) {
        this.doIterationReport(event.getAlgorithm());
    }

    @Override
    public void iterationCompleted(AlgorithmEvent<PopulationAlgorithm> event) {
        this.doIterationReport(event.getAlgorithm());
    }

    @Override
    public void configure(Configuration settings) {
        String reportDirName = settings.getString("report-dir-name", "report");
        this.setReportDirName(reportDirName);
        int reportFrequency = settings.getInt("report-frequency", 1);
        this.setReportFrequency(reportFrequency);
        boolean includeIndividuals = settings.getBoolean("include-individuals", false);
        this.setIncludeIndividuals(includeIndividuals);
    }

    public boolean equals(Object other) {
        if (other instanceof BasePopulationReport) {
            BasePopulationReport cother = (BasePopulationReport)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.reportDirName, cother.reportDirName);
            eb.append(this.reportFrequency, cother.reportFrequency);
            eb.append(this.includeIndividuals, cother.includeIndividuals);
            return eb.isEquals();
        }
        return false;
    }

    protected void doIterationReport(PopulationAlgorithm algorithm) {
        BasePopulationReportEntry reportEntry = new BasePopulationReportEntry();
        Comparator<IFitness> comparator = algorithm.getEvaluator().getComparator();
        List<IIndividual> inds = algorithm.getInhabitants();
        int generation = algorithm.getGeneration();
        if (generation % this.reportFrequency == 0) {
            reportEntry.setGeneration(generation);
            if (this.includeIndividuals) {
                reportEntry.setInhabitants(inds);
            }
            IIndividual bestIndividual = this.bestIndividual(inds, comparator);
            reportEntry.setAbsolutelyBest(this.absolutelyBest);
            reportEntry.setBestIndividual(bestIndividual);
            reportEntry.setWorstIndividual(this.worstIndividual(inds, comparator));
            reportEntry.setMedianIndividual(this.medianIndividual(inds, comparator));
            double[] aux = this.averageAndVarianceFitnessOf(inds);
            reportEntry.setAverageFitness(aux[0]);
            reportEntry.setFitnessVariance(aux[1]);
            String reportFilename = String.format("Iteration%d.rep", generation);
            try {
                File reportFile = new File(this.reportDirectory, reportFilename);
                this.writer.write(reportEntry, new FileWriter(reportFile));
            }
            catch (IOException e) {
                throw new RuntimeException("Error writing report file");
            }
        } else {
            this.bestIndividual(inds, comparator);
        }
    }

    protected IIndividual bestIndividual(List<IIndividual> set, final Comparator<IFitness> comparator) {
        Comparator<IIndividual> indComparator = new Comparator<IIndividual>(){

            @Override
            public int compare(IIndividual arg0, IIndividual arg1) {
                return comparator.compare(arg0.getFitness(), arg1.getFitness());
            }
        };
        int setSize = set.size();
        IIndividual best = set.get(0);
        int i = 1;
        while (i < setSize) {
            IIndividual other = set.get(i);
            if (indComparator.compare(best, other) == -1) {
                best = other;
            }
            ++i;
        }
        if (this.absolutelyBest == null || indComparator.compare(this.absolutelyBest, best) == -1) {
            this.absolutelyBest = best;
        }
        return best;
    }

    protected IIndividual worstIndividual(List<IIndividual> set, final Comparator<IFitness> comparator) {
        Comparator<IIndividual> indComparator = new Comparator<IIndividual>(){

            @Override
            public int compare(IIndividual arg0, IIndividual arg1) {
                return comparator.compare(arg0.getFitness(), arg1.getFitness());
            }
        };
        int setSize = set.size();
        IIndividual worst = set.get(0);
        int i = 1;
        while (i < setSize) {
            IIndividual other = set.get(i);
            if (indComparator.compare(worst, other) == 1) {
                worst = other;
            }
            ++i;
        }
        return worst;
    }

    protected IIndividual medianIndividual(List<IIndividual> set, final Comparator<IFitness> comparator) {
        Comparator<IIndividual> indComparator = new Comparator<IIndividual>(){

            @Override
            public int compare(IIndividual arg0, IIndividual arg1) {
                return comparator.compare(arg1.getFitness(), arg0.getFitness());
            }
        };
        int setSize = set.size();
        LinkedList<IIndividual> aux = new LinkedList<IIndividual>(set);
        Collections.sort(aux, indComparator);
        return set.get(setSize / 2);
    }

    protected double[] averageAndVarianceFitnessOf(List<IIndividual> set) {
        double[] result = new double[]{0.0, 0.0};
        int nOfInds = set.size();
        for (IIndividual ind : set) {
            double tmp = ((IValueFitness)ind.getFitness()).getValue();
            result[0] = result[0] + tmp;
            result[1] = result[1] + tmp * tmp;
        }
        result[0] = result[0] / (double)nOfInds;
        result[1] = result[1] / (double)nOfInds - result[0] * result[0];
        return result;
    }
}

