/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.multiexprtree;

import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.ISpecies;
import net.sourceforge.jclec.base.AbstractMutator;
import net.sourceforge.jclec.exprtree.ExprTree;
import net.sourceforge.jclec.exprtree.ExprTreeSchema;
import net.sourceforge.jclec.exprtree.IMutateExprTree;
import net.sourceforge.jclec.multiexprtree.MultiExprTreeIndividual;
import net.sourceforge.jclec.multiexprtree.MultiExprTreeSpecies;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;

public class MultiExprTreeMutator
extends AbstractMutator
implements IConfigure {
    protected int targetTreeIndex = -1;
    protected IMutateExprTree baseOp;
    protected transient MultiExprTreeSpecies species;
    protected transient ExprTreeSchema[] schema;

    public int getTargetTreeIndex() {
        return this.targetTreeIndex;
    }

    public void setTargetTreeIndex(int targetTreeIndex) {
        this.targetTreeIndex = targetTreeIndex;
    }

    public IMutateExprTree getBaseOp() {
        return this.baseOp;
    }

    public void setBaseOp(IMutateExprTree baseOp) {
        this.baseOp = baseOp;
    }

    @Override
    public void configure(Configuration settings) {
        int targetTreeIndex = settings.getInt("target-tree-index", -1);
        this.setTargetTreeIndex(targetTreeIndex);
        try {
            String baseOpClassname = settings.getString("base-op[@type]");
            Class<?> baseOpClass = Class.forName(baseOpClassname);
            IMutateExprTree baseOp = (IMutateExprTree)baseOpClass.newInstance();
            if (baseOp instanceof IConfigure) {
                ((IConfigure)((Object)baseOp)).configure(settings.subset("base-op"));
            }
            this.setBaseOp(baseOp);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal operator classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of operator", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of operator", e);
        }
    }

    @Override
    protected void prepareMutation() {
        ISpecies spc = this.context.getSpecies();
        if (!(spc instanceof MultiExprTreeSpecies)) {
            throw new IllegalStateException("Illegal species in context");
        }
        this.species = (MultiExprTreeSpecies)spc;
        this.schema = ((MultiExprTreeSpecies)spc).getGenotypeSchema();
    }

    @Override
    protected void mutateNext() {
        int nOfExprTrees = this.species.numberOfExprTrees();
        int actTargetExprIndex = this.targetTreeIndex == -1 ? this.randgen.choose(0, nOfExprTrees) : this.targetTreeIndex;
        ExprTree[] parentGenotype = (ExprTree[])((MultiExprTreeIndividual)this.parentsBuffer.get(this.parentsCounter)).getGenotype();
        ExprTree[] sonGenotype = new ExprTree[nOfExprTrees];
        int i = 0;
        while (i < nOfExprTrees) {
            sonGenotype[i] = i == actTargetExprIndex ? this.baseOp.mutateExprTree(parentGenotype[i], this.schema[i], this.randgen) : parentGenotype[i].copy();
            ++i;
        }
        this.sonsBuffer.add(this.species.createIndividual(sonGenotype));
    }
}

