/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.exprtree;

import net.sf.jclec.IConfigure;
import net.sf.jclec.ISpecies;
import net.sf.jclec.base.AbstractMutator;
import net.sf.jclec.exprtree.ExprTree;
import net.sf.jclec.exprtree.ExprTreeIndividual;
import net.sf.jclec.exprtree.IExprTreeSpecies;
import org.apache.commons.configuration.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExprTreeMutator<I extends ExprTreeIndividual>
extends AbstractMutator<I>
implements IConfigure {
    protected int targetTreeIndex = -1;
    protected transient IExprTreeSpecies<I> species;
    protected transient IExprTreeSpecies.IExprTreeSchema[] schema;

    public int getTargetTreeIndex() {
        return this.targetTreeIndex;
    }

    public void setTargetTreeIndex(int targetTreeIndex) {
        this.targetTreeIndex = targetTreeIndex;
    }

    @Override
    public void configure(Configuration settings) {
        int targetTreeIndex = settings.getInt("target-tree-index", -1);
        this.setTargetTreeIndex(targetTreeIndex);
    }

    @Override
    protected void prepareMutation() {
        ISpecies spc = this.context.getSpecies();
        if (!(spc instanceof IExprTreeSpecies)) {
            throw new IllegalStateException("Illegal species in context");
        }
        this.species = (IExprTreeSpecies)spc;
        this.schema = ((IExprTreeSpecies)spc).getGenotypeSchema();
    }

    @Override
    protected void mutateNext() {
        int nOfExprTrees = this.species.numberOfExprTrees();
        int actTargetExprIndex = this.targetTreeIndex == -1 ? this.randgen.choose(0, nOfExprTrees) : this.targetTreeIndex;
        ExprTree[] parentGenotype = (ExprTree[])((ExprTreeIndividual)this.parentsBuffer.get(this.parentsCounter)).getGenotype();
        ExprTree[] sonGenotype = new ExprTree[nOfExprTrees];
        int i = 0;
        while (i < nOfExprTrees) {
            sonGenotype[i] = i == actTargetExprIndex ? this.mutateExpression(parentGenotype[i], this.schema[i]) : parentGenotype[i].copy();
            ++i;
        }
        this.sonsBuffer.add(this.species.createIndividual(sonGenotype));
    }

    protected abstract ExprTree mutateExpression(ExprTree var1, IExprTreeSpecies.IExprTreeSchema var2);
}

