/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.problem.classification.tan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.jclec.problem.classification.Classifier;
import net.sourceforge.jclec.problem.classification.IClassificationRule;
import net.sourceforge.jclec.util.dataset.IDataset;

public class TanClassifier
extends Classifier {
    private static final long serialVersionUID = -6792167360656990171L;

    public TanClassifier(List<IClassificationRule> list, double defaultC) {
        super(list, defaultC);
    }

    public void sortClassifier(IDataset dataset) {
        int numRules = super.getClassificationRules().size();
        int[] tp = new int[numRules];
        int[] tn = new int[numRules];
        int[] fn = new int[numRules];
        int[] fp = new int[numRules];
        IDataset.IInstance[] instances = dataset.getInstances();
        int numInstances = instances.length;
        int j = 0;
        while (j < numInstances) {
            IDataset.IInstance instance = instances[j];
            double value = instance.getValue(dataset.getMetadata().getClassIndex());
            int i = 0;
            while (i < numRules) {
                if (super.getClassificationRules().get(i).covers(instance)) {
                    if (super.getClassificationRules().get(i).getConsequent() == value) {
                        int n = i;
                        tp[n] = tp[n] + 1;
                    } else {
                        int n = i;
                        fp[n] = fp[n] + 1;
                    }
                } else if (super.getClassificationRules().get(i).getConsequent() != value) {
                    int n = i;
                    tn[n] = tn[n] + 1;
                } else {
                    int n = i;
                    fn[n] = fn[n] + 1;
                }
                ++i;
            }
            ++j;
        }
        double[] se = new double[numRules];
        HashMap<Double, Integer> rulesMap = new HashMap<Double, Integer>();
        int i = 0;
        while (i < numRules) {
            se[i] = tn[i] + fp[i] == 0 ? 0.0 : (double)tn[i] / (double)(tn[i] + fp[i]);
            rulesMap.put(se[i], i);
            ++i;
        }
        this.quicksort(se, 0, numRules - 1);
        ArrayList<IClassificationRule> rulesAux = new ArrayList<IClassificationRule>();
        int i2 = 0;
        while (i2 < numRules) {
            rulesAux.add(super.getClassificationRules().get((Integer)rulesMap.get(se[i2])));
            ++i2;
        }
        super.getClassificationRules().clear();
        super.setClassificationRules(rulesAux);
        rulesAux = null;
    }

    private void quicksort(double[] se, int i, int j) {
        if (i >= j) {
            return;
        }
        int k = this.partition(se, i, j);
        this.quicksort(se, i, k - 1);
        this.quicksort(se, k + 1, j);
    }

    protected int partition(double[] se, int i, int j) {
        int k = i++;
        while (true) {
            if (i < j && this.compare(se, i, k) <= 0) {
                ++i;
                continue;
            }
            while (i < j && this.compare(se, j, k) >= 0) {
                --j;
            }
            if (i == j) break;
            this.swap(se, i, j);
        }
        if (this.compare(se, k, i) < 0) {
            --i;
        }
        this.swap(se, k, i);
        return i;
    }

    protected void swap(double[] se, int i, int j) {
        double x = se[i];
        se[i] = se[j];
        se[j] = x;
    }

    protected int compare(double[] se, int i, int j) {
        if (se[i] < se[j]) {
            return -1;
        }
        if (se[i] == se[j]) {
            return 0;
        }
        return 1;
    }
}

