/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.DT_GA;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import keel.Algorithms.Decision_Trees.DT_GA.BaseR;
import keel.Algorithms.Decision_Trees.DT_GA.C45.C45;
import keel.Algorithms.Decision_Trees.DT_GA.Clasificador;
import keel.Algorithms.Decision_Trees.DT_GA.myDataset;
import keel.Algorithms.Decision_Trees.DT_GA.parseParameters;
import org.core.Fichero;
import org.core.Randomize;

public class DT_GA {
    myDataset train;
    myDataset val;
    myDataset test;
    String outputTr;
    String outputTst;
    String ficheroBR;
    String claseMayoritaria;
    int nClasses;
    int nGenerations;
    int popSize;
    int instancesPerLeaf;
    int type;
    int S;
    double crossProb;
    double mutProb;
    float confidence;
    boolean pruned;
    String fichTrain;
    BaseR baseReglasTree;
    BaseR baseReglasGA;
    Clasificador clasif;
    public static int GA_SMALL = 0;
    public static int GA_LARGE_SN = 1;
    private boolean somethingWrong = false;

    public DT_GA() {
    }

    public DT_GA(parseParameters parameters) {
        this.train = new myDataset();
        this.val = new myDataset();
        this.test = new myDataset();
        this.fichTrain = parameters.getTrainingInputFile();
        try {
            System.out.println("\nReading the training set: " + parameters.getTrainingInputFile());
            this.train.readClassificationSet(parameters.getTrainingInputFile(), true);
            System.out.println("\nReading the validation set: " + parameters.getValidationInputFile());
            this.val.readClassificationSet(parameters.getValidationInputFile(), false);
            System.out.println("\nReading the test set: " + parameters.getTestInputFile());
            this.test.readClassificationSet(parameters.getTestInputFile(), false);
        }
        catch (IOException e) {
            System.err.println("There was a problem while reading the input data-sets: " + e);
            this.somethingWrong = true;
        }
        this.somethingWrong = this.somethingWrong || this.train.hasMissingAttributes();
        this.outputTr = parameters.getTrainingOutputFile();
        this.outputTst = parameters.getTestOutputFile();
        this.ficheroBR = parameters.getOutputFile(0);
        long semilla = Long.parseLong(parameters.getParameter(0));
        String aux = parameters.getParameter(1);
        this.pruned = true;
        this.confidence = Float.parseFloat(parameters.getParameter(1));
        this.instancesPerLeaf = Integer.parseInt(parameters.getParameter(2));
        aux = parameters.getParameter(3);
        this.type = GA_SMALL;
        if (aux.compareToIgnoreCase("GA-LARGE-SN") == 0) {
            this.type = GA_LARGE_SN;
        }
        this.S = Integer.parseInt(parameters.getParameter(4));
        this.nGenerations = Integer.parseInt(parameters.getParameter(5));
        this.popSize = Integer.parseInt(parameters.getParameter(6));
        while (this.popSize % 2 != 0) {
            ++this.popSize;
        }
        this.crossProb = Double.parseDouble(parameters.getParameter(7));
        this.mutProb = Double.parseDouble(parameters.getParameter(8));
        Randomize.setSeed(semilla);
    }

    public void execute() {
        if (this.somethingWrong) {
            System.err.println("An error was found, the data-set has missing values.");
            System.err.println("Aborting the program");
        } else {
            this.nClasses = this.train.getnClasses();
            C45 arbol = new C45(this.fichTrain, this.pruned, this.confidence, this.instancesPerLeaf);
            try {
                arbol.generateTree();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                System.exit(-1);
            }
            Fichero.escribeFichero("arbol.txt", arbol.printString());
            String cadenaArbol = arbol.printString();
            this.obtenerReglas(cadenaArbol);
            this.baseReglasTree.cubrirEjemplos();
            System.out.println(this.baseReglasTree.printString());
            this.baseReglasGA = this.baseReglasTree.genetico(this.type, this.S, this.nGenerations, this.popSize, this.crossProb, this.mutProb);
            this.claseMayoritaria = this.train.claseMasFrecuente();
            this.clasif = new Clasificador(this.baseReglasTree, this.baseReglasGA, this.type, this.S, this.claseMayoritaria);
            double accTr = this.doOutput(this.val, this.outputTr);
            double accTst = this.doOutput(this.test, this.outputTst);
            this.escribeSalidas(accTr, accTst);
        }
    }

    private double doOutput(myDataset dataset, String filename) {
        String output = new String("");
        output = dataset.copyHeader();
        int aciertos = 0;
        for (int i = 0; i < dataset.getnData(); ++i) {
            String claseReal = dataset.getOutputAsString(i);
            String prediccion = this.classificationOutput(dataset.getExample(i));
            output = output + claseReal + " " + prediccion + "\n";
            if (!claseReal.equalsIgnoreCase(prediccion)) continue;
            ++aciertos;
        }
        Fichero.escribeFichero(filename, output);
        return 1.0 * (double)aciertos / (double)dataset.size();
    }

    private String classificationOutput(double[] example) {
        return this.clasif.clasifica(example);
    }

    private void obtenerReglas(String cadenaArbol) {
        String reglas = new String("");
        StringTokenizer lineas = new StringTokenizer(cadenaArbol, "\n");
        String linea = lineas.nextToken();
        linea = lineas.nextToken();
        Vector<String> variables = new Vector<String>();
        Vector<String> valores = new Vector<String>();
        Vector<String> operadores = new Vector<String>();
        int contador = 0;
        while (lineas.hasMoreTokens()) {
            int i;
            linea = lineas.nextToken();
            StringTokenizer campo = new StringTokenizer(linea, " \t");
            String cosa = campo.nextToken();
            if (cosa.compareToIgnoreCase("if") == 0) {
                campo.nextToken();
                variables.add(campo.nextToken());
                operadores.add(campo.nextToken());
                valores.add(campo.nextToken());
                continue;
            }
            if (cosa.compareToIgnoreCase("elseif") == 0) {
                int dejar = Integer.parseInt(campo.nextToken());
                for (int i2 = variables.size() - 1; i2 >= dejar; --i2) {
                    variables.remove(variables.size() - 1);
                    operadores.remove(operadores.size() - 1);
                    valores.remove(valores.size() - 1);
                }
                campo.nextToken();
                variables.add(campo.nextToken());
                operadores.add(campo.nextToken());
                valores.add(campo.nextToken());
                continue;
            }
            campo.nextToken();
            reglas = reglas + "\nRULE-" + ++contador + ": IF ";
            for (i = 0; i < variables.size() - 1; ++i) {
                reglas = reglas + (String)variables.get(i) + " " + (String)operadores.get(i) + " " + (String)valores.get(i) + " AND ";
            }
            reglas = reglas + (String)variables.get(i) + " " + (String)operadores.get(i) + " " + (String)valores.get(i);
            reglas = reglas + " THEN class = " + campo.nextToken();
            variables.remove(variables.size() - 1);
            operadores.remove(operadores.size() - 1);
            valores.remove(valores.size() - 1);
        }
        this.baseReglasTree = new BaseR(this.train, reglas);
    }

    public void escribeSalidas(double accTr, double accTst) {
        System.out.println("Number of Rules (Tree): " + this.baseReglasTree.size());
        System.out.println("" + this.baseReglasTree.printString());
        System.out.println("Number of Rules (GA): " + this.baseReglasGA.size());
        System.out.println("" + this.baseReglasGA.printString());
        System.out.println("Accuracy in training: " + accTr);
        System.out.println("Accuracy in test: " + accTst);
        System.out.println("Algorithm Finished");
        Fichero.escribeFichero(this.ficheroBR, this.baseReglasTree.printString() + "\n");
        Fichero.AnadirtoFichero(this.ficheroBR, this.baseReglasGA.printString() + "\n");
        Fichero.AnadirtoFichero(this.ficheroBR, "Accuracy in training: " + accTr + "\n");
        Fichero.AnadirtoFichero(this.ficheroBR, "Accuracy in test: " + accTst + "\n");
    }
}

