## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.align = "center"
)

## -----------------------------------------------------------------------------
library(SLOPE)

fit_gaussian <- SLOPE(
  x = bodyfat$x,
  y = bodyfat$y,
  family = "gaussian"
)

## -----------------------------------------------------------------------------
plot(fit_gaussian)

## -----------------------------------------------------------------------------
summary(fit_gaussian)

## -----------------------------------------------------------------------------
coef(fit_gaussian, alpha = 0.05)

## -----------------------------------------------------------------------------
y_hat <- predict(fit_gaussian, x = bodyfat$x[1:5, ], alpha = 0.01)

plot(bodyfat$y[1:5], y_hat)

## -----------------------------------------------------------------------------
fit_logistic <- SLOPE(
  x = heart$x,
  y = heart$y,
  family = "binomial"
)

## -----------------------------------------------------------------------------
plot(fit_logistic)

## -----------------------------------------------------------------------------
fit_poisson <- SLOPE(
  x = abalone$x,
  y = abalone$y,
  family = "poisson"
)

plot(fit_poisson)

## -----------------------------------------------------------------------------
fit_multinomial <- SLOPE(
  x = wine$x,
  y = wine$y,
  family = "multinomial"
)

## -----------------------------------------------------------------------------
fit_multinomial$coefficients[[2]]

## -----------------------------------------------------------------------------
par(mfrow = c(1, 2))
plot(fit_multinomial)

