## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ----echo=FALSE, results='asis'-----------------------------------------------
files <- try(list.files(system.file("extdata", package = "andorR")), silent = TRUE)

if (length(files) > 0 && !inherits(files, "try-error")) {
  cat("The following example data files are included in the `inst/extdata` directory:\n\n")
  cat(paste("*", files), sep = "\n")
} else {
  cat("No example data files were found in the package's `inst/extdata` folder.\n")
}

## ----eval=FALSE---------------------------------------------------------------
# path <- system.file("extdata", "ethical.csv", package = "andorR")
# my_tree <- load_tree_csv(path)

## ----eval=FALSE---------------------------------------------------------------
# path <- system.file("extdata", "ethical_path.csv", package = "andorR")
# df <- read.csv(path)
# my_tree <- load_tree_df_path(df)

## ----eval=FALSE---------------------------------------------------------------
# path <- system.file("extdata", "ethical.yml", package = "andorR")
# my_tree <- load_tree_yaml(path)

