/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.topics;

import cc.mallet.topics.AbstractTopicReports;
import cc.mallet.topics.ParallelTopicModel;
import cc.mallet.topics.TopicReports;
import cc.mallet.types.IDSorter;
import cc.mallet.types.InstanceList;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Iterator;
import java.util.TreeSet;

public class JSONTopicReports
extends AbstractTopicReports
implements TopicReports {
    public JSONTopicReports(ParallelTopicModel model) {
        super(model);
    }

    @Override
    public void printSamplingState(PrintWriter out) throws IOException {
    }

    @Override
    public void printTopicDocuments(PrintWriter out, int max) throws IOException {
    }

    @Override
    public void printDocumentTopics(PrintWriter out, double threshold, int max) throws IOException {
    }

    @Override
    public void printDenseDocumentTopics(PrintWriter out) throws IOException {
    }

    @Override
    public void printTopicWordWeights(PrintWriter out) throws IOException {
    }

    @Override
    public void printTypeTopicCounts(PrintWriter out) throws IOException {
    }

    @Override
    public void printTopicPhrases(PrintWriter out, int numWords) throws IOException {
    }

    @Override
    public void printSummary(PrintWriter out, int numWords) throws IOException {
        Formatter buffer = new Formatter();
        ArrayList<TreeSet<IDSorter>> topicSortedWords = this.model.getSortedWords();
        buffer.format("[", new Object[0]);
        for (int topic = 0; topic < this.model.numTopics; ++topic) {
            TreeSet<IDSorter> sortedWords = topicSortedWords.get(topic);
            Iterator<IDSorter> iterator = sortedWords.iterator();
            buffer.format("{\"topic\":%d, \"smoothing\":%f, \"words\":{", topic, this.model.alpha[topic]);
            for (int word = 0; iterator.hasNext() && word < numWords; ++word) {
                IDSorter info = iterator.next();
                buffer.format("\"%s\": %f", this.model.alphabet.lookupObject(info.getID()), info.getWeight());
                if (!iterator.hasNext() || word >= numWords - 1) continue;
                buffer.format(",", new Object[0]);
            }
            buffer.format("}}", new Object[0]);
            if (topic >= this.model.numTopics - 1) continue;
            buffer.format(",", new Object[0]);
        }
        buffer.format("]", new Object[0]);
        out.println(buffer);
    }

    public static void main(String[] args) throws Exception {
        InstanceList instances = InstanceList.load(new File(args[0]));
        ParallelTopicModel model = new ParallelTopicModel(50, 5.0, 0.01);
        model.addInstances(instances);
        model.setNumIterations(100);
        model.estimate();
        JSONTopicReports reports = new JSONTopicReports(model);
        reports.printSummary(new File("summary.json"), 20);
    }
}

