/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Alphabet;
import cc.mallet.types.AlphabetCarrying;
import cc.mallet.types.Sequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class FeatureSequence
implements Sequence,
Serializable,
AlphabetCarrying {
    Alphabet dictionary;
    int[] features;
    int length;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;
    private static final int NULL_INTEGER = -1;

    public FeatureSequence(Alphabet dict, int[] features) {
        this(dict, features.length);
        for (int i = 0; i < features.length; ++i) {
            this.add(features[i]);
        }
    }

    public FeatureSequence(Alphabet dict, int[] features, int len) {
        this(dict, len);
        for (int i = 0; i < len; ++i) {
            this.add(features[i]);
        }
    }

    public FeatureSequence(Alphabet dict, int capacity) {
        this.dictionary = dict;
        this.features = new int[capacity > 2 ? capacity : 2];
        this.length = 0;
    }

    public FeatureSequence(Alphabet dict) {
        this(dict, 2);
    }

    public int[] getFeatures() {
        return this.features;
    }

    @Override
    public Alphabet getAlphabet() {
        return this.dictionary;
    }

    @Override
    public Alphabet[] getAlphabets() {
        return new Alphabet[]{this.getAlphabet()};
    }

    public boolean alphabetsMatch(AlphabetCarrying object) {
        return this.getAlphabet().equals(object.getAlphabet());
    }

    public final int getLength() {
        return this.length;
    }

    @Override
    public final int size() {
        return this.length;
    }

    public final int getIndexAtPosition(int pos) {
        return this.features[pos];
    }

    public Object getObjectAtPosition(int pos) {
        return this.dictionary.lookupObject(this.features[pos]);
    }

    public Object get(int pos) {
        return this.dictionary.lookupObject(this.features[pos]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int fsi = 0; fsi < this.length; ++fsi) {
            Object o = this.dictionary.lookupObject(this.features[fsi]);
            sb.append(fsi);
            sb.append(": ");
            sb.append(o.toString());
            sb.append(" (");
            sb.append(this.features[fsi]);
            sb.append(")\n");
        }
        return sb.toString();
    }

    protected void growIfNecessary() {
        if (this.length == this.features.length) {
            int[] newFeatures = new int[this.features.length * 2];
            System.arraycopy(this.features, 0, newFeatures, 0, this.length);
            this.features = newFeatures;
        }
    }

    public void add(int featureIndex) {
        this.growIfNecessary();
        assert (featureIndex < this.dictionary.size());
        this.features[this.length++] = featureIndex;
    }

    public void add(Object key) {
        int fi = this.dictionary.lookupIndex(key);
        if (fi >= 0) {
            this.add(fi);
        }
    }

    public void addFeatureWeightsTo(double[] weights) {
        for (int i = 0; i < this.length; ++i) {
            int n = this.features[i];
            weights[n] = weights[n] + 1.0;
        }
    }

    public void addFeatureWeightsTo(double[] weights, double scale) {
        for (int i = 0; i < this.length; ++i) {
            int n = this.features[i];
            weights[n] = weights[n] + scale;
        }
    }

    public int[] toFeatureIndexSequence() {
        int[] feats = new int[this.length];
        System.arraycopy(this.features, 0, feats, 0, this.length);
        return feats;
    }

    public int[] toSortedFeatureIndexSequence() {
        int[] feats = this.toFeatureIndexSequence();
        Arrays.sort(feats);
        return feats;
    }

    public void prune(Alphabet newAlphabet) {
        int newLength = 0;
        boolean[] keepers = new boolean[this.length];
        for (int i = 0; i < this.length; ++i) {
            if (!newAlphabet.contains(this.dictionary.lookupObject(this.features[i]))) continue;
            keepers[i] = true;
            ++newLength;
        }
        int[] newFeatures = new int[newLength];
        int newIndex = 0;
        for (int i = 0; i < this.length; ++i) {
            if (!keepers[i]) continue;
            newFeatures[newIndex] = newAlphabet.lookupIndex(this.dictionary.lookupObject(this.features[i]));
            ++newIndex;
        }
        this.features = newFeatures;
        this.length = newLength;
        this.dictionary = newAlphabet;
    }

    public void prune(double[] counts, Alphabet newAlphabet, int cutoff) {
        int newLength = 0;
        for (int i = 0; i < this.length; ++i) {
            if (!(counts[this.features[i]] >= (double)cutoff)) continue;
            ++newLength;
        }
        int[] newFeatures = new int[newLength];
        int newIndex = 0;
        for (int i = 0; i < this.length; ++i) {
            if (!(counts[this.features[i]] >= (double)cutoff)) continue;
            Object feature = this.dictionary.lookupObject(this.features[i]);
            newFeatures[newIndex] = newAlphabet.lookupIndex(feature);
            ++newIndex;
        }
        this.features = newFeatures;
        this.length = newLength;
        this.dictionary = newAlphabet;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeObject(this.dictionary);
        out.writeInt(this.features.length);
        for (int i = 0; i < this.features.length; ++i) {
            out.writeInt(this.features[i]);
        }
        out.writeInt(this.length);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.dictionary = (Alphabet)in.readObject();
        int featuresLength = in.readInt();
        this.features = new int[featuresLength];
        for (int i = 0; i < featuresLength; ++i) {
            this.features[i] = in.readInt();
        }
        this.length = in.readInt();
    }
}

