/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.tokenizer;

import java.io.IOException;
import opennlp.tools.cmdline.AbstractCrossValidatorTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.CVParams;
import opennlp.tools.cmdline.tokenizer.TokenEvaluationErrorListener;
import opennlp.tools.cmdline.tokenizer.TokenizerTrainerTool;
import opennlp.tools.cmdline.tokenizer.TrainingParams;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.tokenize.TokenizerCrossValidator;
import opennlp.tools.tokenize.TokenizerFactory;
import opennlp.tools.util.eval.FMeasure;
import opennlp.tools.util.model.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenizerCrossValidatorTool
extends AbstractCrossValidatorTool<TokenSample, CVToolParams> {
    public TokenizerCrossValidatorTool() {
        super(TokenSample.class, CVToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "K-fold cross validator for the learnable tokenizer";
    }

    @Override
    public void run(String format, String[] args) {
        TokenizerCrossValidator validator;
        super.run(format, args);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((CVToolParams)this.params).getParams(), false);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createTrainingParameters(((CVToolParams)this.params).getIterations(), ((CVToolParams)this.params).getCutoff());
        }
        TokenEvaluationErrorListener listener = null;
        if (((CVToolParams)this.params).getMisclassified().booleanValue()) {
            listener = new TokenEvaluationErrorListener();
        }
        try {
            Dictionary dict = TokenizerTrainerTool.loadDict(((CVToolParams)this.params).getAbbDict());
            TokenizerFactory tokFactory = TokenizerFactory.create(((CVToolParams)this.params).getFactory(), ((CVToolParams)this.params).getLang(), dict, ((CVToolParams)this.params).getAlphaNumOpt(), null);
            validator = new TokenizerCrossValidator(this.mlParams, tokFactory, listener);
            validator.evaluate(this.sampleStream, ((CVToolParams)this.params).getFolds());
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException e) {}
        }
        FMeasure result = validator.getFMeasure();
        System.out.println(result.toString());
    }

    static interface CVToolParams
    extends CVParams,
    TrainingParams {
    }
}

