
<!-- badges: start -->

[![R-CMD-check](https://github.com/jaromilfrossard/permuco/workflows/R-CMD-check/badge.svg/)](https://github.com/jaromilfrossard/permuco/actions/)
[![Codecov test
coverage](https://codecov.io/gh/jaromilfrossard/permuco/branch/master/graph/badge.svg/)](https://app.codecov.io/gh/jaromilfrossard/permuco?branch=master/)
[![CRAN
status](https://www.r-pkg.org/badges/version/permuco)](https://CRAN.R-project.org/package=permuco)
[![R-CMD-check](https://github.com/jaromilfrossard/permuco/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/jaromilfrossard/permuco/actions/workflows/R-CMD-check.yaml)
[![test-coverage](https://github.com/jaromilfrossard/permuco/actions/workflows/test-coverage.yaml/badge.svg)](https://github.com/jaromilfrossard/permuco/actions/workflows/test-coverage.yaml)
<!-- badges: end -->

# `permuco`

This package provides functions to compute permutation tests in linear
models with nuisances variables. The package has several goals :

-   Providing to users the most recent methods to handle nuisance
    variables for permutation tests in the linear models.
-   Giving to users tools to compute most common tests in linear model
    (t-test, ANOVA and repeated measures ANOVA).
-   Providing an extension for the multiple comparisons problem in
    linear models with a focus for EEG data.

See [Reference](https://jaromilfrossard.github.io/permuco/reference/)
for more information on the function or check the
[article](https://raw.githubusercontent.com/jaromilfrossard/permuco/master/vignettes/permuco_tutorial.pdf)
presenting the package.

## The `lmperm()` function

This function is constructed as an extension of the the `lm()` function
for permutation test. It produces t statistics with univariate and
bivariate p-value by permutation.

## The `aovperm()` function

This function is constructed as an extension of the the `aov()` function
for permutation test. It produces marginal F statistics (type III) for
factorial ANOVA and ANCOVA. Moreover, repeated measures ANOVA can be
perform using the same notations used in an `aov()` formula with
`+Error(id/within)` to specify the random effects.

## The `clusterlm()` function

This function compute cluster-mass statistics for multiple comparisons.
It is designed for ERP analysis of uni-channel EEG data. The left part
of formula object must be a matrix or dataframe which columns represents
multiple responses tested on the same experimental design (specified by
right part of the formula). This function provides several methods to
handle nuisance variables, a F or t statistics, an extension for
repeated measures ANOVA and several methods for the multiple comparisons
like the threshold-free cluster enhancement.

# Contact

If you need help to use the package or want to report errors, contact
Jaromil Frossard at <jaromil.frossard@unige.ch>.

# References

For permutation tests with nuisance variables :

-   Kherad-Pajouh, S., & Renaud, O. (2010). An exact permutation method
    for testing any effect in balanced and unbalanced fixed effect
    ANOVA. Computational Statistics & Data Analysis, 54(7), 1881-1893.

-   Winkler, A. M., Ridgway, G. R., Webster, M. A., Smith, S. M., &
    Nichols, T. E. (2014). Permutation inference for the general linear
    model. Neuroimage, 92, 381-397.

For permutation test in repeated measures ANOVA :

-   Kherad-Pajouh, S., & Renaud, O. (2015). A general permutation
    approach for analyzing repeated measures ANOVA and mixed-model
    designs. Statistical Papers, 56(4), 947-967.

For cluster-mass statistics for the muliple comparison problems :

-   Maris, E., & Oostenveld, R. (2007). Nonparametric statistical
    testing of EEG-and MEG-data. Journal of neuroscience methods,
    164(1), 177-190.

For the threshold-free cluster-enhancement method :

-   Smith, S. M., & Nichols, T. E. (2009). Threshold-free cluster
    enhancement: addressing problems of smoothing, threshold dependence
    and localisation in cluster inference. Neuroimage, 44(1), 83-98.

# Academic works using permuco

-   Allen, S. L., Bonduriansky, R., & Chenoweth, S. F. (2018). Genetic
    constraints on microevolutionary divergence of sex-biased gene
    expression. Phil. Trans. R. Soc. B, 373(1757), 20170427.

-   Almodóvar-Rivera, I., & Maitra, R. (2019). FAST adaptive smoothing
    and thresholding for improved activation detection in low-signal
    fMRI. IEEE transactions on medical imaging.

-   Bürki, A., Frossard, J., & Renaud, O. (2018). Accounting for
    stimulus and participant effects in event-related potential analyses
    to increase the replicability of studies. Journal of neuroscience
    methods, 309, 218-227.

-   Christie, B. R., Trivino‐Paredes, J., Pinar, C., Neale, K. J.,
    Meconi, A., Reid, H., & Hutton, C. P. (2019). A Rapid Neurological
    Assessment Protocol for Repeated Mild Traumatic Brain Injury in
    Awake Rats. Current protocols in neuroscience, 89(1), e80.

-   Destro, G. F. G., de Fernandes, V., de Andrade, A. F. A., De Marco,
    P., & Terribile, L. C. (2019). Back home? Uncertainties for
    returning seized animals to the source‐areas under climate change.
    Global change biology.

-   Drexl, K., Kunze, A. E., & Werner, G. G. (2019). The German version
    of the Fear of Sleep Inventory-Short Form: A psychometric study.
    European Journal of Trauma & Dissociation.

-   Godfrey, M., Hepburn, S., Fidler, D. J., Tapera, T., Zhang, F.,
    Rosenberg, C. R., & Lee, N. R. (2019). Autism spectrum disorder
    (ASD) symptom profiles of children with comorbid Down syndrome (DS)
    and ASD: A comparison with children with DS-only and ASD-only.
    Research in Developmental Disabilities, 89, 83-93.

-   Hartmann, M., Sommer, N. R., Diana, L., Müri, R. M., &
    Eberhard-Moscicka, A. K. (2018). Further to the right: Viewing
    distance modulates attentional asymmetries (‘pseudoneglect’) during
    visual exploration. Brain and Cognition.

-   Kern, E. M. A., & Langerhans, R. B. (2019). Urbanization Alters
    Swimming Performance of a Stream Fish. Front. Ecol. Evol. 6: 229.
    doi: 10.3389/fevo.

-   Musariri, T., Pegg, N., Muvengwi, J., & Muzama, F. (2018). Differing
    patterns of plant spinescence affect blue duiker (Bovidae:
    Philantomba monticola) browsing behavior and intake rates. Ecology
    and Evolution.

-   Podofillini, S., Cecere, J. G., Griggio, M., Corti, M., Capua, E. L.
    D., Parolini, M., … & Rubolini, D. (2019). Benefits of extra food to
    reproduction depend on maternal condition. Oikos.

-   Soler, J., Arias, B., Moya, J., Ibáñez, M. I., Ortet, G., Fañanás,
    L., & Fatjó-Vilas, M. (2019). The interaction between the ZNF804A
    gene and cannabis use on the risk of psychosis in a non-clinical
    sample. Progress in Neuro-Psychopharmacology and Biological
    Psychiatry, 89, 174-180.

-   Swanson, K., Goldbach, H. C., & Laubach, M. (2019). The rat medial
    frontal cortex controls pace, but not breakpoint, in a progressive
    ratio licking task. Behavioral neuroscience, 133(4), 385.
