/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures.swapList;

import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.util.objects.setDataStructures.AbstractSet;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class Set_Swap
extends AbstractSet
implements ISet.WithOffset {
    private int size;
    private final int mapOffset;
    private int[] values;
    private int[] map;
    private final ISetIterator iter = this.newIterator();

    public Set_Swap(int offSet) {
        this.mapOffset = offSet;
        this.size = 0;
        this.values = new int[16];
        this.map = new int[16];
        for (int i = 0; i < this.map.length; ++i) {
            this.map[i] = -1;
        }
    }

    @Override
    public int getOffset() {
        return this.mapOffset;
    }

    public int getNth(int nth) {
        if (nth < 0 || nth >= this.size()) {
            throw new SolverException(" invalid getNth parameter, must  be 0 <= nth (" + nth + ") < size (" + this.size() + ")");
        }
        return this.values[nth];
    }

    @Override
    public boolean add(int element) {
        int ns;
        int[] tmp;
        if (element < this.mapOffset) {
            throw new IllegalStateException("Cannot add " + element + " to set of offset " + this.mapOffset);
        }
        if (this.contains(element)) {
            return false;
        }
        int size = this.size();
        if (size == this.values.length) {
            tmp = this.values;
            ns = tmp.length + 1 + tmp.length * 2 / 3;
            this.values = new int[ns];
            System.arraycopy(tmp, 0, this.values, 0, tmp.length);
        }
        if (element - this.mapOffset >= this.map.length) {
            tmp = this.map;
            ns = Math.max(element - this.mapOffset + 1, tmp.length + 1 + tmp.length * 2 / 3);
            this.map = new int[ns];
            System.arraycopy(tmp, 0, this.map, 0, tmp.length);
            for (int i = tmp.length; i < ns; ++i) {
                this.map[i] = -1;
            }
        }
        this.values[size] = element;
        this.map[element - this.mapOffset] = size;
        this.addSize(1);
        this.notifyObservingElementAdded(element);
        return true;
    }

    @Override
    public boolean remove(int element) {
        if (!this.contains(element)) {
            return false;
        }
        this.iter.notifyRemoving(element);
        int size = this.size();
        if (size > 1) {
            int idx = this.map[element - this.mapOffset];
            int replacer = this.values[size - 1];
            this.map[replacer - this.mapOffset] = idx;
            this.values[idx] = replacer;
            this.map[element - this.mapOffset] = size - 1;
            this.values[size - 1] = element;
        }
        this.addSize(-1);
        this.notifyObservingElementRemoved(element);
        return true;
    }

    @Override
    public boolean contains(int element) {
        if (element < this.mapOffset || element >= this.mapOffset + this.map.length) {
            return false;
        }
        return this.map[element - this.mapOffset] >= 0 && this.map[element - this.mapOffset] < this.size() && this.values[this.map[element - this.mapOffset]] == element;
    }

    @Override
    public int size() {
        return this.size;
    }

    protected void setSize(int s) {
        this.size = s;
    }

    protected void addSize(int delta) {
        this.size += delta;
    }

    @Override
    public void clear() {
        this.setSize(0);
        this.notifyObservingCleared();
    }

    @Override
    public int min() {
        if (this.isEmpty()) {
            throw new IllegalStateException("cannot find minimum of an empty set");
        }
        int min = this.values[0];
        for (int i = 1; i < this.size(); ++i) {
            if (min <= this.values[i]) continue;
            min = this.values[i];
        }
        return min;
    }

    @Override
    public int max() {
        if (this.isEmpty()) {
            throw new IllegalStateException("cannot find maximum of an empty set");
        }
        int max = this.values[0];
        for (int i = 1; i < this.size(); ++i) {
            if (max >= this.values[i]) continue;
            max = this.values[i];
        }
        return max;
    }

    @Override
    public String toString() {
        StringBuilder st = new StringBuilder("{");
        ISetIterator iter = this.newIterator();
        while (iter.hasNext()) {
            st.append(iter.nextInt()).append(", ");
        }
        st.append("}");
        return st.toString().replace(", }", "}");
    }

    @Override
    public SetType getSetType() {
        return SetType.BIPARTITESET;
    }

    @Override
    public ISetIterator iterator() {
        this.iter.reset();
        return this.iter;
    }

    @Override
    public ISetIterator newIterator() {
        return new ISetIterator(){
            private int idx;

            @Override
            public void reset() {
                this.idx = 0;
            }

            @Override
            public void notifyRemoving(int item) {
                if (this.idx > 0 && item == Set_Swap.this.values[this.idx - 1]) {
                    --this.idx;
                }
            }

            @Override
            public boolean hasNext() {
                return this.idx < Set_Swap.this.size();
            }

            @Override
            public int nextInt() {
                ++this.idx;
                return Set_Swap.this.values[this.idx - 1];
            }
        };
    }
}

