/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.function.BiFunction;
import org.knowm.xchart.HeatMapChart;
import org.knowm.xchart.HeatMapSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.Formatter_Custom;
import org.knowm.xchart.internal.chartpart.Legend_;
import org.knowm.xchart.style.HeatMapStyler;
import org.knowm.xchart.style.Styler;

public class Legend_HeatMap<ST extends HeatMapStyler, S extends HeatMapSeries>
extends Legend_<ST, S> {
    private static final int LEGEND_MARGIN = 6;
    private static final String SPLIT = " ~ ";
    private Format format = new DecimalFormat("");

    public Legend_HeatMap(Chart<ST, S> chart) {
        super(chart);
    }

    @Override
    public void paint(Graphics2D g) {
        if (!((HeatMapStyler)this.chart.getStyler()).isLegendVisible()) {
            return;
        }
        if (this.chart.getSeriesMap().isEmpty()) {
            return;
        }
        if (this.chart.getPlot().getBounds().getWidth() < 30.0) {
            return;
        }
        Rectangle2D bounds = this.getBounds();
        switch (((HeatMapStyler)this.chart.getStyler()).getLegendPosition()) {
            case OutsideE: {
                this.xOffset = (double)this.chart.getWidth() - bounds.getWidth() - 6.0;
                this.yOffset = this.chart.getPlot().getBounds().getY() + (this.chart.getPlot().getBounds().getHeight() - bounds.getHeight()) / 2.0;
                break;
            }
            case OutsideS: {
                this.xOffset = this.chart.getPlot().getBounds().getX() + (this.chart.getPlot().getBounds().getWidth() - bounds.getWidth()) / 2.0;
                this.yOffset = (double)this.chart.getHeight() - bounds.getHeight() - 6.0;
                break;
            }
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(this.xOffset, this.yOffset, bounds.getWidth(), bounds.getHeight());
        g.setColor(((HeatMapStyler)this.chart.getStyler()).getLegendBackgroundColor());
        g.fill(rect);
        g.setStroke(SOLID_STROKE);
        g.setColor(((HeatMapStyler)this.chart.getStyler()).getLegendBorderColor());
        g.draw(rect);
        this.doPaint(g);
    }

    @Override
    public void doPaint(Graphics2D g) {
        this.applyFormatting();
        double startx = this.xOffset + (double)((HeatMapStyler)this.chart.getStyler()).getLegendPadding();
        double starty = this.yOffset + (double)((HeatMapStyler)this.chart.getStyler()).getLegendPadding();
        Object oldHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color[] rangeColors = ((HeatMapStyler)this.chart.getStyler()).getRangeColors();
        HeatMapSeries heatMapSeries = ((HeatMapChart)this.chart).getHeatMapSeries();
        if (((HeatMapStyler)this.chart.getStyler()).isPiecewise()) {
            this.paintPiecewise(g, startx, starty, rangeColors, heatMapSeries);
        } else {
            this.paintGradient(g, startx, starty, rangeColors, heatMapSeries);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
    }

    @Override
    public double getSeriesLegendRenderGraphicHeight(S series) {
        return 0.0;
    }

    @Override
    public Rectangle2D getBounds() {
        this.applyFormatting();
        double weight = 0.0;
        double height = 0.0;
        HeatMapSeries heatMapSeries = ((HeatMapChart)this.chart).getHeatMapSeries();
        double min = heatMapSeries.getMin();
        double max = heatMapSeries.getMax();
        if (((HeatMapStyler)this.chart.getStyler()).isPiecewise()) {
            int splitNumber = ((HeatMapStyler)this.chart.getStyler()).getSplitNumber();
            double step = (max - min) / (double)splitNumber;
            String text = "";
            TextLayout textLayout = null;
            BiFunction<Double, Double, String> formattingFunction = ((HeatMapStyler)this.chart.getStyler()).isPiecewiseRanged() ? (lower, upper) -> this.format.format(lower) + SPLIT + this.format.format(upper) : (lower, upper) -> this.format.format(lower);
            for (int i = 0; i < splitNumber; ++i) {
                text = i == 0 ? formattingFunction.apply(min, min + step) : (i == splitNumber - 1 ? formattingFunction.apply(min + step * (double)i, max) : formattingFunction.apply(min + step * (double)i, min + step * (double)(i + 1)));
                textLayout = new TextLayout(text, ((HeatMapStyler)this.chart.getStyler()).getLegendFont(), new FontRenderContext(null, true, false));
                if (((HeatMapStyler)this.chart.getStyler()).getLegendLayout() == Styler.LegendLayout.Vertical) {
                    weight = Math.max(weight, textLayout.getBounds().getWidth());
                    height += (double)(((HeatMapStyler)this.chart.getStyler()).getLegendFont().getSize() + ((HeatMapStyler)this.chart.getStyler()).getLegendPadding());
                    continue;
                }
                weight += (double)(20 + ((HeatMapStyler)this.chart.getStyler()).getLegendPadding()) + textLayout.getBounds().getWidth() + (double)((HeatMapStyler)this.chart.getStyler()).getLegendPadding();
            }
            if (((HeatMapStyler)this.chart.getStyler()).getLegendLayout() == Styler.LegendLayout.Vertical) {
                weight = (double)(((HeatMapStyler)this.chart.getStyler()).getLegendPadding() + 20 + ((HeatMapStyler)this.chart.getStyler()).getLegendPadding()) + weight + (double)((HeatMapStyler)this.chart.getStyler()).getLegendPadding();
                height += (double)((HeatMapStyler)this.chart.getStyler()).getLegendPadding();
            } else {
                weight += (double)((HeatMapStyler)this.chart.getStyler()).getLegendPadding();
                height = ((HeatMapStyler)this.chart.getStyler()).getLegendPadding() + ((HeatMapStyler)this.chart.getStyler()).getLegendFont().getSize() + ((HeatMapStyler)this.chart.getStyler()).getLegendPadding();
            }
        } else {
            TextLayout textLayoutMin = new TextLayout(min + "", ((HeatMapStyler)this.chart.getStyler()).getLegendFont(), new FontRenderContext(null, true, false));
            TextLayout textLayoutMax = new TextLayout(max + "", ((HeatMapStyler)this.chart.getStyler()).getLegendFont(), new FontRenderContext(null, true, false));
            if (((HeatMapStyler)this.chart.getStyler()).getLegendLayout() == Styler.LegendLayout.Vertical) {
                weight = (double)(((HeatMapStyler)this.chart.getStyler()).getLegendPadding() + ((HeatMapStyler)this.chart.getStyler()).getGradientColorColumnWeight() + ((HeatMapStyler)this.chart.getStyler()).getLegendPadding()) + Math.max(textLayoutMin.getBounds().getWidth(), textLayoutMax.getBounds().getWidth()) + (double)((HeatMapStyler)this.chart.getStyler()).getLegendPadding();
                height = ((HeatMapStyler)this.chart.getStyler()).getLegendPadding() + ((HeatMapStyler)this.chart.getStyler()).getLegendFont().getSize() + ((HeatMapStyler)this.chart.getStyler()).getGradientColorColumnHeight() + ((HeatMapStyler)this.chart.getStyler()).getLegendFont().getSize() + ((HeatMapStyler)this.chart.getStyler()).getLegendPadding();
            } else {
                weight = (double)((HeatMapStyler)this.chart.getStyler()).getLegendPadding() + textLayoutMin.getBounds().getWidth() + (double)((HeatMapStyler)this.chart.getStyler()).getGradientColorColumnHeight() + textLayoutMax.getBounds().getWidth() + (double)((HeatMapStyler)this.chart.getStyler()).getLegendPadding();
                height = ((HeatMapStyler)this.chart.getStyler()).getLegendPadding() + ((HeatMapStyler)this.chart.getStyler()).getLegendFont().getSize() + ((HeatMapStyler)this.chart.getStyler()).getLegendPadding() + ((HeatMapStyler)this.chart.getStyler()).getGradientColorColumnWeight() + ((HeatMapStyler)this.chart.getStyler()).getLegendPadding();
            }
        }
        return new Rectangle2D.Double(0.0, 0.0, weight, height);
    }

    private void paintPiecewise(Graphics2D g, double startx, double starty, Color[] rangeColors, HeatMapSeries heatMapSeries) {
        int splitNumber = ((HeatMapStyler)this.chart.getStyler()).getSplitNumber();
        TextLayout textLayout = null;
        Rectangle2D.Double boxRect = null;
        String text = "";
        double min = heatMapSeries.getMin();
        double max = heatMapSeries.getMax();
        double step = (max - min) / (double)splitNumber;
        double y = 0.0;
        AffineTransform orig = g.getTransform();
        AffineTransform at = null;
        Color splitColor = null;
        int beginColorIndex = 0;
        int endColorIndex = 1;
        Color beginColor = null;
        Color endColor = null;
        int red = 0;
        int green = 0;
        int blue = 0;
        double index = 0.0;
        BiFunction<Double, Double, String> formattingFunction = ((HeatMapStyler)this.chart.getStyler()).isPiecewiseRanged() ? (lower, upper) -> this.format.format(lower) + SPLIT + this.format.format(upper) : (lower, upper) -> this.format.format(lower);
        for (int i = 0; i < splitNumber; ++i) {
            index = (double)i / (double)splitNumber * (double)rangeColors.length;
            if (i == 0) {
                text = formattingFunction.apply(min, min + step);
                splitColor = rangeColors[0];
            } else if (i == splitNumber - 1) {
                text = formattingFunction.apply(min + step * (double)i, max);
                splitColor = rangeColors[rangeColors.length - 1];
            } else {
                text = formattingFunction.apply(min + step * (double)i, min + step * (double)(i + 1));
                beginColorIndex = (int)index;
                endColorIndex = rangeColors.length != 1 ? beginColorIndex + 1 : beginColorIndex;
                beginColor = rangeColors[beginColorIndex];
                endColor = rangeColors[endColorIndex];
                red = (int)((double)beginColor.getRed() + (index - (double)((int)index)) * (double)(endColor.getRed() - beginColor.getRed()));
                green = (int)((double)beginColor.getGreen() + (index - (double)((int)index)) * (double)(endColor.getGreen() - beginColor.getGreen()));
                blue = (int)((double)beginColor.getBlue() + (index - (double)((int)index)) * (double)(endColor.getBlue() - beginColor.getBlue()));
                splitColor = new Color(red, green, blue);
            }
            textLayout = new TextLayout(text, ((HeatMapStyler)this.chart.getStyler()).getLegendFont(), new FontRenderContext(null, true, false));
            if (((HeatMapStyler)this.chart.getStyler()).getLegendLayout() == Styler.LegendLayout.Vertical) {
                y = starty + (double)(((HeatMapStyler)this.chart.getStyler()).getLegendPadding() * (splitNumber - i - 1)) + (double)(((HeatMapStyler)this.chart.getStyler()).getLegendFont().getSize() * (splitNumber - i - 1));
            } else {
                if (i > 0) {
                    startx += (double)(20 + ((HeatMapStyler)this.chart.getStyler()).getLegendPadding());
                }
                y = starty;
            }
            boxRect = new Rectangle2D.Double(startx, y, 20.0, textLayout.getBounds().getHeight());
            g.setColor(splitColor);
            g.fill(boxRect);
            at = new AffineTransform();
            at.translate(startx + 20.0 + (double)((HeatMapStyler)this.chart.getStyler()).getLegendPadding(), y + textLayout.getBounds().getHeight());
            g.transform(at);
            g.setColor(((HeatMapStyler)this.chart.getStyler()).getChartFontColor());
            g.setFont(((HeatMapStyler)this.chart.getStyler()).getLegendFont());
            g.fill(textLayout.getOutline(null));
            g.setTransform(orig);
            if (((HeatMapStyler)this.chart.getStyler()).getLegendLayout() != Styler.LegendLayout.Horizontal) continue;
            startx += textLayout.getBounds().getWidth() + (double)((HeatMapStyler)this.chart.getStyler()).getLegendPadding();
        }
    }

    private void paintGradient(Graphics2D g, double startx, double starty, Color[] rangeColors, HeatMapSeries heatMapSeries) {
        TextLayout textLayoutMin = new TextLayout(heatMapSeries.getMin() + "", ((HeatMapStyler)this.chart.getStyler()).getLegendFont(), new FontRenderContext(null, true, false));
        Point2D.Double start = null;
        Point2D.Double end = null;
        Rectangle2D.Double rect = null;
        if (((HeatMapStyler)this.chart.getStyler()).getLegendLayout() == Styler.LegendLayout.Vertical) {
            start = new Point2D.Double(startx, starty + (double)((HeatMapStyler)this.chart.getStyler()).getGradientColorColumnHeight());
            end = new Point2D.Double(startx, starty + (double)((HeatMapStyler)this.chart.getStyler()).getLegendFont().getSize());
            rect = new Rectangle2D.Double(startx, starty + (double)((HeatMapStyler)this.chart.getStyler()).getLegendFont().getSize(), ((HeatMapStyler)this.chart.getStyler()).getGradientColorColumnWeight(), ((HeatMapStyler)this.chart.getStyler()).getGradientColorColumnHeight());
        } else {
            start = new Point2D.Double(startx + textLayoutMin.getBounds().getWidth(), starty + (double)((HeatMapStyler)this.chart.getStyler()).getLegendFont().getSize() + (double)((HeatMapStyler)this.chart.getStyler()).getLegendPadding());
            end = new Point2D.Double(startx + textLayoutMin.getBounds().getWidth() + (double)((HeatMapStyler)this.chart.getStyler()).getGradientColorColumnHeight(), starty + (double)((HeatMapStyler)this.chart.getStyler()).getLegendFont().getSize() + (double)((HeatMapStyler)this.chart.getStyler()).getLegendPadding());
            rect = new Rectangle2D.Double(startx + textLayoutMin.getBounds().getWidth(), starty + (double)((HeatMapStyler)this.chart.getStyler()).getLegendFont().getSize() + (double)((HeatMapStyler)this.chart.getStyler()).getLegendPadding(), ((HeatMapStyler)this.chart.getStyler()).getGradientColorColumnHeight(), ((HeatMapStyler)this.chart.getStyler()).getGradientColorColumnWeight());
        }
        float[] fractions = new float[rangeColors.length];
        for (int i = 0; i < rangeColors.length; ++i) {
            fractions[i] = i == 0 ? 0.0f : (i == rangeColors.length - 1 ? 1.0f : (float)i / (float)(rangeColors.length - 1));
        }
        LinearGradientPaint lgp = new LinearGradientPaint(start, end, fractions, rangeColors);
        g.setPaint(lgp);
        g.fill(rect);
        TextLayout textLayoutMax = new TextLayout(heatMapSeries.getMax() + "", ((HeatMapStyler)this.chart.getStyler()).getLegendFont(), new FontRenderContext(null, true, false));
        double tx = 0.0;
        double ty = 0.0;
        AffineTransform orig = g.getTransform();
        AffineTransform at = new AffineTransform();
        if (((HeatMapStyler)this.chart.getStyler()).getLegendLayout() == Styler.LegendLayout.Vertical) {
            tx = startx + (double)((HeatMapStyler)this.chart.getStyler()).getGradientColorColumnWeight() + (double)((HeatMapStyler)this.chart.getStyler()).getLegendPadding();
            ty = starty + textLayoutMax.getBounds().getHeight();
        } else {
            tx = startx + textLayoutMin.getBounds().getWidth() + (double)((HeatMapStyler)this.chart.getStyler()).getGradientColorColumnHeight();
            ty = starty + (double)((HeatMapStyler)this.chart.getStyler()).getLegendFont().getSize();
        }
        at.translate(tx, ty);
        g.transform(at);
        g.setColor(((HeatMapStyler)this.chart.getStyler()).getChartFontColor());
        g.setFont(((HeatMapStyler)this.chart.getStyler()).getLegendFont());
        g.fill(textLayoutMax.getOutline(null));
        g.setTransform(orig);
        at = new AffineTransform();
        if (((HeatMapStyler)this.chart.getStyler()).getLegendLayout() == Styler.LegendLayout.Vertical) {
            tx = startx + (double)((HeatMapStyler)this.chart.getStyler()).getGradientColorColumnWeight() + (double)((HeatMapStyler)this.chart.getStyler()).getLegendPadding();
            ty = starty + (double)((HeatMapStyler)this.chart.getStyler()).getGradientColorColumnHeight() + (double)(((HeatMapStyler)this.chart.getStyler()).getLegendFont().getSize() * 2);
        } else {
            tx = startx;
            ty = starty + (double)((HeatMapStyler)this.chart.getStyler()).getLegendFont().getSize();
        }
        at.translate(tx, ty);
        g.transform(at);
        g.setColor(((HeatMapStyler)this.chart.getStyler()).getChartFontColor());
        g.setFont(((HeatMapStyler)this.chart.getStyler()).getLegendFont());
        g.fill(textLayoutMin.getOutline(null));
        g.setTransform(orig);
    }

    private void applyFormatting() {
        if (((HeatMapStyler)this.chart.getStyler()).getHeatMapDecimalValueFormatter() != null) {
            this.format = new Formatter_Custom(((HeatMapStyler)this.chart.getStyler()).getHeatMapDecimalValueFormatter());
        } else {
            this.format = new DecimalFormat("");
            if (((HeatMapStyler)this.chart.getStyler()).getHeatMapValueDecimalPattern() != null) {
                ((DecimalFormat)this.format).applyPattern(((HeatMapStyler)this.chart.getStyler()).getHeatMapValueDecimalPattern());
            }
        }
    }
}

