/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.calendars;

import java.util.Arrays;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class HolidayPattern {
    private final int start;
    private final double[] weights;

    public static HolidayPattern of(int start, Shape shape, int length) {
        double[] w = new double[length];
        shape.fill(length, w, 0);
        return new HolidayPattern(start, w);
    }

    public static HolidayPattern of(int start, Shape shape0, int length0, Shape shape1, int length1) {
        double[] w = new double[length0 + length1];
        shape0.fill(length0, w, 0);
        shape1.fill(length1, w, length0);
        return new HolidayPattern(start, w);
    }

    public static HolidayPattern of(int start, Shape shape0, int length0, Shape shape1, int length1, Shape shape2, int length2) {
        double[] w = new double[length0 + length1 + length2];
        shape0.fill(length0, w, 0);
        shape1.fill(length1, w, length0);
        shape2.fill(length2, w, length0 + length1);
        return new HolidayPattern(start, w);
    }

    public double sum() {
        double s = 0.0;
        for (int i = 0; i < this.weights.length; ++i) {
            s += this.weights[i];
        }
        return s;
    }

    public HolidayPattern normalize() {
        double s = this.sum();
        if (s == 1.0) {
            return this;
        }
        double[] w = (double[])this.weights.clone();
        int i = 0;
        while (i < w.length) {
            int n = i++;
            w[n] = w[n] / s;
        }
        return new HolidayPattern(this.start, w);
    }

    @Generated
    public HolidayPattern(int start, double[] weights) {
        this.start = start;
        this.weights = weights;
    }

    @Generated
    public int getStart() {
        return this.start;
    }

    @Generated
    public double[] getWeights() {
        return this.weights;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HolidayPattern)) {
            return false;
        }
        HolidayPattern other = (HolidayPattern)o;
        if (this.getStart() != other.getStart()) {
            return false;
        }
        return Arrays.equals(this.getWeights(), other.getWeights());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStart();
        result = result * 59 + Arrays.hashCode(this.getWeights());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "HolidayPattern(start=" + this.getStart() + ", weights=" + Arrays.toString(this.getWeights()) + ")";
    }

    public static enum Shape {
        Zero,
        Constant,
        LinearUp,
        LinearDown;


        public void fill(int length, double[] buffer, int pos) {
            switch (this.ordinal()) {
                case 1: {
                    for (int j = pos; j < pos + length; ++j) {
                        buffer[j] = 1.0;
                    }
                    break;
                }
                case 3: {
                    double dstep = 1.0 / (double)length;
                    int j = pos;
                    int k = 0;
                    while (j < pos + length) {
                        buffer[j] = 1.0 - (double)k * dstep;
                        ++j;
                        ++k;
                    }
                    break;
                }
                case 2: {
                    double step = 1.0 / (double)length;
                    int j = pos;
                    int k = length - 1;
                    while (j < pos + length) {
                        buffer[j] = 1.0 - (double)k * step;
                        ++j;
                        --k;
                    }
                    break;
                }
            }
        }
    }
}

